/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MMailText;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class PayrollViaEMail
extends SvrProcess {
    private int m_R_MailText_ID = -1;
    private MMailText m_MailText = null;
    private int m_AD_User_ID = -1;
    private MClient m_client = null;
    private MUser m_from = null;
    private ArrayList<Integer> m_list = new ArrayList();
    private int m_counter = 0;
    private int m_errors = 0;
    private int m_HR_Process_ID = -1;
    private MInterestArea m_ia = null;
    private int m_C_BP_Group_ID = -1;
    private int m_AD_Process_ID = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) {
                this.log.fine("Null paramater: " + string);
                continue;
            }
            if (string.equals("HR_Process_ID")) {
                this.m_HR_Process_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("R_MailText_ID")) {
                this.m_R_MailText_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BP_Group_ID")) {
                this.m_C_BP_Group_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("AD_User_ID")) {
                this.m_AD_User_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("AD_Process_ID")) {
                this.m_AD_Process_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.m_R_MailText_ID);
        this.m_MailText = new MMailText(this.getCtx(), this.m_R_MailText_ID, this.get_TrxName());
        if (this.m_MailText.getR_MailText_ID() == 0) {
            throw new Exception("Not found @R_MailText_ID@=" + this.m_R_MailText_ID);
        }
        this.m_client = MClient.get(this.getCtx());
        if (this.m_client.getAD_Client_ID() == 0) {
            throw new Exception("Not found @AD_Client_ID@");
        }
        if (this.m_client.getSMTPHost() == null || this.m_client.getSMTPHost().length() == 0) {
            throw new Exception("No SMTP Host found");
        }
        long l = System.currentTimeMillis();
        this.m_from = new MUser(this.getCtx(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        if (this.m_from.getAD_User_ID() == 0) {
            throw new Exception("No found @AD_User_ID@=" + this.m_AD_User_ID);
        }
        if (this.m_AD_User_ID > 0) {
            MUser mUser = new MUser(this.getCtx(), this.m_AD_User_ID, this.get_TrxName());
            this.sendIndividualMail(this.m_from.getName(), mUser.getC_BPartner_ID(), null);
        } else {
            this.sendBPGroup();
        }
        this.log.fine("From " + this.m_from);
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - l) + "ms";
    }

    private void sendBPGroup() {
        this.log.info("C_BP_Group_ID=" + this.m_C_BP_Group_ID);
        String string = " SELECT bp.Name, bp.url, bp.c_bpartner_id FROM C_BPartner bp WHERE bp.IsActive='Y' AND bp.url IS NOT NULL";
        if (this.m_C_BP_Group_ID > 0) {
            string = string + " AND bp.C_BP_Group_ID=?";
        }
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            if (this.m_C_BP_Group_ID > 0) {
                cPreparedStatement.setInt(1, this.m_C_BP_Group_ID);
            }
            ResultSet resultSet = cPreparedStatement.executeQuery();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (resultSet.next()) {
                arrayList.add(new Integer(resultSet.getInt(3)));
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Boolean bl = this.sendIndividualMail("", (Integer)arrayList.get(i), null);
                if (bl == null) continue;
                if (bl.booleanValue()) {
                    ++this.m_counter;
                    continue;
                }
                ++this.m_errors;
            }
            resultSet.close();
            cPreparedStatement.close();
            cPreparedStatement = null;
        }
        catch (SQLException sQLException) {
            this.log.log(Level.SEVERE, string, sQLException);
        }
        try {
            if (cPreparedStatement != null) {
                cPreparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this.log.log(Level.SEVERE, string, sQLException);
        }
        cPreparedStatement = null;
    }

    private Boolean sendIndividualMail(String string, int n, String string2) {
        try {
            Integer n2 = new Integer(n);
            if (this.m_list.contains(n2)) {
                return null;
            }
            this.m_list.add(n2);
            MBPartner mBPartner = new MBPartner(this.getCtx(), n, null);
            String string3 = this.m_MailText.getMailText(true);
            if (string2 != null) {
                string3 = string3 + string2;
            }
            EMail eMail = this.m_client.createEMail(this.m_from, mBPartner.getURL(), this.m_MailText.getMailHeader(), string3);
            if (this.m_MailText.isHtml()) {
                eMail.setMessageHTML(this.m_MailText.getMailHeader(), string3);
            } else {
                eMail.setSubject(this.m_MailText.getMailHeader());
                eMail.setMessageText(string3);
            }
            eMail.addAttachment(this.CreatePDF(n));
            if (!eMail.isValid() && !eMail.isValid(true)) {
                this.log.warning("NOT VALID - " + eMail);
                mBPartner.setIsActive(false);
                mBPartner.save();
                return Boolean.FALSE;
            }
            boolean bl = "OK".equals(eMail.send());
            if (bl) {
                this.log.fine(mBPartner.getURL());
            } else {
                this.log.warning("FAILURE - " + mBPartner.getURL());
            }
            this.addLog(0, null, null, (bl ? "@OK@" : "@ERROR@") + " - " + mBPartner.getURL());
            return bl;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    private File CreatePDF(int n) {
        File file = null;
        int n2 = this.m_AD_Process_ID;
        MPInstance mPInstance = new MPInstance(Env.getCtx(), n2, 0);
        if (!mPInstance.save()) {
            return null;
        }
        ProcessInfo processInfo = new ProcessInfo("PH_SendEmail", n2);
        processInfo.setAD_PInstance_ID(mPInstance.getAD_PInstance_ID());
        MPInstancePara mPInstancePara = new MPInstancePara(mPInstance, 10);
        processInfo.setRecord_ID(this.m_HR_Process_ID);
        processInfo.setIsBatch(true);
        MProcess mProcess = new MProcess(this.getCtx(), n2, this.get_TrxName());
        mProcess.processIt(processInfo, Trx.get(this.get_TrxName(), true));
        file = processInfo.getPDFReport();
        return file;
    }
}

