/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MResource;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MResourceType;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.TimeUtil;
import org.eevolution.exceptions.CRPException;
import org.eevolution.model.RoutingService;
import org.eevolution.model.reasoner.CRPReasoner;

public class CreateResourceAssignment
extends SvrProcess {
    private int p_S_Resource_ID;
    private int p_S_ResourceType_ID;
    private Timestamp p_DateFrom;
    private Timestamp p_DateTo;
    private int p_MaxIterationsNo = -1;
    public static final String SYSCONFIG_MaxIterationsNo = "CRP.MaxIterationsNo";
    public static final int DEFAULT_MaxIterationsNo = 1000;
    public RoutingService routingService = null;
    private CRPReasoner reasoner = new CRPReasoner();

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) {
                // empty if block
            }
            if (name.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("S_ResourceType_ID")) {
                this.p_S_ResourceType_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("DateFrom")) {
                this.p_DateFrom = (Timestamp)para.getParameter();
                continue;
            }
            if (name.equals("DateTo")) {
                this.p_DateTo = (Timestamp)para.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_MaxIterationsNo = MSysConfig.getIntValue(SYSCONFIG_MaxIterationsNo, 1000, this.getAD_Client_ID());
    }

    @Override
    protected String doIt() throws Exception {
        for (MResource resource : this.getResource()) {
            this.Assingment(resource);
        }
        return "@Ok@";
    }

    public List<MResource> getResource() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String where = "";
        if (this.p_S_Resource_ID > 0) {
            parameters.add(this.p_S_Resource_ID);
            where = "S_Resource_ID=? AND ";
        }
        if (this.p_S_ResourceType_ID > 0) {
            parameters.add(this.p_S_ResourceType_ID);
            where = where + "S_ResourceType_ID" + "=? ";
        }
        return new Query(this.getCtx(), "S_Resource", where, this.get_TrxName()).setParameters(parameters).setClient_ID().list();
    }

    public void Assingment(MResource resource) {
        Timestamp finishDate = this.p_DateFrom;
        Timestamp startDate = this.p_DateFrom;
        int millis = resource.getWaitingTime().intValue() * 60 * 1000;
        while (finishDate.before(this.p_DateTo)) {
            if (!this.reasoner.isAvailable(resource)) {
                throw new CRPException("@ResourceNotInSlotDay@").setS_Resource(resource);
            }
            finishDate = this.scheduleForward(finishDate, millis, resource);
            startDate = TimeUtil.addMinutess(finishDate, resource.getWaitingTime().intValue() * -1);
            this.createAssingnment(startDate, finishDate, resource);
        }
    }

    public void createAssingnment(Timestamp start, Timestamp end, MResource resource) {
        MResourceAssignment assignment = new MResourceAssignment(this.getCtx(), 0, this.get_TrxName());
        assignment.setS_Resource_ID(resource.get_ID());
        assignment.setAssignDateFrom(start);
        assignment.setAssignDateTo(end);
        assignment.setIsConfirmed(false);
        assignment.setName(".");
        assignment.saveEx();
    }

    private long getAvailableDurationMillis(Timestamp dayStart, Timestamp dayEnd, I_S_Resource resource) {
        long availableDayDuration = dayEnd.getTime() - dayStart.getTime();
        this.log.info("--> availableDayDuration  " + availableDayDuration);
        if (availableDayDuration < 0L) {
            throw new CRPException("@TimeSlotStart@ > @TimeSlotEnd@ (" + dayEnd + " > " + dayStart + ")").setS_Resource(resource);
        }
        return availableDayDuration;
    }

    private Timestamp scheduleForward(Timestamp start, long durationMillis, MResource r) {
        MResourceType t = r.getResourceType();
        int iteration = 0;
        Timestamp currentDate = start;
        Timestamp end = null;
        long remainingMillis = durationMillis;
        do {
            long availableDayDuration;
            currentDate = this.reasoner.getAvailableDate(r, currentDate, false);
            Timestamp dayStart = t.getDayStart(currentDate);
            Timestamp dayEnd = t.getDayEnd(currentDate);
            if (currentDate.after(dayStart) && currentDate.before(dayEnd) || currentDate.equals(dayEnd)) {
                dayStart = currentDate;
            }
            if ((availableDayDuration = this.getAvailableDurationMillis(dayStart, dayEnd, r)) >= remainingMillis) {
                end = new Timestamp(dayStart.getTime() + remainingMillis);
                remainingMillis = 0L;
                break;
            }
            currentDate = TimeUtil.addDays(TimeUtil.getDayBorder(currentDate, null, false), 1);
            remainingMillis -= availableDayDuration;
            if (++iteration <= this.p_MaxIterationsNo) continue;
            throw new CRPException("Maximum number of iterations exceeded (" + this.p_MaxIterationsNo + ")" + " - Date:" + currentDate + ", RemainingMillis:" + remainingMillis);
        } while (remainingMillis > 0L);
        return end;
    }
}

