/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.ProductLowLevelCalculator;
import org.eevolution.model.X_PP_Product_BOMLine;

public class MPPProductBOMLine
extends X_PP_Product_BOMLine {
    private static final long serialVersionUID = -5792418944606756221L;
    MPPProductBOM m_bom = null;

    public static List<MPPProductBOMLine> getByProduct(MProduct product) {
        String whereClause = "M_Product_ID=?";
        return new Query(product.getCtx(), "PP_Product_BOMLine", "M_Product_ID=?", product.get_TrxName()).setParameters(product.getM_Product_ID()).list();
    }

    public MPPProductBOMLine(Properties ctx, int PP_Product_BOMLine, String trxName) {
        super(ctx, PP_Product_BOMLine, trxName);
    }

    public MPPProductBOMLine(MPPProductBOM bom) {
        super(bom.getCtx(), 0, bom.get_TableName());
        if (bom.get_ID() <= 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
    }

    public MPPProductBOMLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int getLowLevel() {
        return new ProductLowLevelCalculator(this.getCtx(), this.get_TrxName()).getLowLevel(this.getM_Product_ID());
    }

    public MPPProductBOM getParent() {
        if (this.m_bom == null) {
            this.m_bom = new MPPProductBOM(this.getCtx(), this.getPP_Product_BOM_ID(), this.get_TrxName());
        }
        return this.m_bom;
    }

    public MProduct getProduct() {
        return MProduct.get(this.getCtx(), this.getM_Product_ID());
    }

    public static int getLowLevel(Properties ctx, int M_Product_ID, String trxName) {
        return new ProductLowLevelCalculator(ctx, trxName).getLowLevel(M_Product_ID);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isCoProduct() && this.getQty(false).signum() >= 0) {
            throw new AdempiereException("@Qty@ > 0");
        }
        if (this.getLine() <= 0) {
            String sql = "SELECT COALESCE(MAX(Line),0) + 10 FROM PP_Product_BOMLine WHERE PP_Product_BOM_ID=?";
            int line = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(Line),0) + 10 FROM PP_Product_BOMLine WHERE PP_Product_BOM_ID=?", this.getPP_Product_BOM_ID());
            this.setLine(line);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        int lowlevel = this.getLowLevel();
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        product.setLowLevel(lowlevel);
        product.saveEx();
        return true;
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    public boolean isByProduct() {
        String componentType = this.getComponentType();
        return "BY".equals(componentType);
    }

    public boolean isCoProduct() {
        String componentType = this.getComponentType();
        return "CP".equals(componentType);
    }

    public BigDecimal getQty(boolean includeScrapQty) {
        int precision = this.getPrecision();
        BigDecimal qty = this.isQtyPercentage() ? this.getQtyBatch().divide(Env.ONEHUNDRED, precision += 2, RoundingMode.HALF_UP) : this.getQtyBOM();
        if (includeScrapQty) {
            BigDecimal scrapDec = this.getScrap().divide(Env.ONEHUNDRED, 12, 0);
            qty = qty.divide(Env.ONE.subtract(scrapDec), precision, 4);
        }
        if (qty.scale() > precision) {
            qty = qty.setScale(precision, RoundingMode.HALF_UP);
        }
        return qty;
    }

    public BigDecimal getQty() {
        return this.getQty(false);
    }

    public int getPrecision() {
        return MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
    }

    public BigDecimal getCostAllocationPerc(boolean fallback) {
        BigDecimal qty;
        BigDecimal allocationPercent = super.getCostAllocationPerc();
        if (allocationPercent.signum() != 0) {
            return allocationPercent;
        }
        if (fallback && (qty = this.getQty(false).negate()).signum() != 0) {
            allocationPercent = Env.ONE.divide(qty, 4, RoundingMode.HALF_UP);
        }
        return allocationPercent;
    }
}

