/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MCalendar;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.X_HR_Payroll;

public class MHRPayroll
extends X_HR_Payroll {
    private static final long serialVersionUID = -1407037967021019961L;
    private static CCache<Integer, MHRPayroll> s_cache = new CCache("HR_Payroll", 10);
    private static CCache<String, MHRPayroll> s_cacheValue = new CCache("HR_Payroll_Value", 10);

    public static MHRPayroll forValue(Properties properties, String string) {
        if (Util.isEmpty(string, true)) {
            return null;
        }
        int n = Env.getAD_Client_ID(properties);
        String string2 = n + "#" + string;
        MHRPayroll mHRPayroll = s_cacheValue.get(string2);
        if (mHRPayroll != null) {
            return mHRPayroll;
        }
        mHRPayroll = (MHRPayroll)new Query(properties, "HR_Payroll", "Value=? AND AD_Client_ID IN (?,?)", null).setParameters(string, 0, n).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (mHRPayroll != null) {
            s_cacheValue.put(string2, mHRPayroll);
            s_cache.put(mHRPayroll.get_ID(), mHRPayroll);
        }
        return mHRPayroll;
    }

    public static MHRPayroll get(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MHRPayroll mHRPayroll = s_cache.get(n);
        if (mHRPayroll != null) {
            return mHRPayroll;
        }
        mHRPayroll = new MHRPayroll(properties, n, null);
        if (mHRPayroll.get_ID() == n) {
            s_cache.put(n, mHRPayroll);
        } else {
            mHRPayroll = null;
        }
        return mHRPayroll;
    }

    public MHRPayroll(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setProcessing(false);
        }
    }

    public MHRPayroll(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MHRPayroll(MCalendar mCalendar) {
        this(mCalendar.getCtx(), 0, mCalendar.get_TrxName());
        this.setClientOrg(mCalendar);
    }
}

