/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Acl;
import com.google.api.services.calendar.model.AclRule;
import com.google.api.services.calendar.model.CalendarList;
import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventAttendee;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.api.services.calendar.model.Events;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GoogleCalendarUtils {
    private String adresseMail = "";
    com.google.api.services.calendar.Calendar _service = null;

    public GoogleCalendarUtils(String adresseMail, String motDePasse, String nomApp, String accompteGoogleID, String pathPrivateKeyGoogle) {
        System.out.println("Cr\u00e9ation d'un GoogleCalendarUtils !");
        this.adresseMail = adresseMail;
        try {
            GoogleCredential credential = !StringUtils.isEmpty((String)adresseMail) ? new GoogleCredential.Builder().setTransport((HttpTransport)GoogleNetHttpTransport.newTrustedTransport()).setJsonFactory((JsonFactory)new GsonFactory()).setServiceAccountId(accompteGoogleID).setServiceAccountScopes(Arrays.asList("https://www.googleapis.com/auth/calendar")).setServiceAccountPrivateKeyFromP12File(new File(pathPrivateKeyGoogle)).setServiceAccountUser(adresseMail).build() : new GoogleCredential.Builder().setTransport((HttpTransport)GoogleNetHttpTransport.newTrustedTransport()).setJsonFactory((JsonFactory)new GsonFactory()).setServiceAccountId(accompteGoogleID).setServiceAccountScopes(Arrays.asList("https://www.googleapis.com/auth/calendar")).setServiceAccountPrivateKeyFromP12File(new File(pathPrivateKeyGoogle)).build();
            this._service = new Calendar.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)credential).build();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CalendarList listAgenda() {
        CalendarList calendarList = null;
        System.out.println("------- List Shared Calendar -------");
        try {
            calendarList = (CalendarList)this._service.calendarList().list().execute();
            for (CalendarListEntry calendar : calendarList.getItems()) {
                System.out.println(StringUtils.isEmpty((String)calendar.getSummary()) ? "" : calendar.getSummary());
                System.out.println(StringUtils.isEmpty((String)calendar.getDescription()) ? "" : calendar.getDescription());
                System.out.println("--------------");
            }
            return calendarList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return calendarList;
        }
    }

    public String addAgenda(String titreNewAgenda, String descriptionNewAgenda, String fuseauHoraire) {
        try {
            System.out.println("------- Add Calendar -------");
            com.google.api.services.calendar.model.Calendar calendar = new com.google.api.services.calendar.model.Calendar();
            calendar.setSummary(titreNewAgenda);
            calendar.setDescription(descriptionNewAgenda);
            calendar.setTimeZone(fuseauHoraire);
            calendar.setLocation("");
            com.google.api.services.calendar.model.Calendar returnedCalendar = (com.google.api.services.calendar.model.Calendar)this._service.calendars().insert(calendar).execute();
            System.out.println(returnedCalendar.getId());
            System.out.println(this.getId(returnedCalendar.getId()));
            return this.getId(returnedCalendar.getId());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public com.google.api.services.calendar.model.Calendar readAgenda(String idAgenda) {
        com.google.api.services.calendar.model.Calendar calendar = null;
        try {
            System.out.println("------- Read Calendar -------");
            calendar = (com.google.api.services.calendar.model.Calendar)this._service.calendars().get(idAgenda).execute();
            System.out.println(StringUtils.isEmpty((String)calendar.getSummary()) ? "" : calendar.getSummary());
            System.out.println(StringUtils.isEmpty((String)calendar.getDescription()) ? "" : calendar.getDescription());
            System.out.println("--------------");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return calendar;
    }

    public void editAgenda(String idAgenda, String titreAgenda, String descriptionAgenda) {
        com.google.api.services.calendar.model.Calendar calendar = null;
        try {
            System.out.println("------- Update Calendar -------");
            calendar = (com.google.api.services.calendar.model.Calendar)this._service.calendars().get(idAgenda).execute();
            calendar.setSummary(titreAgenda);
            calendar.setDescription(descriptionAgenda);
            com.google.api.services.calendar.model.Calendar updatedCalendar = (com.google.api.services.calendar.model.Calendar)this._service.calendars().update(calendar.getId(), calendar).execute();
            System.out.println(updatedCalendar.getEtag());
            System.out.println("--------------");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeAgenda(String idAgendaASupprimer) {
        try {
            System.out.println("------- Delete Calendar -------");
            this._service.calendars().delete(idAgendaASupprimer).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void listShareAgenda(String idAgenda) {
    }

    public void shareAgenda(String adresseAPartager, String idAgendaAPartager, boolean write) {
        try {
            System.out.println("------- Share Calendar -------");
            AclRule aclrule = new AclRule();
            AclRule.Scope scope = new AclRule.Scope();
            scope.setType("user");
            scope.setValue(idAgendaAPartager);
            aclrule.setScope(scope);
            if (write) {
                aclrule.setRole("writer");
            } else {
                aclrule.setRole("reader");
            }
            this._service.acl().insert(idAgendaAPartager, aclrule).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopShareAgenda(String adresseAPlusPartager, String idAgendaAPlusPartager) {
        try {
            System.out.println("------- Stop Share Calendar -------");
            Acl acl = (Acl)this._service.acl().list(idAgendaAPlusPartager).execute();
            for (AclRule aclRule : acl.getItems()) {
                if (!aclRule.getScope().getType().equals("user") || !aclRule.getScope().getValue().equals(adresseAPlusPartager)) continue;
                this._service.acl().delete(idAgendaAPlusPartager, aclRule.getId()).execute();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<Event> listEvenementAgenda(String idAgenda, int start, int end) {
        ArrayList<Event> listEvent = new ArrayList<Event>();
        try {
            System.out.println("------- List Event Calendar -------");
            System.out.println("------- " + idAgenda + " -------");
            Calendar startRange = Calendar.getInstance();
            startRange.add(5, start);
            DateTime startRangeDateTime = new DateTime(startRange.getTimeInMillis());
            Calendar endRande = Calendar.getInstance();
            endRande.add(5, end);
            DateTime endRangeDateTime = new DateTime(endRande.getTimeInMillis());
            Events events = null;
            events = start == 0 && end == 0 ? (Events)this._service.events().list(idAgenda).execute() : (start != 0 && end == 0 ? (Events)this._service.events().list(idAgenda).setTimeMin(startRangeDateTime).execute() : (start == 0 && end != 0 ? (Events)this._service.events().list(idAgenda).setTimeMax(endRangeDateTime).execute() : (Events)this._service.events().list(idAgenda).setTimeMin(startRangeDateTime).setTimeMax(endRangeDateTime).execute()));
            if (events == null) {
                return null;
            }
            return events.getItems();
        }
        catch (IOException e) {
            e.printStackTrace();
            return listEvent;
        }
    }

    public String addEvenement(Timestamp dateDebut, Timestamp dateFin, String fuseauHoraire, String titre, String description, String idAgenda, String adresse) {
        try {
            System.out.println("------- Add Event Calendar -------");
            Event event = new Event();
            event.setSummary(titre);
            event.setDescription(description);
            event.setLocation(adresse);
            DateTime startTime = new DateTime(dateDebut.getTime());
            DateTime endTime = new DateTime(dateFin.getTime());
            EventDateTime start = new EventDateTime();
            start.setTimeZone(fuseauHoraire);
            start.setDateTime(startTime);
            EventDateTime end = new EventDateTime();
            end.setTimeZone(fuseauHoraire);
            end.setDateTime(endTime);
            event.setStart(start);
            event.setEnd(end);
            event.setGuestsCanModify(Boolean.valueOf(false));
            event.setGuestsCanInviteOthers(Boolean.valueOf(false));
            event.setGuestsCanSeeOtherGuests(Boolean.valueOf(false));
            Event.Creator creator = new Event.Creator();
            creator.setEmail(this.adresseMail);
            creator.setDisplayName(this.adresseMail);
            event.setCreator(creator);
            Event creaEvent = (Event)this._service.events().insert(idAgenda, event).setSendNotifications(Boolean.valueOf(true)).execute();
            System.out.println(creaEvent.getId());
            return creaEvent.getId();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Event getEvenement(String idAgenda, String idEvenement) {
        Event event = null;
        try {
            System.out.println("------- Get Event Calendar -------");
            event = (Event)this._service.events().get(idAgenda, idEvenement).execute();
            System.out.println(event.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return event;
    }

    public Timestamp editEvenement(String idAgenda, String idEvenement, Timestamp dateDebut, Timestamp dateFin, String fuseauHoraire, String titre, String description, String adresse) {
        Timestamp updatedTimestamp = null;
        try {
            System.out.println("------- Update Event Calendar -------");
            Event event = (Event)this._service.events().get(idAgenda, idEvenement).execute();
            event.setSummary(titre);
            event.setDescription(description);
            event.setLocation(adresse);
            DateTime startTime = new DateTime(dateDebut.getTime());
            DateTime endTime = new DateTime(dateFin.getTime());
            EventDateTime start = new EventDateTime();
            start.setTimeZone(fuseauHoraire);
            start.setDateTime(startTime);
            EventDateTime end = new EventDateTime();
            end.setTimeZone(fuseauHoraire);
            end.setDateTime(endTime);
            event.setStart(start);
            event.setEnd(end);
            event.setGuestsCanModify(Boolean.valueOf(false));
            event.setGuestsCanInviteOthers(Boolean.valueOf(false));
            event.setGuestsCanSeeOtherGuests(Boolean.valueOf(false));
            Event updatedEvent = (Event)this._service.events().update(idAgenda, idEvenement, event).setSendNotifications(Boolean.valueOf(true)).execute();
            System.out.println(updatedEvent.getUpdated());
            System.out.println("--------------");
            Timestamp updated = new Timestamp(updatedEvent.getUpdated().getValue());
            updated.setNanos(0);
            return updated;
        }
        catch (IOException e) {
            e.printStackTrace();
            return updatedTimestamp;
        }
    }

    public void removeEvenement(String idAgenda, String idEvenement) {
        try {
            System.out.println("------- Delete Event Calendar -------");
            this._service.events().delete(idAgenda, idEvenement).setSendNotifications(Boolean.valueOf(true)).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String addRecurrentEvent(String heureDebut, String heureFin, String dateDebut, String dateFin, String nombreRepetition, String titre, String description, String idAgenda, String adressePostale, boolean month, boolean week, boolean lundi, boolean mardi, boolean mercredi, boolean jeudi, boolean vendredi, boolean samedi, boolean dimanche) {
        return "";
    }

    public Event readEvenementRecurrent(String idAgenda, String idEvenement) {
        Event event = null;
        return event;
    }

    public String addRecurrentEventByDay(String heureDebut, String heureFin, String dateDebut, String dateFin, String titre, String description, String idAgenda, String adresse, boolean lundi, boolean mardi, boolean mercredi, boolean jeudi, boolean vendredi, boolean samedi, boolean dimanche) {
        return "";
    }

    public String addRecurrentEventByMonth(String heureDebut, String heureFin, String dateDebut, String dateFin, String titre, String description, String idAgenda, String adresse) {
        return "";
    }

    public void shareEvenement(String idAgendaAPartager, String idEvenementAPartager, String adresseAPartager) {
        try {
            System.out.println("------- Share Event -------");
            Event event = (Event)this._service.events().get(idAgendaAPartager, idEvenementAPartager).execute();
            if (event.getCreator().getEmail().equals(adresseAPartager)) {
                return;
            }
            EventAttendee eventAttendee = new EventAttendee();
            eventAttendee.setEmail(adresseAPartager);
            eventAttendee.setOrganizer(Boolean.valueOf(false));
            ArrayList<EventAttendee> attendees = event.getAttendees();
            if (attendees != null) {
                event.getAttendees().add(eventAttendee);
            } else {
                attendees = new ArrayList<EventAttendee>();
                attendees.add(eventAttendee);
                event.setAttendees(attendees);
            }
            Event updatedEvent = (Event)this._service.events().update(idAgendaAPartager, idEvenementAPartager, event).setSendNotifications(Boolean.valueOf(true)).execute();
            System.out.println(updatedEvent.getUpdated());
            System.out.println("--------------");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopShareEvenement(String idAgendaAPlusPartager, String idEvenementAPlusPartager, String adresseAPlusPartager) {
        try {
            System.out.println("------- Stop Share Event -------");
            Event event = (Event)this._service.events().get(idAgendaAPlusPartager, idEvenementAPlusPartager).execute();
            ArrayList<EventAttendee> eventAttendees = new ArrayList<EventAttendee>();
            for (EventAttendee eventAttendee : event.getAttendees()) {
                if (eventAttendee.getEmail().equals(adresseAPlusPartager)) continue;
                eventAttendees.add(eventAttendee);
            }
            event.setAttendees(eventAttendees);
            Event updatedEvent = (Event)this._service.events().update(idAgendaAPlusPartager, idEvenementAPlusPartager, event).setSendNotifications(Boolean.valueOf(true)).execute();
            System.out.println(updatedEvent.getUpdated());
            System.out.println("--------------");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> listShareEvenement(String idAgenda, String idEvenement) {
        ArrayList<String> participants = new ArrayList<String>();
        try {
            System.out.println("------- List Shared Event -------");
            Event event = (Event)this._service.events().get(idAgenda, idEvenement).execute();
            List attendees = event.getAttendees();
            if (attendees == null) {
                return null;
            }
            for (EventAttendee eventAttendee : event.getAttendees()) {
                System.out.println(eventAttendee.getEmail());
                participants.add(eventAttendee.getEmail());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return participants;
    }

    public String participantResponse(String idAgenda, String idEvenement, String adresseMail) {
        return "";
    }

    public String getId(String chaineId) {
        String[] str = chaineId.split("/");
        return str[str.length - 1];
    }

    public String getReponse(String chaineReponse) {
        if (chaineReponse == null) {
            return "null";
        }
        String[] str = chaineReponse.toString().split("[.]");
        System.out.print("\t\t R\u00e9ponse : ");
        if (str[str.length - 1].equals("invited")) {
            System.out.println("EN ATTENTE");
            return "EN ATTENTE";
        }
        if (str[str.length - 1].equals("accepted")) {
            System.out.println("OUI");
            return "OUI";
        }
        if (str[str.length - 1].equals("tentative")) {
            System.out.println("PEUT-ETRE");
            return "PEUT-ETRE";
        }
        if (str[str.length - 1].equals("declined")) {
            System.out.println("NON");
            return "NON";
        }
        return "";
    }

    public String createStringDayRecur(boolean lundi, boolean mardi, boolean mercredi, boolean jeudi, boolean vendredi, boolean samedi, boolean dimanche) {
        String dayRecur = "";
        if (lundi) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "Mo";
        }
        if (mardi) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "Tu";
        }
        if (mercredi) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "We";
        }
        if (jeudi) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "Th";
        }
        if (vendredi) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "Fr";
        }
        if (samedi) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "Sa";
        }
        if (dimanche) {
            if (dayRecur.length() != 0) {
                dayRecur = dayRecur + ",";
            }
            dayRecur = dayRecur + "Su";
        }
        return dayRecur;
    }
}

