/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento.sae;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.sae.MagentoAPISAE;

public class MagentoSyncSAEStockAdempiereToMagento {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPISAE api;
    private Properties context;

    public MagentoSyncSAEStockAdempiereToMagento(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPISAE api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public boolean processSync() {
        return this.syncStock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncStock() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT _pro.M_Product_ID, _asso.z_magento_attr FROM M_Product _pro INNER JOIN z_ecommerce_m_product _asso ON _pro.M_Product_ID = _asso.M_Product_ID INNER JOIN m_storage _trx ON _pro.M_Product_ID = _trx.M_Product_ID WHERE _pro.productType != 'S' AND _pro.Z_Magento_OnDemand = 'N' AND _asso.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + " AND _pro.ad_client_id = " + this.zECommerceParamtereBean.getAD_Client_ID() + " AND (_pro.ad_org_id = 0 OR _pro.ad_org_id = " + this.zECommerceParamtereBean.getAD_Org_ID() + ")" + " AND _asso.lastsynchronized IS NOT NULL" + " AND (_asso.lastsynchronizedstock IS NULL" + " OR _asso.lastsynchronizedstock < _trx.updated" + " OR (_pro.group1 IS NOT NULL AND 0 < (SELECT COUNT(_groupProd.M_Product_ID)" + " FROM M_Product _groupProd " + " INNER JOIN m_storage _groupTrx ON _groupProd.M_Product_ID = _groupTrx.M_Product_ID" + " WHERE _groupProd.group1 = _pro.group1 " + " AND _groupProd.productType != 'S'" + " AND (_asso.lastsynchronizedstock IS NULL OR _asso.lastsynchronizedstock < _groupTrx.updated)" + " )))" + " GROUP BY _pro.M_Product_ID, _asso.z_magento_attr";
        ArrayList productToSync = new ArrayList();
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("M_Product_ID", rs.getInt(1));
                map.put("attributeSet", rs.getString(2));
                productToSync.add(map);
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        System.out.println("Product Stock adempiere \u00e0 envoyer vers Magento : " + productToSync.size());
        boolean isOK = true;
        if (productToSync.size() > 0) {
            int idUser = Env.getAD_User_ID(this.getCtx());
            String table2 = "Z_ECommerce_M_Product";
            String key = "M_Product_ID";
            for (Map map : productToSync) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                try {
                    String[] attrTab;
                    MProduct mProduct = (MProduct)new Query(this.getCtx(), "M_Product", "M_Product_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)((Integer)map.get("M_Product_ID"))).first();
                    String attributeSet = null;
                    String attributeSetOption = null;
                    String attr = (String)map.get("attributeSet");
                    if (StringUtils.isNotEmpty((String)attr) && (attrTab = attr.split(";")).length > 0 && StringUtils.isNotEmpty((String)attrTab[0])) {
                        attributeSet = attrTab[0];
                        if (attrTab.length > 1 && StringUtils.isNotEmpty((String)attrTab[1])) {
                            attributeSetOption = attrTab[1];
                        }
                    }
                    try {
                        if (!mProduct.getProductType().equals("S") && !mProduct.get_ValueAsBoolean("Z_Magento_OnDemand")) {
                            this.api.updateStock(mProduct, this.zECommerceParamtereBean, trx, attributeSet, attributeSetOption, this.getCtx());
                        }
                        MagentoUtils.updateZECommerceAssoStock(table2, key, mProduct.get_ID(), this.zECommerceParamtereBean, pstmt, trx, idUser);
                    }
                    catch (Throwable e) {
                        isOK = false;
                        this.log.log(Level.SEVERE, "Erreur lors de la mise \u00e0 jour Stock du produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                    }
                    finally {
                        DB.close(null, pstmt);
                        pstmt = null;
                    }
                    if (!isOK) {
                        trx.rollback();
                        continue;
                    }
                    trx.commit(true);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "L'article " + (Integer)map.get("M_Product_ID") + " n'a pas \u00e9t\u00e9 export\u00e9 Stock vers magento");
                    e.printStackTrace();
                    trx.rollback();
                }
                finally {
                    trx.close();
                }
            }
            return true;
        }
        return false;
    }
}

