/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento.sae;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.PreparedStatement;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MImage;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.sae.MagentoAPISAE;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.AssociativeArray;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.AssociativeEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductImageEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductInfoRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductReturnEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.Filters;

public class MagentoSyncSAERepriseMagentoProductDescPictureProcess
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    private String magentoImageExists(List<CatalogProductImageEntity> imageList, int position) {
        for (CatalogProductImageEntity image : imageList) {
            if (Integer.parseInt(image.getPosition()) != position) continue;
            return image.getFile();
        }
        return null;
    }

    private String magentoImageLabel(CatalogProductImageEntity image) {
        if (image.getFile().contains("/")) {
            return image.getFile().substring(image.getFile().lastIndexOf("/") + 1);
        }
        return image.getFile();
    }

    private String magentoImageLabel(List<CatalogProductImageEntity> imageList, int position) {
        for (CatalogProductImageEntity image : imageList) {
            if (Integer.parseInt(image.getPosition()) != position) continue;
            if (image.getFile().contains("/")) {
                return image.getFile().substring(image.getFile().lastIndexOf("/") + 1);
            }
            return image.getFile();
        }
        return null;
    }

    private String magentoImageUrl(List<CatalogProductImageEntity> imageList, int position) {
        for (CatalogProductImageEntity image : imageList) {
            if (Integer.parseInt(image.getPosition()) != position) continue;
            return image.getUrl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        Properties envContext = Env.getCtx();
        List<ZECommerceParameterBean> zECommerceParameterList = MagentoUtils.getZECommerceParameterBeanList();
        for (ZECommerceParameterBean parameter : zECommerceParameterList) {
            try {
                Date start = new Date();
                System.out.println("Sync ECommerce Reprise de donn\u00e9es " + parameter.getZ_ECommerce_Type().getLibelle() + " " + parameter.getTitle() + " - Start : " + start);
                Properties context = (Properties)envContext.clone();
                context.setProperty("#AD_Client_ID", parameter.getAD_Client_ID() + "");
                context.setProperty("#AD_Org_ID", parameter.getAD_Org_ID() + "");
                MagentoAPISAE api = new MagentoAPISAE(parameter);
                MagentoSyncProductAndCategoryRepriseDonneeSAE productCategorySync = new MagentoSyncProductAndCategoryRepriseDonneeSAE(parameter, api, context);
                productCategorySync.processSync();
            }
            catch (Throwable ex) {
                this.log.log(Level.SEVERE, "Erreur synchro : " + parameter.getId() + " - " + parameter.getTitle(), ex);
            }
            finally {
                Date end = new Date();
                System.out.println("Sync ECommerce Reprise de donn\u00e9es " + parameter.getZ_ECommerce_Type().getLibelle() + " " + parameter.getTitle() + " - End : " + end);
            }
        }
        return null;
    }

    private class MagentoSyncProductAndCategoryRepriseDonneeSAE {
        protected CLogger log = CLogger.getCLogger(this.getClass());
        private ZECommerceParameterBean zECommerceParamtereBean;
        private MagentoAPISAE api;
        private Properties context;

        public MagentoSyncProductAndCategoryRepriseDonneeSAE(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPISAE api, Properties context) {
            this.zECommerceParamtereBean = zECommerceParamtereBean;
            this.api = api;
            this.context = context;
        }

        private Properties getCtx() {
            return this.context;
        }

        public void processSync() {
            this.syncProduct();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncProduct() {
            int idUser = Env.getAD_User_ID(this.getCtx());
            String table2 = "Z_ECommerce_M_Product";
            String key = "M_Product_ID";
            String keyID = "Z_ECommerce_M_Product_ID";
            CatalogProductListRequestParam imageListRequest = new CatalogProductListRequestParam();
            imageListRequest.setSessionId(this.api.getSessionID());
            Filters filters = new Filters();
            AssociativeArray attay = new AssociativeArray();
            AssociativeEntity asso = new AssociativeEntity();
            asso.setKey("status");
            asso.setValue("1");
            attay.getComplexObjectArray().add(asso);
            asso = new AssociativeEntity();
            asso.setKey("visibility");
            asso.setValue("4");
            attay.getComplexObjectArray().add(asso);
            filters.setFilter(attay);
            imageListRequest.setFilters(filters);
            CatalogProductEntityArray array = this.api.getWebservice().catalogProductList(imageListRequest).getResult();
            int cpt = 0;
            if (array != null && array.getComplexObjectArray() != null) {
                System.out.println("NB Product : " + array.getComplexObjectArray().size());
                for (CatalogProductEntity entityProduct : array.getComplexObjectArray()) {
                    CatalogProductInfoRequestParam productInfoRequest = new CatalogProductInfoRequestParam();
                    productInfoRequest.setProductId(entityProduct.getProductId());
                    productInfoRequest.setSessionId(this.api.getSessionID());
                    CatalogProductReturnEntity p2 = this.api.getWebservice().catalogProductInfo(productInfoRequest).getResult();
                    Trx trx = Trx.get(Trx.createTrxName(), false);
                    boolean isOK = false;
                    try {
                        String skuTRIMED = p2.getSku().trim();
                        skuTRIMED = skuTRIMED.contains(" ") ? skuTRIMED.substring(0, skuTRIMED.indexOf(" ")) : skuTRIMED;
                        MProduct mProduct = (MProduct)new Query(this.getCtx(), "M_Product", "UPPER(value) LIKE " + DB.TO_STRING(skuTRIMED.toUpperCase()) + " OR UPPER(Group1) LIKE " + DB.TO_STRING(skuTRIMED.toUpperCase()), trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().first();
                        if (mProduct != null && mProduct.getM_Product_ID() > 0 && mProduct.isActive()) {
                            System.out.println("Datas;" + skuTRIMED + ";" + p2.getProductId() + ";" + p2.getSet() + ";" + p2.getType() + ";" + p2.getSku() + ";" + p2.getName());
                            if ("4".equalsIgnoreCase(p2.getVisibility())) {
                                List<CatalogProductImageEntity> imageList = null;
                                PreparedStatement pstmt = null;
                                try {
                                    mProduct.set_ValueOfColumn("Z_Magento_Name", (Object)p2.getName());
                                    mProduct.set_ValueOfColumn("Z_Magento_Short_Desc", (Object)p2.getShortDescription());
                                    mProduct.set_ValueOfColumn("Z_Magento_Desc", (Object)p2.getDescription());
                                    imageList = this.api.getProductImageInfo(p2.getSku()).getComplexObjectArray();
                                    if (imageList != null) {
                                        int index = 1;
                                        for (CatalogProductImageEntity image : imageList) {
                                            if (image.getFile() == null) continue;
                                            MImage mImage = new MImage(Env.getCtx(), 0, trx.getTrxName());
                                            mImage.setName(MagentoSyncSAERepriseMagentoProductDescPictureProcess.this.magentoImageLabel(image));
                                            mImage.setImageURL(MagentoSyncSAERepriseMagentoProductDescPictureProcess.this.magentoImageLabel(image));
                                            mImage.setEntityType("D");
                                            mImage.setIsActive(true);
                                            URL url = new URL(image.getUrl());
                                            InputStream inputStream = url.openStream();
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            byte[] buf = new byte[1000];
                                            int byteread = 0;
                                            while ((byteread = inputStream.read(buf)) != -1) {
                                                baos.write(buf, 0, byteread);
                                            }
                                            mImage.setBinaryData(baos.toByteArray());
                                            inputStream.close();
                                            baos.close();
                                            boolean imageOK = mImage.save();
                                            if (imageOK) {
                                                if (index <= 3) {
                                                    mProduct.set_ValueOfColumn("Z_Magento_Photo" + index++ + "_ID", (Object)mImage.get_ID());
                                                    continue;
                                                }
                                                System.out.println("Trop d'image pour le produit - " + mProduct.get_ID() + " - " + p2.getSku() + " - " + MagentoSyncSAERepriseMagentoProductDescPictureProcess.this.magentoImageLabel(image));
                                                continue;
                                            }
                                            System.out.println("Image NOT OK - " + mProduct.get_ID() + " - " + p2.getSku() + " - " + MagentoSyncSAERepriseMagentoProductDescPictureProcess.this.magentoImageLabel(image));
                                        }
                                    }
                                    mProduct.saveEx();
                                    try {
                                        MagentoUtils.insertZECommerceAsso(table2, key, keyID, mProduct.get_ID(), this.zECommerceParamtereBean, pstmt, trx, idUser);
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    isOK = true;
                                    ++cpt;
                                }
                                catch (Exception e) {
                                    isOK = false;
                                    this.log.log(Level.SEVERE, "Erreur lors de la r\u00e9cup\u00e9ration du produit " + mProduct.getName());
                                    e.printStackTrace();
                                }
                                finally {
                                    DB.close(null, pstmt);
                                    pstmt = null;
                                }
                            } else {
                                isOK = true;
                            }
                        } else {
                            System.out.println("Datas NON TROUVE;" + skuTRIMED + ";" + p2.getProductId() + ";" + p2.getSet() + ";" + p2.getType() + ";" + p2.getSku() + ";" + p2.getName());
                        }
                        if (!isOK) {
                            trx.rollback();
                            continue;
                        }
                        trx.commit(true);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Impossible pour : " + p2.getSku());
                        e.printStackTrace();
                        trx.rollback();
                    }
                    finally {
                        trx.close();
                    }
                }
            }
            System.out.println("Nb Product Repris : " + cpt);
        }
    }
}

