/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento.sae;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.sae.MagentoAPISAE;
import org.compiere.util.sogexis.ecommerce.magento.sae.MagentoSyncSAEProductAndCategoryAdempiereToMagento;
import org.compiere.util.sogexis.ecommerce.magento.sae.MagentoSyncSAEStockAdempiereToMagento;

public class MagentoSyncSAEProcess
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        Properties envContext = Env.getCtx();
        List<ZECommerceParameterBean> zECommerceParameterList = MagentoUtils.getZECommerceParameterBeanList();
        for (ZECommerceParameterBean parameter : zECommerceParameterList) {
            try {
                Date start = new Date();
                System.out.println("Sync ECommerce " + parameter.getZ_ECommerce_Type().getLibelle() + " " + parameter.getTitle() + " - Start : " + start);
                Properties context = (Properties)envContext.clone();
                context.setProperty("#AD_Client_ID", parameter.getAD_Client_ID() + "");
                context.setProperty("#AD_Org_ID", parameter.getAD_Org_ID() + "");
                MagentoAPISAE api = new MagentoAPISAE(parameter);
                MagentoSyncSAEProductAndCategoryAdempiereToMagento productCategorySync = new MagentoSyncSAEProductAndCategoryAdempiereToMagento(parameter, api, context);
                boolean isPorduct = productCategorySync.processSync();
                MagentoSyncSAEStockAdempiereToMagento stockSync = new MagentoSyncSAEStockAdempiereToMagento(parameter, api, context);
                boolean isStock = stockSync.processSync();
                if (!isPorduct && !isStock) continue;
                api.updateCacheIndex();
            }
            catch (Throwable ex) {
                this.log.log(Level.SEVERE, "Erreur synchro : " + parameter.getId() + " - " + parameter.getTitle(), ex);
            }
            finally {
                Date end = new Date();
                System.out.println("Sync ECommerce " + parameter.getZ_ECommerce_Type().getLibelle() + " " + parameter.getTitle() + " - End : " + end);
            }
        }
        return null;
    }
}

