/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento.sae;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.I_M_Product_Category;
import org.compiere.model.MImage;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.ArrayOfString;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.AssociativeArray;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.AssociativeEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogInventoryStockItemUpdateEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogInventoryStockItemUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductAttributeMediaCreateEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductAttributeMediaCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductAttributeMediaListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductAttributeMediaRemoveRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductAttributeMediaUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductCreateEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductCreateResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductImageEntityArray;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductImageFileEntity;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductListRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductListResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.CatalogProductUpdateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.Filters;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.LoginParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.LoginResponseParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.MageApiModelServerWsiHandlerPortType;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.SyncCatalogCategoryCreateRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.SyncCatalogCategoryEntityCreate;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.SyncCatalogCategoryUpdateCacheRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.SyncCatalogCategoryUpdatePositionRequestParam;
import org.compiere.util.sogexis.ecommerce.magento.sae.wsclient.SyncCatalogCategoryUpdateRequestParam;

public class MagentoAPISAE {
    private MageApiModelServerWsiHandlerPortType webservice;
    private String sessionID;

    public MagentoAPISAE(ZECommerceParameterBean parameterBean) {
        try {
            this.webservice = this.initWebService(parameterBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)parameterBean.getZ_Login())) {
            throw new AdempiereException("Il n'y a pas de login pour le webservice Magento (SOGEXIS_WEBSERVICE_MAGENTO_LOGIN)");
        }
        if (StringUtils.isEmpty((String)parameterBean.getZ_Password())) {
            throw new AdempiereException("Il n'y a pas de mot de passe pour le webservice Magento (SOGEXIS_WEBSERVICE_MAGENTO_PASSWORD)");
        }
        this.sessionID = this.loginWebService(parameterBean.getZ_Login(), parameterBean.getZ_Password());
    }

    private MageApiModelServerWsiHandlerPortType initWebService(ZECommerceParameterBean parameterBean) throws Exception {
        if (StringUtils.isEmpty((String)parameterBean.getUrl())) {
            throw new AdempiereException("Il n'y a pas d'adresse pour la queue de message Magento");
        }
        URL url = new URL(parameterBean.getUrl());
        QName qname = new QName("urn:Magento", "MagentoService");
        Service service = Service.create((URL)url, (QName)qname);
        return (MageApiModelServerWsiHandlerPortType)service.getPort(MageApiModelServerWsiHandlerPortType.class);
    }

    public String loginWebService(String username, String apikey) {
        LoginParam param = new LoginParam();
        param.setUsername(username);
        param.setApiKey(apikey);
        LoginResponseParam loginResponse = this.webservice.login(param);
        return loginResponse.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getGroupedProductMapping(MProduct mProduct, ZECommerceParameterBean zECommerceParameterBean, Trx trx, String attributeSet, String attributeSetOption, Properties ctx) throws Exception {
        if (StringUtils.isEmpty((String)attributeSetOption) || StringUtils.isEmpty((String)attributeSet)) {
            throw new Exception("Attribute Set Option non valide pour le produit : " + mProduct.getM_Product_ID() + " / " + mProduct.getGroup1());
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Map<String, Object>> productToSync = new ArrayList<Map<String, Object>>();
        String sql = "SELECT DISTINCT ON (_pro.M_Product_ID) _pro.M_Product_ID, _asso.z_ecommerce_parameter_id, _asso.lastsynchronized, _asso.isActive, _producPrice.pricelist, _producPrice.pricestd, _assoCat.Z_ECommerce_M_Product_Cat_ID, _assoCat.lastsynchronized, _assoCat.isActive FROM M_Product _pro LEFT JOIN Z_ECommerce_M_Product _asso ON _pro.M_Product_ID = _asso.M_Product_ID INNER JOIN M_Product_Category _cat ON _pro.M_Product_Category_ID = _cat.M_Product_Category_ID LEFT JOIN Z_ECommerce_M_Product_Cat _assoCat ON _cat.M_Product_Category_ID = _assoCat.M_Product_Category_ID INNER JOIN M_ProductPrice _producPrice ON _pro.M_Product_ID = _producPrice.M_Product_ID INNER JOIN m_pricelist_version _priceVersion ON _producPrice.m_pricelist_version_id = _priceVersion.m_pricelist_version_id WHERE _pro.group1 = ? AND _pro.ad_client_id = " + zECommerceParameterBean.getAD_Client_ID() + " AND (_pro.ad_org_id = 0 OR _pro.ad_org_id = " + zECommerceParameterBean.getAD_Org_ID() + ")" + " AND _priceVersion.m_pricelist_id = " + zECommerceParameterBean.getM_PriceList_ID() + " AND _priceVersion.isActive = 'Y' AND _priceVersion.validFrom <= ?" + " AND _priceVersion.ad_client_id = " + zECommerceParameterBean.getAD_Client_ID() + " AND (_priceVersion.ad_org_id = 0 OR _priceVersion.ad_org_id = " + zECommerceParameterBean.getAD_Org_ID() + ")" + " AND _producPrice.isActive = 'Y'" + " AND _producPrice.ad_client_id = " + zECommerceParameterBean.getAD_Client_ID() + " AND (_producPrice.ad_org_id = 0 OR _producPrice.ad_org_id = " + zECommerceParameterBean.getAD_Org_ID() + ")" + " ORDER BY _pro.M_Product_ID, _priceVersion.ValidFrom DESC";
        try {
            pstmt = DB.prepareStatement(sql, trx.getTrxName());
            pstmt.setString(1, mProduct.getGroup1());
            pstmt.setTimestamp(2, new Timestamp(Calendar.getInstance().getTime().getTime()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, Number> map = new HashMap<String, Number>();
                map.put("M_Product_ID", rs.getInt(1));
                map.put("Z_ECommerce_Parameter_ID", rs.getObject(2) != null ? rs.getInt(2) : 0);
                map.put("isAlreadySynchronized", rs.getObject(3) != null ? 1 : 0);
                map.put("isActive", "Y".equalsIgnoreCase(rs.getString(4)) ? 1 : 0);
                map.put("pricelist", rs.getBigDecimal(5));
                map.put("pricestd", rs.getBigDecimal(6));
                map.put("Z_ECommerce_M_Product_Cat_ID", rs.getObject(7) != null ? rs.getInt(7) : 0);
                map.put("categoryIsAlreadySynchronized", rs.getObject(8) != null ? 1 : 0);
                map.put("categoryIsActive", "Y".equalsIgnoreCase(rs.getString(9)) ? 1 : 0);
                productToSync.add(map);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        System.out.println("Product sous product adempiere \u00e0 envoyer stock vers Magento : " + productToSync.size());
        return productToSync;
    }

    public void updateStock(MProduct mProduct, ZECommerceParameterBean zECommerceParameterBean, Trx trx, String attributeSet, String attributeSetOption, Properties ctx) throws Exception {
        if (StringUtils.isNotEmpty((String)mProduct.getGroup1()) && StringUtils.isNotEmpty((String)attributeSetOption) && StringUtils.isNotEmpty((String)attributeSet)) {
            List<Map<String, Object>> productToSync = this.getGroupedProductMapping(mProduct, zECommerceParameterBean, trx, attributeSet, attributeSetOption, ctx);
            if (productToSync != null && productToSync.size() > 0) {
                for (Map<String, Object> map : productToSync) {
                    MProduct mProductSize = (MProduct)new Query(ctx, "M_Product", "M_Product_ID = ?", trx.getTrxName()).setClient_ID().setParameters((int)((Integer)map.get("M_Product_ID"))).first();
                    if (mProductSize.getValue().length() <= mProductSize.getGroup1().length() || !StringUtils.isNotEmpty((String)mProductSize.getValue().substring(mProductSize.getGroup1().length()))) continue;
                    CatalogInventoryStockItemUpdateRequestParam req = new CatalogInventoryStockItemUpdateRequestParam();
                    req.setProductId(mProductSize.getValue());
                    req.setSessionId(this.sessionID);
                    CatalogInventoryStockItemUpdateEntity data = new CatalogInventoryStockItemUpdateEntity();
                    BigDecimal qty = this.getQtyAvailable(mProductSize.get_ID(), zECommerceParameterBean, trx);
                    if (qty != null) {
                        data.setQty(qty.toString());
                        if (qty.signum() > 0) {
                            data.setIsInStock(1);
                        } else {
                            data.setIsInStock(0);
                        }
                    } else {
                        data.setQty("0");
                        data.setIsInStock(0);
                    }
                    req.setData(data);
                    this.webservice.catalogInventoryStockItemUpdate(req);
                }
            }
        } else {
            CatalogInventoryStockItemUpdateRequestParam req = new CatalogInventoryStockItemUpdateRequestParam();
            req.setProductId(mProduct.getValue());
            req.setSessionId(this.sessionID);
            CatalogInventoryStockItemUpdateEntity data = new CatalogInventoryStockItemUpdateEntity();
            BigDecimal qty = this.getQtyAvailable(mProduct.get_ID(), zECommerceParameterBean, trx);
            if (qty != null) {
                data.setQty(qty.toString());
                if (qty.signum() > 0) {
                    data.setIsInStock(1);
                } else {
                    data.setIsInStock(0);
                }
            } else {
                data.setQty("0");
                data.setIsInStock(0);
            }
            req.setData(data);
            this.webservice.catalogInventoryStockItemUpdate(req);
        }
    }

    public void updateCacheIndex() {
        SyncCatalogCategoryUpdateCacheRequestParam parameters = new SyncCatalogCategoryUpdateCacheRequestParam();
        parameters.setSessionId(this.sessionID);
        this.webservice.syncCatalogCategoryUpdateCache(parameters);
    }

    public String createOrUpdateProductSAE(MProduct mProduct, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx, String attributeSet, String attributeSetOption, Properties ctx) throws Exception {
        if (StringUtils.isNotEmpty((String)mProduct.getGroup1()) && StringUtils.isNotEmpty((String)attributeSetOption) && StringUtils.isNotEmpty((String)attributeSet)) {
            CatalogProductCreateEntity productData;
            Object request;
            ArrayOfString arraySKU = new ArrayOfString();
            List<Map<String, Object>> productToSync = this.getGroupedProductMapping(mProduct, zECommerceParameterBean, trx, attributeSet, attributeSetOption, ctx);
            if (productToSync != null && productToSync.size() > 0) {
                for (Map<String, Object> map : productToSync) {
                    MProduct mProductSize = (MProduct)new Query(ctx, "M_Product", "M_Product_ID = ?", trx.getTrxName()).setClient_ID().setParameters((int)((Integer)map.get("M_Product_ID"))).first();
                    if (mProductSize.getValue().length() <= mProductSize.getGroup1().length() || !StringUtils.isNotEmpty((String)mProductSize.getValue().substring(mProductSize.getGroup1().length()))) continue;
                    if (!this.productExist(mProductSize.getValue())) {
                        this.createProductSize(mProductSize, isActive, (BigDecimal)map.get("pricelist"), (BigDecimal)map.get("pricestd"), zECommerceParameterBean, trx, mProduct, attributeSet, attributeSetOption);
                    } else {
                        this.updateProductSize(mProductSize, isActive, (BigDecimal)map.get("pricelist"), (BigDecimal)map.get("pricestd"), zECommerceParameterBean, trx, mProduct, attributeSet, attributeSetOption);
                    }
                    arraySKU.getComplexObjectArray().add(mProductSize.getValue());
                }
            }
            if (!this.productExist(mProduct.getGroup1())) {
                request = new CatalogProductCreateRequestParam();
                productData = new CatalogProductCreateEntity();
                this.copyMProductAdempiereToMagentoSAESize(productData, mProduct, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx, mProduct, false, true);
                productData.setAssociatedSkus(arraySKU);
                productData.setVisibility("4");
                if (arraySKU.getComplexObjectArray().size() == 0) {
                    productData.setStatus("2");
                }
                ((CatalogProductCreateRequestParam)request).setProductData(productData);
                ((CatalogProductCreateRequestParam)request).setSessionId(this.getSessionID());
                ((CatalogProductCreateRequestParam)request).setType("configurable");
                ((CatalogProductCreateRequestParam)request).setSet(StringUtils.isNotEmpty((String)attributeSet) ? attributeSet : "4");
                ((CatalogProductCreateRequestParam)request).setSku(mProduct.getGroup1());
                ((CatalogProductCreateRequestParam)request).setProductData(productData);
                CatalogProductCreateResponseParam productCreateResponse = this.getWebservice().catalogProductCreate((CatalogProductCreateRequestParam)request);
                Integer newProductID = productCreateResponse.getResult();
                if (productData.getCategories() != null && productData.getCategories().getComplexObjectArray().size() > 0) {
                    String position = StringUtils.isNotEmpty((String)mProduct.get_ValueAsString("Z_Magento_Position")) ? mProduct.get_ValueAsString("Z_Magento_Position") : "3";
                    String sku = mProduct.getGroup1();
                    this.updateProductCategoryPosition(productData.getCategories().getComplexObjectArray(), sku, position, zECommerceParameterBean);
                }
                return newProductID.toString();
            }
            request = new CatalogProductUpdateRequestParam();
            productData = new CatalogProductCreateEntity();
            this.copyMProductAdempiereToMagentoSAESize(productData, mProduct, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx, mProduct, false, true);
            productData.setAssociatedSkus(arraySKU);
            productData.setVisibility("4");
            if (arraySKU.getComplexObjectArray().size() == 0) {
                productData.setStatus("2");
            }
            ((CatalogProductUpdateRequestParam)request).setSessionId(this.getSessionID());
            ((CatalogProductUpdateRequestParam)request).setProductData(productData);
            ((CatalogProductUpdateRequestParam)request).setProductId(mProduct.getGroup1());
            ((CatalogProductUpdateRequestParam)request).setIdentifierType("sku");
            this.getWebservice().catalogProductUpdate((CatalogProductUpdateRequestParam)request);
            if (productData.getCategories() != null && productData.getCategories().getComplexObjectArray().size() > 0) {
                String position = StringUtils.isNotEmpty((String)mProduct.get_ValueAsString("Z_Magento_Position")) ? mProduct.get_ValueAsString("Z_Magento_Position") : "3";
                String sku = mProduct.getGroup1();
                this.updateProductCategoryPosition(productData.getCategories().getComplexObjectArray(), sku, position, zECommerceParameterBean);
            }
            return null;
        }
        if (!this.productExist(mProduct.getValue())) {
            CatalogProductCreateRequestParam request = new CatalogProductCreateRequestParam();
            CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
            this.copyMProductAdempiereToMagentoSAESize(productData, mProduct, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx, mProduct, false, true);
            productData.setVisibility("4");
            request.setProductData(productData);
            request.setSessionId(this.getSessionID());
            request.setType("simple");
            request.setSet("4");
            request.setSku(mProduct.getValue());
            request.setProductData(productData);
            CatalogProductCreateResponseParam productCreateResponse = this.getWebservice().catalogProductCreate(request);
            Integer newProductID = productCreateResponse.getResult();
            if (productData.getCategories() != null && productData.getCategories().getComplexObjectArray().size() > 0) {
                String position = StringUtils.isNotEmpty((String)mProduct.get_ValueAsString("Z_Magento_Position")) ? mProduct.get_ValueAsString("Z_Magento_Position") : "3";
                String sku = mProduct.getValue();
                this.updateProductCategoryPosition(productData.getCategories().getComplexObjectArray(), sku, position, zECommerceParameterBean);
            }
            return newProductID.toString();
        }
        CatalogProductUpdateRequestParam request = new CatalogProductUpdateRequestParam();
        CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
        this.copyMProductAdempiereToMagentoSAESize(productData, mProduct, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx, mProduct, false, true);
        productData.setVisibility("4");
        request.setSessionId(this.getSessionID());
        request.setProductData(productData);
        request.setProductId(mProduct.getValue());
        request.setIdentifierType("sku");
        this.getWebservice().catalogProductUpdate(request);
        if (productData.getCategories() != null && productData.getCategories().getComplexObjectArray().size() > 0) {
            String position = StringUtils.isNotEmpty((String)mProduct.get_ValueAsString("Z_Magento_Position")) ? mProduct.get_ValueAsString("Z_Magento_Position") : "3";
            String sku = mProduct.getValue();
            this.updateProductCategoryPosition(productData.getCategories().getComplexObjectArray(), sku, position, zECommerceParameterBean);
        }
        return null;
    }

    public void updateProductCategoryPosition(List<String> categories, String sku, String position, ZECommerceParameterBean zECommerceParameterBean) {
        for (String categoryId : categories) {
            SyncCatalogCategoryUpdatePositionRequestParam parameters = new SyncCatalogCategoryUpdatePositionRequestParam();
            parameters.setIdentifierType("sku");
            parameters.setProductId(sku);
            parameters.setSessionId(this.getSessionID());
            parameters.setAdempiereId(Integer.parseInt(categoryId));
            parameters.setPosition(position);
            this.webservice.syncCatalogCategoryUpdatePosition(parameters);
        }
        SyncCatalogCategoryUpdatePositionRequestParam parameters = new SyncCatalogCategoryUpdatePositionRequestParam();
        parameters.setIdentifierType("sku");
        parameters.setProductId(sku);
        parameters.setSessionId(this.getSessionID());
        parameters.setAdempiereId(Integer.parseInt(zECommerceParameterBean.getZ_ECommerce_Categorie_ID()));
        parameters.setPosition(position);
        this.webservice.syncCatalogCategoryUpdatePosition(parameters);
    }

    public boolean productExist(String sku) {
        CatalogProductListRequestParam request = new CatalogProductListRequestParam();
        request.setSessionId(this.getSessionID());
        Filters filters = new Filters();
        filters.setFilter(new AssociativeArray());
        AssociativeEntity asso = new AssociativeEntity();
        asso.setKey("sku");
        asso.setValue(sku);
        filters.getFilter().getComplexObjectArray().add(asso);
        request.setFilters(filters);
        CatalogProductListResponseParam response = this.getWebservice().catalogProductList(request);
        return response != null && response.getResult() != null && response.getResult().getComplexObjectArray() != null && response.getResult().getComplexObjectArray().size() > 0;
    }

    private void createProductSize(MProduct mProductSize, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx, MProduct mProduct, String attributeSet, String attributeSetOption) throws Exception {
        CatalogProductCreateRequestParam request = new CatalogProductCreateRequestParam();
        CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
        this.copyMProductAdempiereToMagentoSAESize(productData, mProductSize, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx, mProduct, true, false);
        productData.setAdditionalAttributes(new AssociativeArray());
        AssociativeEntity asso = new AssociativeEntity();
        asso.setKey(attributeSetOption);
        asso.setValue(mProductSize.getValue().substring(mProductSize.getGroup1().length()));
        productData.getAdditionalAttributes().getComplexObjectArray().add(asso);
        request.setProductData(productData);
        request.setSessionId(this.getSessionID());
        request.setType("simple");
        request.setSet(StringUtils.isNotEmpty((String)attributeSet) ? attributeSet : "4");
        request.setSku(mProductSize.getValue());
        request.setProductData(productData);
        CatalogProductCreateResponseParam productCreateResponse = this.getWebservice().catalogProductCreate(request);
        Integer newProductID = productCreateResponse.getResult();
    }

    private void updateProductSize(MProduct mProductSize, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx, MProduct mProduct, String attributeSet, String attributeSetOption) throws Exception {
        CatalogProductUpdateRequestParam request = new CatalogProductUpdateRequestParam();
        CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
        this.copyMProductAdempiereToMagentoSAESize(productData, mProductSize, isActive, prixCatalogue, prixActuel, zECommerceParameterBean, trx, mProduct, true, false);
        productData.setAdditionalAttributes(new AssociativeArray());
        AssociativeEntity asso = new AssociativeEntity();
        asso.setKey(attributeSetOption);
        asso.setValue(mProductSize.getValue().substring(mProductSize.getGroup1().length()));
        productData.getAdditionalAttributes().getComplexObjectArray().add(asso);
        request.setSessionId(this.getSessionID());
        request.setProductData(productData);
        request.setProductId(mProductSize.getValue());
        request.setIdentifierType("sku");
        this.getWebservice().catalogProductUpdate(request);
    }

    private void copyMProductAdempiereToMagentoSAESize(CatalogProductCreateEntity productData, MProduct mProductSecondaire, boolean isActive, BigDecimal prixCatalogue, BigDecimal prixActuel, ZECommerceParameterBean zECommerceParameterBean, Trx trx, MProduct mProductPrincipal, boolean concatOption, boolean category) throws Exception {
        if (StringUtils.isNotEmpty((String)mProductPrincipal.get_ValueAsString("Z_Magento_Name"))) {
            productData.setName(mProductPrincipal.get_ValueAsString("Z_Magento_Name") + (concatOption ? " -" + mProductSecondaire.getValue().substring(mProductSecondaire.getGroup1().length()) : ""));
        } else {
            productData.setName((StringUtils.isNotEmpty((String)mProductSecondaire.getGroup1()) ? mProductSecondaire.getGroup1() : mProductSecondaire.getValue()) + " " + mProductPrincipal.getName() + (concatOption ? " -" + mProductSecondaire.getValue().substring(mProductSecondaire.getGroup1().length()) : ""));
        }
        if (category) {
            ArrayOfString productCategories = new ArrayOfString();
            productCategories.getComplexObjectArray().add(mProductSecondaire.getM_Product_Category_ID() + "");
            for (I_M_Product_Category cat = mProductSecondaire.getM_Product_Category(); cat != null && cat.getM_Product_Category_Parent_ID() > 0; cat = cat.getM_Product_Category_Parent()) {
                productCategories.getComplexObjectArray().add(cat.getM_Product_Category_Parent_ID() + "");
            }
            productCategories.getComplexObjectArray().add(zECommerceParameterBean.getZ_ECommerce_Categorie_ID());
            productData.setCategories(productCategories);
        }
        productData.setDescription(StringUtils.isNotEmpty((String)mProductPrincipal.get_ValueAsString("Z_Magento_Desc")) ? mProductPrincipal.get_ValueAsString("Z_Magento_Desc") : mProductPrincipal.getDescription());
        productData.setShortDescription(StringUtils.isNotEmpty((String)mProductPrincipal.get_ValueAsString("Z_Magento_Short_Desc")) ? mProductPrincipal.get_ValueAsString("Z_Magento_Short_Desc") : mProductPrincipal.getDescription());
        productData.setWeight(mProductSecondaire.getWeight().toString());
        productData.setStatus(mProductSecondaire.isActive() && isActive ? "1" : "2");
        productData.setVisibility("1");
        productData.setPrice(prixActuel.toString());
        if (prixActuel.compareTo(prixCatalogue) < 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Timestamp debutPromo = new Timestamp(cal.getTime().getTime());
            cal.add(2, 250);
            Timestamp finPromo = new Timestamp(cal.getTime().getTime());
            productData.setSpecialPrice(prixActuel.toString());
            productData.setSpecialFromDate(debutPromo.toString().substring(0, 19));
            productData.setSpecialToDate(finPromo.toString().substring(0, 19));
            productData.setPrice(prixCatalogue.toString());
        }
        if (zECommerceParameterBean.getMTaxCategoryMap().get(mProductSecondaire.getC_TaxCategory_ID() + "") == null) {
            throw new Exception("Erreur tax non configur\u00e9e entre Adempiere et Magento : " + mProductSecondaire.getC_TaxCategory_ID());
        }
        productData.setTaxClassId(zECommerceParameterBean.getMTaxCategoryMap().get(mProductSecondaire.getC_TaxCategory_ID() + ""));
        CatalogInventoryStockItemUpdateEntity stockData = new CatalogInventoryStockItemUpdateEntity();
        if (mProductPrincipal.getProductType().equals("S") || mProductPrincipal.get_ValueAsBoolean("Z_Magento_OnDemand")) {
            stockData.setUseConfigManageStock(0);
            stockData.setManageStock(0);
        } else {
            BigDecimal qtyOnHand = this.getQtyAvailable(mProductSecondaire.get_ID(), zECommerceParameterBean, trx);
            if (qtyOnHand != null) {
                stockData.setQty(qtyOnHand.toString());
                stockData.setIsInStock(1);
            } else {
                stockData.setQty("0");
                stockData.setIsInStock(0);
            }
        }
        productData.setStockData(stockData);
    }

    public void updateProductActive(MProduct mProduct, boolean isActive, ZECommerceParameterBean zECommerceParameterBean, Trx trx) throws Exception {
        CatalogProductUpdateRequestParam request = new CatalogProductUpdateRequestParam();
        CatalogProductCreateEntity productData = new CatalogProductCreateEntity();
        productData.setStatus(mProduct.isActive() && isActive ? "1" : "2");
        request.setSessionId(this.getSessionID());
        request.setProductData(productData);
        request.setProductId(mProduct.getValue());
        request.setIdentifierType("sku");
        this.getWebservice().catalogProductUpdate(request);
    }

    public CatalogProductImageEntityArray getProductImageInfo(String productID) {
        CatalogProductAttributeMediaListRequestParam imageListRequest = new CatalogProductAttributeMediaListRequestParam();
        imageListRequest.setProductId(productID);
        imageListRequest.setSessionId(this.sessionID);
        imageListRequest.setIdentifierType("sku");
        return this.webservice.catalogProductAttributeMediaList(imageListRequest).getResult();
    }

    private void copyProductImageAdempiereToMagento(int imageID, int position, CatalogProductAttributeMediaCreateEntity newImageData, Trx trx) {
        MImage mImage = new MImage(Env.getCtx(), imageID, trx.getTrxName());
        byte[] imageContent = mImage.getBinaryData();
        String imageUrl = mImage.getImageURL();
        CatalogProductImageFileEntity newImage = new CatalogProductImageFileEntity();
        byte[] encodedContent = Base64.encodeBase64((byte[])imageContent);
        String encodedContentString = new String(encodedContent);
        newImage.setContent(encodedContentString);
        String mimeType = "image/" + imageUrl.substring(imageUrl.lastIndexOf(".") + 1).toLowerCase();
        if (mimeType.equalsIgnoreCase("image/jpg")) {
            mimeType = "image/jpeg";
        }
        String imageName = imageUrl.substring(imageUrl.lastIndexOf("/") + 1);
        newImage.setName(imageName);
        newImage.setMime(mimeType);
        newImageData.setFile(newImage);
        newImageData.setLabel(imageName);
        ArrayOfString imageTypes = new ArrayOfString();
        if (position == 1) {
            imageTypes.getComplexObjectArray().add("image");
            imageTypes.getComplexObjectArray().add("small_image");
        }
        imageTypes.getComplexObjectArray().add("thumbnail");
        newImageData.setTypes(imageTypes);
        newImageData.setExclude("0");
    }

    public void addProductImage(String productID, int imageID, int position, Trx trx) throws Exception {
        CatalogProductAttributeMediaCreateEntity newImageData = new CatalogProductAttributeMediaCreateEntity();
        this.copyProductImageAdempiereToMagento(imageID, position, newImageData, trx);
        CatalogProductAttributeMediaCreateRequestParam addImageRequest = new CatalogProductAttributeMediaCreateRequestParam();
        addImageRequest.setSessionId(this.sessionID);
        addImageRequest.setProductId(productID);
        addImageRequest.setIdentifierType("sku");
        addImageRequest.setData(newImageData);
        this.webservice.catalogProductAttributeMediaCreate(addImageRequest);
    }

    public void updateProductImage(String productID, int imageID, String imagePath, int position, Trx trx) {
        CatalogProductAttributeMediaCreateEntity newImageData = new CatalogProductAttributeMediaCreateEntity();
        this.copyProductImageAdempiereToMagento(imageID, position, newImageData, trx);
        CatalogProductAttributeMediaUpdateRequestParam updateImageRequest = new CatalogProductAttributeMediaUpdateRequestParam();
        updateImageRequest.setSessionId(this.sessionID);
        updateImageRequest.setProductId(productID);
        updateImageRequest.setIdentifierType("sku");
        updateImageRequest.setData(newImageData);
        updateImageRequest.setFile(imagePath);
        this.webservice.catalogProductAttributeMediaUpdate(updateImageRequest);
    }

    public void deleteProductImage(String productID, String imagePath) {
        CatalogProductAttributeMediaRemoveRequestParam deleteImageRequest = new CatalogProductAttributeMediaRemoveRequestParam();
        deleteImageRequest.setSessionId(this.sessionID);
        deleteImageRequest.setFile(imagePath);
        deleteImageRequest.setProductId(productID);
        deleteImageRequest.setIdentifierType("sku");
        this.webservice.catalogProductAttributeMediaRemove(deleteImageRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProductCategory(MProductCategory mProductCategory, boolean isActive, ZECommerceParameterBean zECommerceParameterBean, Trx trx, int idUser) {
        SyncCatalogCategoryCreateRequestParam categoryCreateRequest = new SyncCatalogCategoryCreateRequestParam();
        categoryCreateRequest.setSessionId(this.sessionID);
        Integer parentCategoryID = mProductCategory.getM_Product_Category_Parent_ID();
        if (parentCategoryID != 0) {
            MProductCategory mProductParentCategory = (MProductCategory)new Query(Env.getCtx(), "M_Product_Category", "M_Product_Category_ID = ?", trx.getTrxName()).setClient_ID().setParameters(parentCategoryID).first();
            if (mProductParentCategory != null) {
                boolean[] tab = MagentoUtils.isCategorySynchronized(zECommerceParameterBean.getId(), parentCategoryID, trx);
                boolean isAlready = tab[0];
                boolean created = tab[1];
                categoryCreateRequest.setParentId(mProductParentCategory.get_ID());
                if (!isAlready) {
                    this.createProductCategory(mProductParentCategory, isActive, zECommerceParameterBean, trx, idUser);
                    String table2 = "Z_ECommerce_M_Product_Cat";
                    String key = "M_Product_Category_ID";
                    String keyID = "Z_ECommerce_M_Product_Cat_ID";
                    Object pstmt = null;
                    try {
                        if (!created) {
                            MagentoUtils.insertZECommerceAsso(table2, key, keyID, mProductParentCategory.get_ID(), zECommerceParameterBean, pstmt, trx, idUser);
                        }
                        MagentoUtils.updateZECommerceAsso(table2, key, mProductParentCategory.get_ID(), zECommerceParameterBean, pstmt, trx, idUser);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        DB.close(null, pstmt);
                        pstmt = null;
                    }
                }
            }
        } else {
            categoryCreateRequest.setParentId(Integer.parseInt(zECommerceParameterBean.getZ_ECommerce_Categorie_ID()));
        }
        SyncCatalogCategoryEntityCreate categoryData = new SyncCatalogCategoryEntityCreate();
        this.copyProductCategoryData(categoryData, mProductCategory, isActive);
        categoryCreateRequest.setCategoryData(categoryData);
        categoryCreateRequest.setAdempiereId(mProductCategory.get_ID());
        this.webservice.syncCatalogCategoryCreate(categoryCreateRequest);
    }

    public void updateProductCategory(MProductCategory mProductCategory, boolean isActive) {
        SyncCatalogCategoryUpdateRequestParam request = new SyncCatalogCategoryUpdateRequestParam();
        request.setSessionId(this.sessionID);
        SyncCatalogCategoryEntityCreate categoryData = new SyncCatalogCategoryEntityCreate();
        this.copyProductCategoryData(categoryData, mProductCategory, isActive);
        request.setCategoryData(categoryData);
        request.setAdempiereId(mProductCategory.get_ID());
        this.webservice.syncCatalogCategoryUpdate(request);
    }

    private void copyProductCategoryData(SyncCatalogCategoryEntityCreate categoryData, MProductCategory mProductCategory, boolean isActive) {
        categoryData.setName(StringUtils.isNotEmpty((String)mProductCategory.get_ValueAsString("Z_Magento_Name")) ? mProductCategory.get_ValueAsString("Z_Magento_Name") : mProductCategory.getName());
        categoryData.setDescription(StringUtils.isNotEmpty((String)mProductCategory.get_ValueAsString("Z_Magento_Desc")) ? mProductCategory.get_ValueAsString("Z_Magento_Desc") : mProductCategory.getDescription());
        categoryData.setIsActive(isActive && mProductCategory.isActive() ? 1 : 0);
        categoryData.setIncludeInMenu(1);
        ArrayOfString availableSorts = new ArrayOfString();
        availableSorts.getComplexObjectArray().add("position");
        availableSorts.getComplexObjectArray().add("name");
        availableSorts.getComplexObjectArray().add("price");
        categoryData.setAvailableSortBy(availableSorts);
        categoryData.setDefaultSortBy("position");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected BigDecimal getQtyAvailable(int M_Product_ID, ZECommerceParameterBean zeCommerceParameterBean, Trx trx) {
        String SQL = "SELECT sum(qtyAvailable) FROM M_PRODUCT_STOCK_V WHERE m_product_id=" + M_Product_ID;
        if (!zeCommerceParameterBean.isZ_ECommerce_Is_Stock_All()) {
            SQL = SQL + " AND M_Warehouse_ID = " + zeCommerceParameterBean.getM_Warehouse_ID();
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal qtyOnHand = new BigDecimal(0);
        try {
            pstmt = DB.prepareStatement(SQL.toString(), trx.getTrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                qtyOnHand = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return qtyOnHand;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public MageApiModelServerWsiHandlerPortType getWebservice() {
        return this.webservice;
    }
}

