/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;
import org.compiere.util.sogexis.ecommerce.magento.wsclient.CatalogProductImageEntity;

public class MagentoSyncProductAndCategoryAdempiereToMagento {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPI api;
    private Properties context;

    public MagentoSyncProductAndCategoryAdempiereToMagento(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPI api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public void processSync() {
        this.syncCategory();
        this.syncProduct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncProduct() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT DISTINCT ON (_pro.M_Product_ID) _pro.M_Product_ID, _asso.z_ecommerce_parameter_id, _asso.lastsynchronized, _asso.isActive, _producPrice.pricelist, _producPrice.pricestd, _assoCat.Z_ECommerce_M_Product_Cat_ID, _assoCat.lastsynchronized, _assoCat.isActive FROM M_Product _pro INNER JOIN Z_ECommerce_M_Product _asso ON _pro.M_Product_ID = _asso.M_Product_ID INNER JOIN M_Product_Category _cat ON _pro.M_Product_Category_ID = _cat.M_Product_Category_ID LEFT JOIN Z_ECommerce_M_Product_Cat _assoCat ON _cat.M_Product_Category_ID = _assoCat.M_Product_Category_ID INNER JOIN M_ProductPrice _producPrice ON _pro.M_Product_ID = _producPrice.M_Product_ID INNER JOIN m_pricelist_version _priceVersion ON _producPrice.m_pricelist_version_id = _priceVersion.m_pricelist_version_id WHERE _asso.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + " AND _pro.ad_client_id = " + this.zECommerceParamtereBean.getAD_Client_ID() + " AND (_pro.ad_org_id = 0 OR _pro.ad_org_id = " + this.zECommerceParamtereBean.getAD_Org_ID() + ")" + " AND _priceVersion.m_pricelist_id = " + this.zECommerceParamtereBean.getM_PriceList_ID() + " AND _priceVersion.isActive = 'Y' AND _priceVersion.validFrom <= ?" + " AND _priceVersion.ad_client_id = " + this.zECommerceParamtereBean.getAD_Client_ID() + " AND (_priceVersion.ad_org_id = 0 OR _priceVersion.ad_org_id = " + this.zECommerceParamtereBean.getAD_Org_ID() + ")" + " AND _producPrice.isActive = 'Y'" + " AND _producPrice.ad_client_id = " + this.zECommerceParamtereBean.getAD_Client_ID() + " AND (_producPrice.ad_org_id = 0 OR _producPrice.ad_org_id = " + this.zECommerceParamtereBean.getAD_Org_ID() + ")" + " AND (_asso.lastsynchronized IS NULL" + " OR _pro.updated > _asso.lastsynchronized" + " OR _priceVersion.updated > _asso.lastsynchronized" + " OR _producPrice.updated > _asso.lastsynchronized)" + " ORDER BY _pro.M_Product_ID, _priceVersion.ValidFrom DESC";
        ArrayList productToSync = new ArrayList();
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setTimestamp(1, new Timestamp(Calendar.getInstance().getTime().getTime()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, Number> map = new HashMap<String, Number>();
                map.put("M_Product_ID", rs.getInt(1));
                map.put("Z_ECommerce_Parameter_ID", rs.getObject(2) != null ? rs.getInt(2) : 0);
                map.put("isAlreadySynchronized", rs.getObject(3) != null ? 1 : 0);
                map.put("isActive", "Y".equalsIgnoreCase(rs.getString(4)) ? 1 : 0);
                map.put("pricelist", rs.getBigDecimal(5));
                map.put("pricestd", rs.getBigDecimal(6));
                map.put("Z_ECommerce_M_Product_Cat_ID", rs.getObject(7) != null ? rs.getInt(7) : 0);
                map.put("categoryIsAlreadySynchronized", rs.getObject(8) != null ? 1 : 0);
                map.put("categoryIsActive", "Y".equalsIgnoreCase(rs.getString(9)) ? 1 : 0);
                productToSync.add(map);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        System.out.println("Product adempiere \u00e0 envoyer vers Magento : " + productToSync.size());
        boolean isOK = true;
        if (productToSync.size() > 0) {
            int idUser = Env.getAD_User_ID(this.getCtx());
            String table2 = "Z_ECommerce_M_Product";
            String key = "M_Product_ID";
            for (Map map : productToSync) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                try {
                    MProduct mProduct = (MProduct)new Query(this.getCtx(), "M_Product", "M_Product_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)((Integer)map.get("M_Product_ID"))).first();
                    if (isOK) {
                        if ((Integer)map.get("isAlreadySynchronized") == 1) {
                            try {
                                this.api.updateProduct(mProduct, (Integer)map.get("isActive") == 1, (BigDecimal)map.get("pricelist"), (BigDecimal)map.get("pricestd"), this.zECommerceParamtereBean, trx);
                            }
                            catch (Throwable e) {
                                isOK = false;
                                this.log.log(Level.SEVERE, "Erreur lors de la mise \u00e0 jour du produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                            }
                        } else {
                            try {
                                this.api.createProduct(mProduct, (Integer)map.get("isActive") == 1, (BigDecimal)map.get("pricelist"), (BigDecimal)map.get("pricestd"), this.zECommerceParamtereBean, trx);
                            }
                            catch (Throwable e) {
                                isOK = false;
                                this.log.log(Level.SEVERE, "Erreur lors de la cr\u00e9ation du produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                            }
                        }
                        if (isOK) {
                            try {
                                MagentoUtils.updateZECommerceAsso(table2, key, mProduct.get_ID(), this.zECommerceParamtereBean, pstmt, trx, idUser);
                            }
                            catch (Throwable e) {
                                isOK = false;
                                this.log.log(Level.SEVERE, "Erreur lors de la mise \u00e0 jour du produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                            }
                            finally {
                                DB.close(null, pstmt);
                                pstmt = null;
                            }
                        }
                        if (isOK) {
                            List<CatalogProductImageEntity> imageList = null;
                            try {
                                imageList = this.api.getProductImageInfo(mProduct.getValue()).getComplexObjectArray();
                            }
                            catch (Exception e) {
                                isOK = false;
                                this.log.log(Level.SEVERE, "Erreur lors de la r\u00e9cup\u00e9ration des infos photos pour le produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                            }
                            if (imageList != null) {
                                for (int i2 = 1; i2 < 4; ++i2) {
                                    Integer photoID = (Integer)mProduct.get_Value("Z_Magento_Photo" + i2 + "_ID");
                                    String existingImagePath = this.magentoImageExists(imageList, i2);
                                    if (photoID != null) {
                                        if (existingImagePath != null) {
                                            try {
                                                this.api.updateProductImage(mProduct.getValue(), photoID, existingImagePath, i2, trx);
                                            }
                                            catch (Exception e) {
                                                isOK = false;
                                                this.log.log(Level.SEVERE, "Erreur lors de la mise \u00e0 jour de la photo " + i2 + " pour le produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                                            }
                                            continue;
                                        }
                                        try {
                                            this.api.addProductImage(mProduct.getValue(), photoID, i2, trx);
                                        }
                                        catch (Exception e) {
                                            isOK = false;
                                            this.log.log(Level.SEVERE, "Erreur lors de la cr\u00e9ation de la photo " + i2 + " pour le produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                                        }
                                        continue;
                                    }
                                    if (existingImagePath == null) continue;
                                    try {
                                        this.api.deleteProductImage(mProduct.getValue(), existingImagePath);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        isOK = false;
                                        this.log.log(Level.SEVERE, "Erreur lors de la suppression de la photo " + i2 + " pour le produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                                    }
                                }
                            }
                            if (mProduct.getProductType() == "S") {
                                try {
                                    this.api.disableStock(mProduct.getValue());
                                }
                                catch (Exception e) {
                                    isOK = false;
                                    this.log.log(Level.SEVERE, "Erreur lors de la d\u00e9sactivation de la gestion du stock pour le produit " + mProduct.getName() + " " + e.getLocalizedMessage());
                                }
                            }
                        }
                    }
                    if (!isOK) {
                        trx.rollback();
                        continue;
                    }
                    trx.commit(true);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "L'article " + (Integer)map.get("M_Product_ID") + " n'a pas \u00e9t\u00e9 export\u00e9 vers magento");
                    e.printStackTrace();
                    trx.rollback();
                }
                finally {
                    trx.close();
                }
            }
        }
    }

    private String magentoImageExists(List<CatalogProductImageEntity> imageList, int position) {
        for (CatalogProductImageEntity image : imageList) {
            if (Integer.parseInt(image.getPosition()) != position) continue;
            return image.getFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCategory() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT _cat.M_Product_Category_ID, _asso.z_ecommerce_parameter_id, _asso.lastsynchronized, _asso.isActive FROM M_Product_Category _cat LEFT JOIN Z_ECommerce_M_Product_Cat _asso ON _cat.M_Product_Category_ID = _asso.M_Product_Category_ID LEFT JOIN M_Product _pro ON _cat.M_Product_Category_ID = _pro.M_Product_Category_ID LEFT JOIN Z_ECommerce_M_Product _assoPro ON _pro.M_Product_ID = _assoPro.M_Product_ID WHERE (_asso.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + " OR _assoPro.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + ")" + " AND _cat.ad_client_id = " + this.zECommerceParamtereBean.getAD_Client_ID() + " AND  (_asso.z_ecommerce_parameter_id IS NULL OR _asso.lastsynchronized IS NULL OR _cat.updated > _asso.lastsynchronized)" + " GROUP BY _cat.M_Product_Category_ID, _asso.z_ecommerce_parameter_id, _asso.lastsynchronized, _asso.isActive";
        ArrayList categoryToSync = new ArrayList();
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("M_Product_Category_ID", rs.getInt(1));
                map.put("Z_ECommerce_Parameter_ID", rs.getObject(2) != null ? rs.getInt(2) : 0);
                map.put("isAlreadySynchronized", rs.getObject(3) != null ? 1 : 0);
                map.put("isActive", "Y".equalsIgnoreCase(rs.getString(4)) ? 1 : 0);
                categoryToSync.add(map);
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        System.out.println("Categorie adempiere \u00e0 envoyer vers Magento : " + categoryToSync.size());
        if (categoryToSync.size() > 0) {
            int idUser = Env.getAD_User_ID(this.getCtx());
            String table2 = "Z_ECommerce_M_Product_Cat";
            String key = "M_Product_Category_ID";
            String keyID = "Z_ECommerce_M_Product_Cat_ID";
            for (Map map : categoryToSync) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                try {
                    MProductCategory mProductCategory = (MProductCategory)new Query(this.getCtx(), "M_Product_Category", "M_Product_Category_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)((Integer)map.get("M_Product_Category_ID"))).first();
                    boolean[] tab = MagentoUtils.isCategorySynchronized(this.zECommerceParamtereBean.getId(), mProductCategory.get_ID(), trx);
                    boolean isAlready = tab[0];
                    boolean created = tab[1];
                    boolean isActive = tab[2];
                    if (isAlready) {
                        try {
                            this.api.updateProductCategory(mProductCategory, isActive);
                            MagentoUtils.updateZECommerceAsso(table2, key, mProductCategory.get_ID(), this.zECommerceParamtereBean, pstmt, trx, idUser);
                            trx.commit(true);
                            continue;
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Erreur lors de la mise \u00e0 jour de la cat\u00e9gorie produit " + mProductCategory.getName() + " " + e.getLocalizedMessage());
                            e.printStackTrace();
                            trx.rollback();
                            continue;
                        }
                        finally {
                            DB.close(null, pstmt);
                            pstmt = null;
                            continue;
                        }
                    }
                    try {
                        this.api.createProductCategory(mProductCategory, isActive || !created, this.zECommerceParamtereBean, trx, idUser);
                        if (created) {
                            MagentoUtils.updateZECommerceAsso(table2, key, mProductCategory.get_ID(), this.zECommerceParamtereBean, pstmt, trx, idUser);
                        } else {
                            MagentoUtils.insertZECommerceAsso(table2, key, keyID, mProductCategory.get_ID(), this.zECommerceParamtereBean, pstmt, trx, idUser);
                        }
                        trx.commit(true);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Erreur lors de la cr\u00e9ation de la cat\u00e9gorie produit " + mProductCategory.getName() + " " + e.getLocalizedMessage());
                        e.printStackTrace();
                        trx.rollback();
                    }
                    finally {
                        DB.close(null, pstmt);
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "La cat\u00e9gorie " + (Integer)map.get("M_Product_Category_ID") + " n'a pas \u00e9t\u00e9 export\u00e9 vers magento");
                    e.printStackTrace();
                    trx.rollback();
                }
                finally {
                    trx.close();
                }
            }
        }
    }
}

