/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncBLAdempiereToMagento;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncCustomerMagentoToAdempiere;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncInvoiceAdempiereToMagento;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncOrderAdempiereToMagento;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncOrderMagentoToAdempiere;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncProductAndCategoryAdempiereToMagento;
import org.compiere.util.sogexis.ecommerce.magento.MagentoSyncStockAdempiereToMagento;
import org.compiere.util.sogexis.ecommerce.magento.MagentoUtils;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;

public class MagentoSyncProcess
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        Properties envContext = Env.getCtx();
        List<ZECommerceParameterBean> zECommerceParameterList = MagentoUtils.getZECommerceParameterBeanList();
        for (ZECommerceParameterBean parameter : zECommerceParameterList) {
            try {
                Date start = new Date();
                System.out.println("Sync ECommerce " + parameter.getZ_ECommerce_Type().getLibelle() + " " + parameter.getTitle() + " - Start : " + start);
                Properties context = (Properties)envContext.clone();
                context.setProperty("#AD_Client_ID", parameter.getAD_Client_ID() + "");
                context.setProperty("#AD_Org_ID", parameter.getAD_Org_ID() + "");
                MagentoAPI api = new MagentoAPI(parameter);
                MagentoSyncCustomerMagentoToAdempiere customerSync = new MagentoSyncCustomerMagentoToAdempiere(parameter, api, context);
                customerSync.processSync();
                MagentoSyncOrderMagentoToAdempiere orderSync = new MagentoSyncOrderMagentoToAdempiere(parameter, api, context);
                orderSync.processSync();
                MagentoSyncProductAndCategoryAdempiereToMagento productCategorySync = new MagentoSyncProductAndCategoryAdempiereToMagento(parameter, api, context);
                productCategorySync.processSync();
                MagentoSyncStockAdempiereToMagento stockSync = new MagentoSyncStockAdempiereToMagento(parameter, api, context);
                stockSync.processSync();
                MagentoSyncBLAdempiereToMagento blSync = new MagentoSyncBLAdempiereToMagento(parameter, api, context);
                blSync.processSync();
                MagentoSyncOrderAdempiereToMagento orderToMagentoSync = new MagentoSyncOrderAdempiereToMagento(parameter, api, context);
                orderToMagentoSync.processSync();
                MagentoSyncInvoiceAdempiereToMagento invoiceSync = new MagentoSyncInvoiceAdempiereToMagento(parameter, api, context);
                invoiceSync.processSync();
            }
            catch (Throwable ex) {
                this.log.log(Level.SEVERE, "Erreur synchro : " + parameter.getId() + " - " + parameter.getTitle(), ex);
            }
            finally {
                Date end = new Date();
                System.out.println("Sync ECommerce " + parameter.getZ_ECommerce_Type().getLibelle() + " " + parameter.getTitle() + " - End : " + end);
            }
        }
        return null;
    }
}

