/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;

public class MagentoSyncOrderAdempiereToMagento {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPI api;
    private Properties context;

    public MagentoSyncOrderAdempiereToMagento(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPI api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public void processSync() {
        this.syncOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncOrder() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT co.C_Order_ID FROM C_Order co  WHERE co.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + " AND co.docstatus = '" + "VO" + "'" + " AND  (co.lastsynchronized IS NULL OR co.updated > co.lastsynchronized)";
        ArrayList<Integer> ordersToCancel = new ArrayList<Integer>();
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ordersToCancel.add(rs.getInt(1));
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        System.out.println("Commande annul\u00e9e adempiere \u00e0 envoyer vers Magento : " + ordersToCancel.size());
        if (ordersToCancel.size() > 0) {
            for (Integer mOrderId : ordersToCancel) {
                Trx trx = Trx.get(Trx.createTrxName(), false);
                try {
                    MInvoice mInvoice;
                    MOrder mOrder = (MOrder)new Query(this.getCtx(), "C_Order", "C_Order_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)mOrderId).first();
                    Integer magentoOrderID = (Integer)mOrder.get_Value("Z_Magento_Order_ID");
                    BigDecimal invoicedAmt = new BigDecimal(this.api.getOrderInvoicedAmt(magentoOrderID.toString()));
                    if (invoicedAmt.signum() == 0) {
                        try {
                            this.api.cancelOrder(magentoOrderID.toString());
                            mOrder.set_ValueOfColumn("lastsynchronized", (Object)new Timestamp(new Date().getTime()));
                            mOrder.save();
                            trx.commit(true);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "Erreur lors de l'annulation de la commande " + mOrder.getDocumentNo() + " " + e.getLocalizedMessage());
                            e.printStackTrace();
                            trx.rollback();
                        }
                        continue;
                    }
                    if (invoicedAmt.signum() != 1 || (mInvoice = (MInvoice)new Query(this.getCtx(), "C_Invoice", "C_Order_ID = ? AND Z_Magento_Invoice_ID IS NOT NULL", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(mOrder.get_ID()).setOrderBy("created ASC").first()) == null) continue;
                    try {
                        this.api.cancelInvoice(mInvoice);
                        mOrder.set_ValueOfColumn("lastsynchronized", (Object)new Timestamp(new Date().getTime()));
                        mOrder.save();
                        trx.commit(true);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Erreur lors de l'annulation de la facture " + mInvoice.getDocumentNo() + " " + e.getLocalizedMessage());
                        e.printStackTrace();
                        trx.rollback();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "La commande " + mOrderId + " n'a pas \u00e9t\u00e9 export\u00e9 vers magento");
                    e.printStackTrace();
                    trx.rollback();
                }
                finally {
                    trx.close();
                }
            }
        }
    }
}

