/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util.sogexis.ecommerce.magento;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.compiere.util.sogexis.ecommerce.magento.MagentoAPI;
import org.compiere.util.sogexis.ecommerce.magento.ZECommerceParameterBean;

public class MagentoSyncInvoiceAdempiereToMagento {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ZECommerceParameterBean zECommerceParamtereBean;
    private MagentoAPI api;
    private Properties context;

    public MagentoSyncInvoiceAdempiereToMagento(ZECommerceParameterBean zECommerceParamtereBean, MagentoAPI api, Properties context) {
        this.zECommerceParamtereBean = zECommerceParamtereBean;
        this.api = api;
        this.context = context;
    }

    private Properties getCtx() {
        return this.context;
    }

    public void processSync() {
        this.syncInvoice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncInvoice() {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT io.C_Invoice_ID, co.C_Order_ID, co.Z_Magento_Order_ID FROM C_Invoice io INNER JOIN C_Order co ON co.C_Order_ID = io.C_Order_ID  WHERE co.z_ecommerce_parameter_id = " + this.zECommerceParamtereBean.getId() + " AND io.docstatus = '" + "CO" + "'" + " AND  (io.lastsynchronized IS NULL OR io.updated > io.lastsynchronized)";
        ArrayList mInvoiceList = new ArrayList();
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("C_Invoice_ID", rs.getInt(1));
                map.put("C_Order_ID", rs.getInt(2));
                map.put("Z_Magento_Order_ID", rs.getInt(3));
                mInvoiceList.add(map);
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        System.out.println("Factures \u00e0 envoyer vers Magento : " + mInvoiceList.size());
        for (HashMap hashMap : mInvoiceList) {
            Trx trx = Trx.get(Trx.createTrxName(), false);
            try {
                Integer magentoOrderID = (int)((Integer)hashMap.get("Z_Magento_Order_ID"));
                if (magentoOrderID == null || magentoOrderID == 0) continue;
                boolean notInvoiced = new BigDecimal(this.api.getOrderInvoicedAmt(magentoOrderID.toString())).signum() == 0;
                MInvoice mInvoice = (MInvoice)new Query(this.getCtx(), "C_Invoice", "c_invoice_id = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters((int)((Integer)hashMap.get("C_Invoice_ID"))).first();
                ArrayList<HashMap<String, Double>> itemsToShip = new ArrayList<HashMap<String, Double>>();
                if (notInvoiced) {
                    MInvoiceLine[] mInvoiceLineArray = mInvoice.getLines();
                    for (int i2 = 0; i2 < mInvoiceLineArray.length; ++i2) {
                        HashMap<String, Double> itemQty = new HashMap<String, Double>();
                        MOrderLine mOrderLine = (MOrderLine)new Query(this.getCtx(), "C_OrderLine", "C_OrderLine_ID = ?", trx.getTrxName()).setOnlyActiveRecords(true).setClient_ID().setParameters(mInvoiceLineArray[i2].getC_OrderLine_ID()).first();
                        if (mOrderLine.get_Value("Z_Magento_OrderLine_ID") == null) continue;
                        itemQty.put("id", ((Integer)mOrderLine.get_Value("Z_Magento_OrderLine_ID")).doubleValue());
                        itemQty.put("qty", mInvoiceLineArray[i2].getQtyEntered().doubleValue());
                        itemsToShip.add(itemQty);
                    }
                }
                try {
                    if (notInvoiced) {
                        Integer magentoInvoiceID = null;
                        try {
                            magentoInvoiceID = this.api.createInvoice(magentoOrderID.toString(), itemsToShip);
                        }
                        catch (Throwable ec) {
                            // empty catch block
                        }
                        if (magentoInvoiceID != null) {
                            mInvoice.set_ValueOfColumn("Z_Magento_Invoice_ID", (Object)magentoInvoiceID);
                        }
                    }
                    mInvoice.set_ValueOfColumn("lastsynchronized", (Object)new Timestamp(new Date().getTime()));
                    mInvoice.save();
                    trx.commit(true);
                }
                catch (Throwable e) {
                    this.log.log(Level.SEVERE, "Erreur lors de l'export du Invoice " + mInvoice.getDocumentNo() + " " + e.getLocalizedMessage());
                    e.printStackTrace();
                    trx.rollback();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Le Invoice " + (Integer)hashMap.get("C_Invoice_ID") + " n'a pas \u00e9t\u00e9 export\u00e9");
                e.printStackTrace();
                trx.rollback();
            }
            finally {
                trx.close();
            }
        }
    }
}

