/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MClient;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_InOut;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.StandardExportPDASogexis;
import org.compiere.util.Trx;

public class SogexisUtils {
    protected static CLogger log = CLogger.getCLogger(SogexisUtils.class);
    private static final String[] randomCharAvalaible = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final int PASSWORD_LENGTH = 5;
    private static File REPORT_HOME = null;

    public static File getPDFFromPrintFormatFromAdempiereOrJasperReport(MPrintFormat mPrintFormat, int recordID, int bPartnerID, int table2, String id, Properties ctx, String trx, Map<String, Object> paramsReport, File destinationFile) {
        MQuery query = new MQuery(mPrintFormat.getAD_Table_ID());
        query.addRestriction(id, "=", recordID);
        String DocumentNo = null;
        if (DocumentNo == null || DocumentNo.length() == 0) {
            DocumentNo = "DocPrint";
        }
        PrintInfo info = new PrintInfo(DocumentNo, table2, recordID, bPartnerID);
        info.setCopies(0);
        info.setDocumentCopy(false);
        info.setPrinterName(mPrintFormat.getPrinterName());
        return SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReport(mPrintFormat, recordID, ctx, query, DocumentNo, info, trx, paramsReport, destinationFile);
    }

    public static File getPDFFromPrintFormatFromJasperReport(MPrintFormat mPrintFormat, int recordID, Map<String, Object> paramsReport, File destinationFile) {
        return SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReport(mPrintFormat, recordID, null, null, null, null, null, paramsReport, destinationFile);
    }

    public static File getPDFFromPrintFormatFromJasperReport(MPrintFormat mPrintFormat, int recordID, Map<String, Object> paramsReport) {
        return SogexisUtils.getPDFFromPrintFormatFromJasperReport(mPrintFormat, recordID, paramsReport, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPDFFromPrintFormatFromAdempiereOrJasperReport(MPrintFormat mPrintFormat, int recordID, Properties ctx, MQuery query, String DocumentNo, PrintInfo info, String trx, Map<String, Object> paramsReport, File destinationFile) {
        File file;
        block17: {
            file = null;
            Connection connection = null;
            try {
                Language language = Language.getLoginLanguage();
                mPrintFormat.setLanguage(language);
                mPrintFormat.setTranslationLanguage(language);
                if (mPrintFormat.getJasperProcess_ID() > 0) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.putAll(paramsReport);
                    params.put("RECORD_ID", recordID);
                    File reportFile = new File(REPORT_HOME, mPrintFormat.getJasperProcess().getJasperReport());
                    ClassLoader scl = ClassLoader.getSystemClassLoader();
                    try {
                        URLClassLoader ucl = new URLClassLoader(new URL[]{reportFile.getParentFile().toURI().toURL()}, scl);
                        JRResourcesUtil.setThreadClassLoader((ClassLoader)ucl);
                    }
                    catch (MalformedURLException me) {
                        log.warning("Could not add report directory to classpath: " + me.getMessage());
                    }
                    JasperReport myjasperReport = (JasperReport)JRLoader.loadObject((String)reportFile.getAbsolutePath());
                    connection = StringUtils.isEmpty((String)trx) ? DB.getConnectionRO() : Trx.get(trx, false).getConnection();
                    JasperPrint myjasperPrint = JasperFillManager.fillReport((JasperReport)myjasperReport, params, (Connection)connection);
                    File invoice = destinationFile;
                    if (invoice == null) {
                        invoice = File.createTempFile("sogexis_adempiere", ".pdf");
                    }
                    JasperExportManager.exportReportToPdfFile((JasperPrint)myjasperPrint, (String)invoice.getPath());
                    file = invoice;
                    break block17;
                }
                ReportEngine re = new ReportEngine(ctx, mPrintFormat, query, info, trx);
                File invoice = destinationFile;
                if (invoice == null) {
                    invoice = File.createTempFile("sogexis_adempiere", ".pdf");
                }
                file = re.getPDF(invoice);
            }
            catch (Throwable thx) {
                log.severe("Could not generate report : " + thx.getMessage());
                thx.printStackTrace();
            }
            finally {
                if (connection != null && StringUtils.isEmpty((String)trx)) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return file;
    }

    public static File getPDFFromPrintFormatFromAdempiereOrJasperReportForInOut(MPrintFormat mPrintFormat, int recordID, int bPartnerID, Properties ctx, String trx, Map<String, Object> paramsReport) {
        return SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReportForInOut(mPrintFormat, recordID, bPartnerID, ctx, trx, paramsReport, null);
    }

    public static File getPDFFromPrintFormatFromAdempiereOrJasperReportForInOut(MPrintFormat mPrintFormat, int recordID, int bPartnerID, Properties ctx, String trx, Map<String, Object> paramsReport, File destinationFile) {
        return SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReport(mPrintFormat, recordID, bPartnerID, X_M_InOut.Table_ID, "M_InOut_ID", ctx, trx, paramsReport, destinationFile);
    }

    public static File getPDFFromPrintFormatFromAdempiereOrJasperReportForInvoice(MPrintFormat mPrintFormat, int recordID, int bPartnerID, Properties ctx, String trx, Map<String, Object> paramsReport) {
        return SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReportForInvoice(mPrintFormat, recordID, bPartnerID, ctx, trx, paramsReport, null);
    }

    public static File getPDFFromPrintFormatFromAdempiereOrJasperReportForInvoice(MPrintFormat mPrintFormat, int recordID, int bPartnerID, Properties ctx, String trx, Map<String, Object> paramsReport, File destinationFile) {
        return SogexisUtils.getPDFFromPrintFormatFromAdempiereOrJasperReport(mPrintFormat, recordID, bPartnerID, X_C_Invoice.Table_ID, "C_Invoice_ID", ctx, trx, paramsReport, destinationFile);
    }

    public static String randomPassword() {
        return SogexisUtils.randomChaine(5);
    }

    public static String randomChaine(int chaineLength) {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < chaineLength; ++i2) {
            buffer.append(SogexisUtils.monRandomChar());
        }
        return buffer.toString();
    }

    private static String monRandomChar() {
        return randomCharAvalaible[(int)(Math.random() * (double)(randomCharAvalaible.length - 1))];
    }

    public static String getMailContent(String mailContent, Map<String, String> params) {
        for (String key : params.keySet()) {
            mailContent = mailContent.replaceAll("\\{" + key + "\\}", params.get(key) != null ? params.get(key).toString() : "");
        }
        return mailContent;
    }

    public static boolean columnExist(String columnName, String tableName) {
        String sql = "SELECT column_name  FROM information_schema.columns  WHERE UPPER(column_name) = " + DB.TO_STRING(columnName.toUpperCase()) + " AND UPPER(table_name) = " + DB.TO_STRING(tableName.toUpperCase());
        String access = DB.getSQLValueString(null, sql, new Object[0]);
        log.log(Level.FINE, "Pas de probl\u00e8me");
        if (access == null) {
            log.info(" == La colonne " + columnName + " n'existe pas == ");
            return false;
        }
        return true;
    }

    public static String getMandatSEPARUM(String mBPartnerValue, String contractNum, boolean isMigrated) {
        return (isMigrated ? "++" : "") + "RUM" + (mBPartnerValue + contractNum).replaceAll("[^\\p{Alpha}\\p{Digit}+]+", "");
    }

    public static void cmd_sendMail(Properties ctx, String mailTo, String mailCc, String mailHeader, String mailContent, int AD_User_ID, List<String> attachments, String filePath) {
        MClient client = MClient.get(ctx);
        EMail email = client.createEMail(mailTo, mailHeader, mailContent);
        String emailCurrentUser = DB.getSQLValueString(null, "SELECT emailUser FROM AD_User WHERE AD_User_ID = " + AD_User_ID, new Object[0]);
        email.setFrom(emailCurrentUser);
        if (!mailCc.isEmpty()) {
            for (String s : mailCc.split(",")) {
                email.addCc(s);
            }
        }
        for (String s : attachments) {
            File attachment = new File(filePath + s);
            email.addAttachment(attachment);
        }
        email.send();
    }

    public static void exportToFileToPDA(String path, String title, List<List<String>> content, String IMEI, Long timefile) {
        String classExport = "org.compiere.util.StandardExportPDASogexis";
        StringBuffer error = new StringBuffer("");
        StandardExportPDASogexis custom = null;
        File toExport = null;
        int no = 0;
        try {
            String nameFile = path + "/" + title;
            if (timefile != 0L) {
                nameFile = nameFile + "_" + timefile;
            }
            toExport = new File(nameFile + ".csv");
            Class<?> clazz = Class.forName(classExport);
            custom = (StandardExportPDASogexis)clazz.newInstance();
            no = custom.exportToFile(content, toExport, error);
        }
        catch (ClassNotFoundException e) {
            no = -1;
            error.append("No custom PurchaseOrderExport class " + classExport + " - " + e.toString());
            log.log(Level.SEVERE, error.toString(), e);
        }
        catch (Exception e) {
            no = -1;
            error.append("Error in " + classExport + " check log, " + e.toString());
            log.log(Level.SEVERE, error.toString(), e);
        }
    }

    public static List<File> getFilesInDir(String pathWorking, String startWith, String endWith) {
        File allFiles = new File(pathWorking);
        ArrayList<File> files = new ArrayList<File>();
        for (File f : allFiles.listFiles()) {
            if (!f.isFile()) continue;
            if (startWith != null && endWith != null && f.getName().startsWith(startWith) && f.getName().endsWith(endWith)) {
                files.add(f);
                continue;
            }
            if (startWith != null && endWith == null && f.getName().startsWith(startWith)) {
                files.add(f);
                continue;
            }
            if (startWith == null && endWith != null && f.getName().endsWith(endWith)) {
                files.add(f);
                continue;
            }
            if (startWith != null || endWith != null) continue;
            files.add(f);
        }
        return files;
    }

    public static List<List<String>> readFile(File fileToRead, String typeRead) {
        FileReader menuFile = null;
        BufferedReader buffer = null;
        String[] lines = null;
        ArrayList<String> loadedline = null;
        ArrayList<List<String>> allLines = new ArrayList<List<String>>();
        try {
            String line;
            menuFile = new FileReader(fileToRead);
            buffer = new BufferedReader(menuFile);
            while ((line = buffer.readLine()) != null) {
                int i2;
                lines = line.split(";");
                loadedline = new ArrayList<String>();
                for (i2 = 0; i2 < lines.length; ++i2) {
                    loadedline.add(lines[i2]);
                }
                if (typeRead != null && typeRead.equals("Inventory")) {
                    if (loadedline.size() < 6 && (line = buffer.readLine()) != null) {
                        lines = line.split(";");
                        loadedline.add(lines[1]);
                    }
                } else if (typeRead != null && typeRead.equals("Depotage")) {
                    if (loadedline.size() < 5 && (line = buffer.readLine()) != null) {
                        lines = line.split(";");
                        loadedline.add(lines[1]);
                    }
                } else if (typeRead != null && typeRead.equals("Transfert")) {
                    if (loadedline.size() < 7 && (line = buffer.readLine()) != null) {
                        lines = line.split(";");
                        loadedline.add(lines[1]);
                    }
                } else if (typeRead != null && typeRead.equals("BT") && loadedline.size() < 18) {
                    while (loadedline.size() < 18) {
                        line = buffer.readLine();
                        if (line == null || (lines = line.split(";")).length == 0) continue;
                        for (i2 = 1; i2 < lines.length; ++i2) {
                            loadedline.add(lines[i2]);
                        }
                    }
                }
                allLines.add(loadedline);
            }
            buffer.close();
            menuFile.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return allLines;
    }

    public static String genEan(String valueOrEan) {
        String currentCode = valueOrEan;
        if (currentCode == null) {
            return currentCode;
        }
        if (currentCode.length() != 12) {
            return currentCode;
        }
        currentCode = currentCode.substring(0, 12);
        try {
            ArrayList<String> even = new ArrayList<String>();
            ArrayList<String> odd = new ArrayList<String>();
            for (int i2 = 0; i2 < 12; ++i2) {
                if (i2 % 2 == 1) {
                    even.add("" + currentCode.charAt(i2));
                    continue;
                }
                if (i2 % 2 != 0) continue;
                odd.add("" + currentCode.charAt(i2));
            }
            int totalPair = 0;
            int totalImpair = 0;
            for (String string : even) {
                totalPair += Integer.parseInt(string);
            }
            for (String string : odd) {
                totalImpair += Integer.parseInt(string);
            }
            int lastChiffre = 0;
            int tmpResult = totalImpair + (totalPair *= 3);
            lastChiffre = tmpResult - tmpResult / 10 * 10;
            if (10 - lastChiffre == 10) {
                return currentCode + "0";
            }
            return currentCode + (10 - lastChiffre);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Probl\u00e8me dans le code barre", e);
            return valueOrEan;
        }
    }

    public static Integer getMProduct(String valueOrEan, Properties ctx) {
        Integer M_Product_ID = 0;
        valueOrEan = SogexisUtils.genEan(valueOrEan);
        if (SogexisUtils.columnExist("Z_Code_Compteur", "M_Product") && (M_Product_ID = Integer.valueOf(DB.getSQLValue(null, "SELECT COALESCE(MAX(M_Product_ID),0) FROM M_Product WHERE UPPER(Z_Code_Compteur) = '" + valueOrEan.trim().toUpperCase() + "'"))) != 0 && M_Product_ID != -1) {
            return M_Product_ID;
        }
        M_Product_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(M_Product_ID),0) FROM M_Product WHERE UPPER(upc) = '" + valueOrEan.trim().toUpperCase() + "'");
        if (M_Product_ID != 0 && M_Product_ID != -1) {
            return M_Product_ID;
        }
        M_Product_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(M_Product_ID),0) FROM M_Product WHERE UPPER(sku) = '" + valueOrEan.trim().toUpperCase() + "'");
        if (M_Product_ID != 0 && M_Product_ID != -1) {
            return M_Product_ID;
        }
        M_Product_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(M_Product_ID),0) FROM M_Product WHERE UPPER(value) = '" + valueOrEan.trim().toUpperCase() + "'");
        if (M_Product_ID != 0 && M_Product_ID != -1) {
            return M_Product_ID;
        }
        M_Product_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(M_Product_ID),0) FROM M_Product_PO WHERE UPPER(upc) LIKE '%" + valueOrEan.trim().toUpperCase() + "%'");
        if (M_Product_ID != 0 && M_Product_ID != -1) {
            return M_Product_ID;
        }
        M_Product_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(M_Product_ID),0) FROM M_Product WHERE UPPER(name) = '" + valueOrEan.trim().toUpperCase() + "'");
        if (M_Product_ID != 0 && M_Product_ID != -1) {
            return M_Product_ID;
        }
        return null;
    }

    public static void movedFile(String pathFile, String exportPathFile) {
        File source = new File(pathFile);
        File destination = new File(exportPathFile);
        boolean result = source.renameTo(destination);
        if (!result) {
            result = true;
            result = SogexisUtils.copiedFile(pathFile, exportPathFile);
            if (result) {
                result &= source.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copiedFile(String pathFile, String exportPathFile) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(pathFile).getChannel();
            out = new FileOutputStream(exportPathFile).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    public static void exportToFile(String title, List<String> header, List<List<String>> content) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getCBPartnerLocation(Integer C_BPartner_ID, String typeBPartner) {
        ResultSet rs;
        CPreparedStatement pstmt;
        Integer C_BPartner_Location_ID;
        block7: {
            C_BPartner_Location_ID = 0;
            String sql = "";
            if (typeBPartner.equals("L")) {
                sql = "SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_BPartner_ID = ? AND IsBillTo='Y' AND IsActive='Y' ORDER BY C_BPartner_Location_ID DESC ";
            } else if (typeBPartner.equals("F")) {
                sql = "SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_BPartner_ID = ? AND IsShipTo='Y' AND IsActive='Y' ORDER BY C_BPartner_Location_ID DESC ";
            }
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block7;
                C_BPartner_Location_ID = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, "Erreur - " + sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return C_BPartner_Location_ID;
    }

    static {
        String reportPath = System.getProperty("org.compiere.report.path");
        REPORT_HOME = reportPath == null ? new File(Ini.getAdempiereHome() + File.separator + "reports") : new File(reportPath);
    }
}

