/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import com.sun.rowset.CachedRowSetImpl;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Locale;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSet;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.util.DB;

public class CCachedRowSet
extends CachedRowSetImpl
implements CachedRowSet {
    private static final long serialVersionUID = -233983261449861555L;
    private static Locale s_loc = null;

    public static CCachedRowSet get() throws SQLException {
        CCachedRowSet crs = null;
        if (s_loc == null) {
            s_loc = Locale.getDefault();
            Locale.setDefault(Locale.US);
            crs = new CCachedRowSet();
            Locale.setDefault(s_loc);
        } else {
            crs = new CCachedRowSet();
        }
        return crs;
    }

    public static RowSet getRowSet(String sql) throws SQLException {
        CCachedRowSet crs = CCachedRowSet.get();
        crs.setConcurrency(1007);
        crs.setType(1004);
        crs.setCommand(sql);
        return crs;
    }

    public static RowSet getRowSet(String sql, Connection conn, AdempiereDatabase db) throws SQLException {
        if (db.getName().equals(Database.DB_ORACLE)) {
            Statement stmt = conn.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(sql);
            OracleCachedRowSet crs = new OracleCachedRowSet();
            crs.populate(rs);
            rs.close();
            stmt.close();
            return crs;
        }
        CCachedRowSet crs = CCachedRowSet.get();
        crs.setConcurrency(1007);
        crs.setType(1004);
        crs.setCommand(sql);
        crs.execute(conn);
        return crs;
    }

    public static RowSet getRowSet(ResultSet rs, AdempiereDatabase db) throws SQLException {
        if (db.getName().equals(Database.DB_ORACLE)) {
            OracleCachedRowSet crs = new OracleCachedRowSet();
            crs.populate(rs);
            return crs;
        }
        CCachedRowSet crs = CCachedRowSet.get();
        crs.populate(rs);
        return crs;
    }

    public static RowSet getRowSet(ResultSet rs) throws SQLException {
        return CCachedRowSet.getRowSet(rs, DB.getDatabase());
    }

    private CCachedRowSet() throws SQLException {
        this.setSyncProvider("com.sun.rowset.providers.RIOptimisticProvider");
    }

    public static void main(String[] args) {
        try {
            Locale.setDefault(Locale.CANADA);
            CCachedRowSet.get();
            System.out.println("OK 1");
            CCachedRowSet.get();
            System.out.println("OK 1a");
            new CachedRowSetImpl();
            System.out.println("OK 2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        return super.toCollection();
    }

    @Override
    public Collection<?> toCollection(int column) throws SQLException {
        return super.toCollection(column);
    }

    @Override
    public Collection<?> toCollection(String column) throws SQLException {
        return super.toCollection(column);
    }

    @Override
    public int getInt(int idx) throws SQLException {
        try {
            return super.getInt(idx);
        }
        catch (NullPointerException e) {
            String s = this.getString(idx);
            if (s == null) {
                return 0;
            }
            return Double.valueOf(s).intValue();
        }
    }

    @Override
    public int getInt(String column) throws SQLException {
        try {
            return super.getInt(column);
        }
        catch (NullPointerException e) {
            String s = this.getString(column);
            if (s == null) {
                return 0;
            }
            return Double.valueOf(s).intValue();
        }
    }
}

