/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.planificator;

import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventAttendee;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MClient;
import org.compiere.model.MEvent;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.sogexis.google.GoogleCalendarUtils;

public class GoogleSync
extends SvrProcess {
    private static int POSITION_EMAIL_DISPATCHER = 1;
    private static int POSITION_PASSWORD_DISPATCHER = 2;
    private static int POSITION_AD_ORG_ID = 3;
    private static int POSITION_GOOGLE_ACCOUNT_DEVELOPPEMENT = 4;
    private static int POSITION_PATH_PRIVATE_KEY_GOOGLE = 5;
    private static int POSITION_GOOGLE_CALENDAR_ID = 6;
    private int p_Event_Type_Private_ID = 0;
    private String p_Where_Clause_Google_ID = "";
    private int countCreated = 0;
    private int countNotUpdated = 0;
    private int countUpdated = 0;
    private int countUpdatedDispatcher = 0;
    private int countDeleted = 0;

    @Override
    protected void prepare() {
        this.p_Event_Type_Private_ID = Integer.parseInt(MSysConfig.getValue("SOGEXIS_PLANNING_EVENT_PRIVATE_ID", "0", MClient.get(Env.getCtx()).get_ID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (this.p_Event_Type_Private_ID == 0) {
            return "Il faut configurer l'id du type d'event priv\u00e9";
        }
        String sql = "SELECT Z_EmailDispatcherGoogle, Z_PasswordDispatcherGoogle, AD_Org_ID,  Z_GoogleAccountDevelopement,  Z_PathPrivateKeyGoogle, Z_GoogleID  FROM AD_Org WHERE Z_GoogleID IS NOT NULL";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String Z_EmailDispatcherGoogle = rs.getString(POSITION_EMAIL_DISPATCHER);
                String Z_PasswordDispatcherGoogle = rs.getString(POSITION_PASSWORD_DISPATCHER);
                int AD_Org_ID = rs.getInt(POSITION_AD_ORG_ID);
                String Z_GoogleAccountDevelopement = rs.getString(POSITION_GOOGLE_ACCOUNT_DEVELOPPEMENT);
                String Z_PathPrivateKeyGoogle = rs.getString(POSITION_PATH_PRIVATE_KEY_GOOGLE);
                String Z_GoogleCalendarID = rs.getString(POSITION_GOOGLE_CALENDAR_ID);
                GoogleCalendarUtils googleCalendarUtils = new GoogleCalendarUtils(Z_EmailDispatcherGoogle, Z_PasswordDispatcherGoogle, "", Z_GoogleAccountDevelopement, Z_PathPrivateKeyGoogle);
                for (CalendarListEntry calendar : googleCalendarUtils.listAgenda().getItems()) {
                    if (calendar.isPrimary()) continue;
                    if (calendar.getId().equals(Z_GoogleCalendarID)) {
                        for (Event event : googleCalendarUtils.listEvenementAgenda(calendar.getId(), -2, 15)) {
                            int Z_Event_ID = DB.getSQLValue(null, "SELECT Z_Event_ID FROM Z_Event WHERE Z_GoogleID = " + DB.TO_STRING(event.getId()));
                            if (Z_Event_ID <= 0) continue;
                            this.updateEventDispatcher(googleCalendarUtils, event, Z_Event_ID);
                        }
                    }
                    for (Event event : googleCalendarUtils.listEvenementAgenda(calendar.getId(), -30, 30)) {
                        try {
                            Timestamp googleLastUpdate;
                            int S_Resource_ID;
                            if (Z_EmailDispatcherGoogle.equals(event.getCreator().getEmail()) || (S_Resource_ID = DB.getSQLValue(null, "SELECT S_Resource_ID FROM S_Resource WHERE Z_EmailResourceGoogle = " + DB.TO_STRING(event.getCreator().getEmail()))) <= 0) continue;
                            String googleID = event.getId();
                            int Z_Event_ID = DB.getSQLValue(null, "SELECT Z_Event_ID FROM Z_Event WHERE Z_GoogleID = " + DB.TO_STRING(googleID));
                            MEvent mEvent = null;
                            if (Z_Event_ID <= 0) {
                                mEvent = new MEvent(Env.getCtx(), 0, null);
                                mEvent.settitleEvent(this.p_Event_Type_Private_ID + "");
                                mEvent.setstatusEvent("OP");
                                mEvent.setIsLocked(false);
                                mEvent.setDescription((StringUtils.isEmpty((String)event.getSummary()) ? "" : event.getSummary()) + (StringUtils.isEmpty((String)event.getDescription()) ? "" : "\n\n" + event.getDescription()) + (StringUtils.isEmpty((String)event.getLocation()) ? "" : "\n\n" + event.getLocation()));
                                Timestamp googleLastUpdate2 = new Timestamp(event.getCreated().getValue());
                                googleLastUpdate2.setNanos(0);
                                mEvent.set_ValueOfColumn("Z_lastUpdateGoogle", (Object)googleLastUpdate2);
                            } else {
                                mEvent = new MEvent(Env.getCtx(), Z_Event_ID, null);
                                Timestamp currentLastUpdate = (Timestamp)mEvent.get_Value("Z_lastUpdateGoogle");
                                googleLastUpdate = new Timestamp(event.getUpdated().getValue());
                                googleLastUpdate.setNanos(0);
                                if (currentLastUpdate != null && googleLastUpdate != null && currentLastUpdate.compareTo(googleLastUpdate) >= 0) {
                                    ++this.countNotUpdated;
                                    this.p_Where_Clause_Google_ID = this.p_Where_Clause_Google_ID + DB.TO_STRING(googleID) + ",";
                                    continue;
                                }
                                mEvent.setDescription(StringUtils.isEmpty((String)event.getDescription()) ? (StringUtils.isEmpty((String)event.getSummary()) ? "" : event.getSummary()) : "\n" + (event.getDescription().contains(".:. Remarque .:.") ? event.getDescription().substring(event.getDescription().lastIndexOf(".:. Remarque .:.") + 17) : event.getDescription()));
                            }
                            if (event.getStart().getDateTime() != null) {
                                mEvent.setbeginDateEvent(new Timestamp(event.getStart().getDateTime().getValue()));
                            } else {
                                mEvent.setbeginDateEvent(new Timestamp(event.getStart().getDate().getValue()));
                            }
                            if (event.getEnd().getDateTime() != null) {
                                mEvent.setendDateEvent(new Timestamp(event.getEnd().getDateTime().getValue()));
                            } else {
                                mEvent.setendDateEvent(new Timestamp(event.getEnd().getDate().getValue()));
                            }
                            mEvent.setcontentColorEvent("");
                            mEvent.setheaderColorEvent("");
                            mEvent.set_ValueOfColumn("Z_GoogleIDCalendarUser", (Object)calendar.getId());
                            mEvent.set_ValueOfColumn("Z_GoogleID", (Object)googleID);
                            int AD_Org_ID_Resource = DB.getSQLValue(null, "SELECT AD_Org_ID FROM S_Resource WHERE S_Resource_ID = " + S_Resource_ID);
                            mEvent.setS_Resource_ID(S_Resource_ID);
                            mEvent.setcontentEvent(S_Resource_ID + ";");
                            mEvent.setAD_Org_ID(AD_Org_ID_Resource);
                            if (S_Resource_ID <= 0) continue;
                            if (mEvent.save()) {
                                this.p_Where_Clause_Google_ID = this.p_Where_Clause_Google_ID + DB.TO_STRING(googleID) + ",";
                                if (Z_Event_ID <= 0) {
                                    ++this.countCreated;
                                }
                            }
                            if (Z_Event_ID > 0) {
                                this.deleteResourceAssignLine(mEvent);
                                googleLastUpdate = new Timestamp(event.getUpdated().getValue());
                                googleLastUpdate.setNanos(0);
                                mEvent.set_ValueOfColumn("Z_lastUpdateGoogle", (Object)googleLastUpdate);
                                mEvent.save();
                                ++this.countUpdated;
                            }
                            this.generateRessourceAssignLine(mEvent, S_Resource_ID, AD_Org_ID_Resource);
                            if (event.getAttendees() == null) continue;
                            for (int i2 = 0; i2 < event.getAttendees().size(); ++i2) {
                                S_Resource_ID = DB.getSQLValue(null, "SELECT S_Resource_ID FROM S_Resource WHERE Z_EmailResourceGoogle = " + DB.TO_STRING(((EventAttendee)event.getAttendees().get(i2)).getEmail()));
                                if (S_Resource_ID <= 0) continue;
                                this.generateRessourceAssignLine(mEvent, S_Resource_ID, AD_Org_ID_Resource);
                                mEvent.setcontentEvent(mEvent.getcontentEvent() + S_Resource_ID + ";");
                            }
                            mEvent.save();
                        }
                        catch (Exception e) {
                            System.out.println("=== PROBLEME EVENT ===");
                            System.out.println(event);
                        }
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return null;
    }

    public void generateRessourceAssignLine(MEvent mEvent, int S_Resource_ID, int AD_Org_ID) throws InterruptedException {
        MResourceAssignment ra = new MResourceAssignment(Env.getCtx(), 0, null);
        String nameResource = DB.getSQLValueString(null, "SELECT name FROM S_Resource WHERE S_Resource_ID = " + S_Resource_ID, new Object[0]);
        ra.setS_Resource_ID(S_Resource_ID);
        ra.setAD_Org_ID(AD_Org_ID);
        ra.setAssignDateFrom(mEvent.getbeginDateEvent());
        ra.setAssignDateTo(mEvent.getendDateEvent());
        ra.setName(nameResource);
        ra.setQty(Env.ONE);
        ra.setZ_Event_ID(mEvent.get_ID());
        ra.save();
    }

    public void deleteResourceAssignLine(MEvent mEvent) throws IllegalStateException, SQLException {
        DB.executeUpdate("DELETE FROM S_ResourceAssignment WHERE Z_Event_ID = " + mEvent.get_ID(), null);
        DB.executeUpdate("DELETE FROM Z_Event_Information_Value WHERE Z_Event_ID = " + mEvent.get_ID(), null);
        DB.commit(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcess(boolean success) {
        String sqlToDelete = "SELECT Z_Event_ID  FROM Z_Event  WHERE Z_GoogleID IS NOT NULL  AND Z_GoogleIDCalendarUser IS NOT NULL  AND Z_GoogleID NOT IN (" + this.p_Where_Clause_Google_ID + " '0') " + " AND beginDateEvent >= current_date - interval '2 days' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sqlToDelete, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MEvent mEventToDelete = new MEvent(this.getCtx(), rs.getInt(1), null);
                this.deleteResourceAssignLine(mEventToDelete);
                mEventToDelete.delete(true);
                ++this.countDeleted;
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sqlToDelete, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        System.out.println("Il y a eu " + this.countCreated + " import\u00e9(s)");
        System.out.println("Il y a eu " + this.countNotUpdated + " non besoin de mise \u00e0 jour");
        System.out.println("Il y a eu " + this.countUpdated + " mise \u00e0 jour");
        System.out.println("Il y a eu " + this.countUpdatedDispatcher + " mise \u00e0 jour (dispatcher)");
        System.out.println("Il y a eu " + this.countDeleted + " supprim\u00e9(s)");
        super.postProcess(success);
    }

    protected void updateEventDispatcher(GoogleCalendarUtils googleCalendarUtils, Event event, int Z_Event_ID) {
        if (event.getAttendees() != null) {
            MEvent mEvent = new MEvent(Env.getCtx(), Z_Event_ID, null);
            boolean haveChange = false;
            for (int i2 = 0; i2 < event.getAttendees().size(); ++i2) {
                try {
                    Event eventToShow = googleCalendarUtils.getEvenement(((EventAttendee)event.getAttendees().get(i2)).getEmail(), event.getId());
                    String resourceName = DB.getSQLValueString(null, "SELECT name FROM S_Resource WHERE Z_EmailResourceGoogle = " + DB.TO_STRING(((EventAttendee)event.getAttendees().get(i2)).getEmail()), new Object[0]);
                    if (StringUtils.isEmpty((String)resourceName)) {
                        resourceName = ((EventAttendee)event.getAttendees().get(i2)).getEmail();
                    }
                    if (eventToShow.getDescription() != null && !eventToShow.getDescription().equals(event.getDescription())) {
                        mEvent.setDescription((StringUtils.isEmpty((String)mEvent.getDescription()) ? "" : mEvent.getDescription() + "\n\n") + "REMARQUE de " + resourceName + "\n" + eventToShow.getDescription());
                        haveChange = true;
                    }
                    if (eventToShow.getLocation() != null && !eventToShow.getLocation().equals(event.getLocation())) {
                        mEvent.setDescription((StringUtils.isEmpty((String)mEvent.getDescription()) ? "" : mEvent.getDescription() + "\n\n") + "ADRESSE de " + resourceName + "\n" + eventToShow.getLocation());
                        haveChange = true;
                    }
                    if (!haveChange) continue;
                    Timestamp updatedTime = googleCalendarUtils.editEvenement(event.getOrganizer().getEmail(), event.getId(), new Timestamp(event.getStart().getDateTime().getValue()), new Timestamp(event.getEnd().getDateTime().getValue()), event.getStart().getTimeZone(), eventToShow.getSummary(), eventToShow.getDescription(), eventToShow.getLocation());
                    mEvent.set_ValueOfColumn("Z_lastUpdateGoogle", (Object)updatedTime);
                    mEvent.save();
                    ++this.countUpdatedDispatcher;
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Erreur dans la mise \u00e0 jour du planning du dispatcher");
                }
            }
        }
    }
}

