/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.planificator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CloseDocument
extends SvrProcess {
    private Integer p_interval = 0;
    private String p_docTypeToClose = "";

    @Override
    protected void prepare() {
        this.p_interval = Integer.parseInt(MSysConfig.getValue("SOGEXIS_CLOSE_DOCUMENT_INTERVAL", "6", MClient.get(Env.getCtx()).get_ID()));
        this.p_docTypeToClose = MSysConfig.getValue("SOGEXIS_CLOSE_DOCUMENT_TARGET", "", MClient.get(Env.getCtx()).get_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (this.p_interval == null) {
            return "Il n'y a pas d'interval";
        }
        if (this.p_docTypeToClose == null || this.p_docTypeToClose.isEmpty()) {
            return "Il n'y a pas de type de document \u00e0 cloturer";
        }
        String sql = "SELECT C_Order_ID  FROM C_Order  WHERE DocStatus NOT IN ('CL','VO', 'IN')  AND AD_Client_ID = " + this.getAD_Client_ID() + " AND C_DocTypeTarget_ID IN (" + this.p_docTypeToClose + ")" + " AND dateOrdered < CAST (current_date - interval ' " + this.p_interval + " month' AS Timestamp) ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int converted = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrder mOrder = new MOrder(this.getCtx(), rs.getInt(1), null);
                if (DB.getSQLValue(null, "SELECT COUNT(C_Order_ID) FROM C_Order WHERE documentNo = " + DB.TO_STRING(mOrder.getDocumentNo())) > 1) continue;
                if (mOrder.getDocStatus().equals("IP")) {
                    mOrder.processIt("CO");
                    mOrder.saveEx();
                    mOrder.processIt("CL");
                    if (!mOrder.save()) continue;
                    ++converted;
                    continue;
                }
                if (mOrder.getDocStatus().equals("DR")) {
                    mOrder.delete(true);
                    continue;
                }
                if (!mOrder.processIt("CL") || !mOrder.save()) continue;
                ++converted;
            }
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sql, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "Il y a eu " + converted + " devis converti";
    }
}

