/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.hallou;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;

public class HallouSchedulerEDFOne
extends SvrProcess {
    private int p_AD_Role_ID = 0;
    private int p_R_MailText_ID = 0;
    private MMailText m_MailText = null;
    private MRole m_Role = null;
    private String m_FilePath = null;
    private String mailHeader = new String();
    private String mailContent = new String();
    private String mailTo = new String();
    private String mailCc = new String();
    private List<String> m_Attachments = new ArrayList<String>();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("R_MailText_ID")) {
                this.p_R_MailText_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Role_ID")) {
                this.p_AD_Role_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_FilePath = "/home/adempiere/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (this.p_AD_Role_ID == 0) {
            throw new AdempiereUserError("Il n'y a pas de Role pour l'envoie de mail.");
        }
        if (this.p_R_MailText_ID == 0) {
            throw new AdempiereUserError("Il n'y a pas de mod\u00e8le de mail.");
        }
        if (DB.getSQLValueString(null, "SELECT emailUser FROM AD_User WHERE AD_User_ID = " + this.getAD_User_ID(), new Object[0]) == null) {
            throw new AdempiereUserError("Votre utilisateur n'a pas d'adresse mail configur\u00e9.");
        }
        this.m_MailText = new MMailText(this.getCtx(), this.p_R_MailText_ID, null);
        this.m_Role = new MRole(this.getCtx(), this.p_AD_Role_ID, null);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT zedf.Z_EDF_ID, co.documentNo, COALESCE (cg.name || ' ', '') || cb.name, zedf.Z_DateImportant1, EXTRACT (DAY FROM zedf.Z_DateImportant1 - current_date)  FROM C_Order co  LEFT JOIN C_BPartner cb ON cb.C_BPartner_ID = co.C_BPartner_ID  LEFT JOIN C_Greeting cg ON cg.C_Greeting_ID = cb.C_Greeting_ID  LEFT JOIN Z_EDF zedf on zedf.C_BPartner_ID = co.C_BPartner_ID AND zedf.C_BPartner_Location_ID = co.C_BPartner_Location_ID  WHERE co.DocStatus = 'CO' AND zedf.Z_DateImportant1 IS NOT NULL AND zedf.Z_Status IN ('IP')  ORDER BY zedf.Z_DateImportant1, co.documentNo";
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt(5) > 10) continue;
                this.genWindow(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "Termin\u00e9";
    }

    private void genWindow(int p_record) {
        this.mailHeader = new String();
        this.mailContent = new String();
        this.mailTo = new String();
        this.mailCc = new String();
        this.m_Attachments = new ArrayList<String>();
        List mUsers = new Query(this.getCtx(), "AD_User", " AD_User_ID IN (SELECT AD_User_ID FROM AD_User_Roles WHERE AD_Role_ID = " + this.p_AD_Role_ID + ") AND email IS NOT NULL ", null).setClient_ID().setOnlyActiveRecords(true).list();
        for (MUser mUser : mUsers) {
            if (this.mailTo != null) {
                this.mailTo = this.mailTo + mUser.getEMail() + ",";
                continue;
            }
            this.mailTo = this.mailTo + mUser.getEMail();
        }
        this.mailHeader = this.m_MailText.getMailHeader();
        this.mailContent = this.m_MailText.getMailText();
        this.loadPreview(p_record);
        this.cmd_sendMail();
    }

    private void loadPreview(int p_record) {
        String fullNameBPartner = DB.getSQLValueString(null, "SELECT COALESCE(cg.name || ' ', '') || cb.name FROM C_BPartner cb LEFT JOIN C_Greeting cg ON cg.C_Greeting_ID = cb.C_Greeting_ID WHERE C_BPartner_ID = (SELECT C_BPArtner_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + ") ", new Object[0]);
        this.mailContent = this.mailContent.replaceAll("@Tiers@", fullNameBPartner);
        String adresse1 = DB.getSQLValueString(null, "SELECT address1 FROM C_Location WHERE C_Location_ID = (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + "))", new Object[0]);
        String adresse2 = DB.getSQLValueString(null, "SELECT address2 FROM C_Location WHERE C_Location_ID = (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + "))", new Object[0]);
        String adresse3 = DB.getSQLValueString(null, "SELECT address3 FROM C_Location WHERE C_Location_ID = (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + "))", new Object[0]);
        String city = DB.getSQLValueString(null, "SELECT city FROM C_Location WHERE C_Location_ID = (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + "))", new Object[0]);
        String zip = DB.getSQLValueString(null, "SELECT postal FROM C_Location WHERE C_Location_ID = (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + "))", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(adresse1).append(adresse2 != null ? "\n" + adresse2 : "").append(adresse3 != null ? "\n" + adresse3 : "").append("\n").append(zip + " " + city);
        this.mailContent = this.mailContent.replaceAll("@Adresse@", sb.toString());
        String fixe = DB.getSQLValueString(null, "SELECT COALESCE(phone,'') FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + ")", new Object[0]);
        this.mailContent = fixe.isEmpty() ? this.mailContent.replaceAll("@Fixe@", "") : this.mailContent.replaceAll("@Fixe@", "\nN\u00b0 Fixe : " + fixe);
        String portable = DB.getSQLValueString(null, "SELECT COALESCE(phone2,'') FROM C_BPartner_Location WHERE C_BPartner_Location_ID = (SELECT C_BPartner_Location_ID FROM Z_EDF WHERE Z_EDF_ID = " + p_record + ")", new Object[0]);
        this.mailContent = portable.isEmpty() ? this.mailContent.replaceAll("@Portable@", "") : this.mailContent.replaceAll("@Portable@", "\nN\u00b0 Portable : " + portable);
        String dateButtoir1 = DB.getSQLValueString(null, "SELECT to_char(Z_DateImportant1, 'dd/MM/yyyy') FROM Z_EDF WHERE Z_EDF_ID = " + p_record, new Object[0]);
        this.mailContent = this.mailContent.replaceAll("@DateButtoir1@", dateButtoir1);
    }

    private void cmd_sendMail() {
        MClient client = MClient.get(this.getCtx());
        EMail email = client.createEMail(this.mailTo, this.mailHeader, this.mailContent);
        String emailCurrentUser = DB.getSQLValueString(null, "SELECT emailUser FROM AD_User WHERE AD_User_ID = " + this.getAD_User_ID(), new Object[0]);
        email.setFrom(emailCurrentUser);
        if (!this.mailCc.isEmpty()) {
            for (String s : this.mailCc.split(",")) {
                email.addCc(s);
            }
        }
        for (String s : this.m_Attachments) {
            File attachment = new File(this.m_FilePath + s);
            email.addAttachment(attachment);
        }
        email.send();
    }
}

