/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.cbl.planificator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SogexisUtils;

public class ZExportMachine
extends SvrProcess {
    String path_to_export = "";
    String interval_configuration = "";

    @Override
    protected void prepare() {
        this.path_to_export = MSysConfig.getValue("SOGEXIS_PATH_EXPORT_MACHINE", "N", MClient.get(Env.getCtx()).get_ID());
        this.interval_configuration = MSysConfig.getValue("SOGEXIS_INTERVAL_EXPORT_REQUEST", "N", MClient.get(Env.getCtx()).get_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String sql = "SELECT cb.value || ':' || cb.name || ':' || cl.address1 || COALESCE( ',' || cl.address2, '') || COALESCE( ',' || cl.address3, '') || COALESCE( ',' || cl.address4, '') || COALESCE( ',' || cl.postal, '') || COALESCE( ',' || cl.city, '') || ':' || aa.serno FROM A_Asset aa INNER JOIN C_BPartner cb ON cb.C_BPartner_ID = aa.C_BPartner_ID LEFT JOIN C_BPartner_Location cbl ON cbl.C_BPartner_Location_ID = aa.C_BPartner_Location_ID LEFT JOIN C_Location cl ON cl.C_Location_ID =cbl.C_Location_ID WHERE UPPER(cb.name) <> 'CBL REPRO' AND aa.assetservicedate >= '2001-12-31' AND cb.value IS NOT NULL AND cb.name IS NOT NULL AND aa.Serno IS NOT NULL  AND aa.isActive = 'Y' AND aa.AD_Client_ID > 10000";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int nbr_export = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            while (rs.next()) {
                ArrayList<String> line = new ArrayList<String>();
                line.add(rs.getString(1));
                lines.add(line);
                ++nbr_export;
            }
            SogexisUtils.exportToFileToPDA(this.path_to_export, "codeMachine", lines, "", new Long(0L));
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "Erreur - " + sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.addLog("Il y a eu " + nbr_export + " exportees");
        return "End";
    }
}

