/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.cbl.planificator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SogexisUtils;

public class ZExportImei
extends SvrProcess {
    String path_to_export_operator = "";
    String path_to_export_depot = "";
    String interval_configuration = "";

    @Override
    protected void prepare() {
        this.path_to_export_operator = MSysConfig.getValue("SOGEXIS_PATH_EXPORT_OPERATEUR_IMEI", "N", MClient.get(Env.getCtx()).get_ID());
        this.path_to_export_depot = MSysConfig.getValue("SOGEXIS_PATH_EXPORT_DEPOT_IMEI", "N", MClient.get(Env.getCtx()).get_ID());
        this.interval_configuration = MSysConfig.getValue("SOGEXIS_INTERVAL_EXPORT_REQUEST", "N", MClient.get(Env.getCtx()).get_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String sql_USER = "SELECT UPPER(aa.name) || ':' || aa.Z_IMEI  FROM AD_User aa  WHERE aa.Z_IMEI IS NOT NULL  AND aa.AD_Client_ID > 10000";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int nbr_export_user = 0;
        try {
            pstmt = DB.prepareStatement(sql_USER, null);
            rs = pstmt.executeQuery();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            while (rs.next()) {
                ArrayList<String> line = new ArrayList<String>();
                line.add(rs.getString(1));
                lines.add(line);
                ++nbr_export_user;
            }
            SogexisUtils.exportToFileToPDA(this.path_to_export_operator, "operateurImei", lines, "", new Long(0L));
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, "Erreur - " + sql_USER, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        String sql_DEPOT = "SELECt UPPER(COALESCE(mw.Z_Alias, mw.value)) || ' - ' || UPPER(COALESCE(mw.Z_Alias, mw.name)) || ':' || ml.Z_Imei  FROM M_Locator ml  INNER JOIN M_Warehouse mw ON mw.M_Warehouse_ID = ml.M_Warehouse_ID  WHERE ml.isActive = 'Y' AND ml.Z_IMEI IS NOT NULL  AND ml.AD_Client_ID > 10000";
        pstmt = null;
        rs = null;
        int nbr_export_depot = 0;
        try {
            pstmt = DB.prepareStatement(sql_DEPOT, null);
            rs = pstmt.executeQuery();
            ArrayList<List<String>> lines = new ArrayList<List<String>>();
            while (rs.next()) {
                ArrayList<String> line = new ArrayList<String>();
                line.add(rs.getString(1));
                lines.add(line);
                ++nbr_export_depot;
            }
            SogexisUtils.exportToFileToPDA(this.path_to_export_depot, "depotImei", lines, "", new Long(0L));
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "Erreur - " + sql_DEPOT, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.addLog("Il y a eu " + nbr_export_user + " utilisateurs exportees");
        this.addLog("Il y a eu " + nbr_export_depot + " depot exportees");
        return "End";
    }
}

