/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.cbl;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRecurring;
import org.compiere.model.MRecurringRun;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Recurring;
import org.compiere.model.cbl.YInvoice;
import org.compiere.model.cbl.YInvoiceLine;
import org.compiere.model.cbl.YRecurring;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ZZInvoiceGenerate
extends SvrProcess {
    private int p_C_DocType_ID = 0;
    private int p_C_Invoice_ID = 0;
    private YInvoice m_Invoice = null;
    private Timestamp p_Date;
    private String p_docAction = "CO";
    private String p_docStatus = "CO";
    private Timestamp p_DateFacturation;
    private int m_C_Recurring_ID = 0;
    private Properties localContext = null;
    private Trx localTrx = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private String p_dateOnProcess = "N";
    private String p_formAcess = "N";
    private boolean changeRecurring = false;
    private boolean factured = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Invoice_ID")) {
                this.p_C_Invoice_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DateInvoiced")) {
                this.p_Date = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("ZDateFacturationAvance")) {
                this.p_DateFacturation = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("DocumentStatus")) {
                this.p_docStatus = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("DateOnProcess")) {
                this.p_dateOnProcess = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("FormAcess")) {
                this.p_formAcess = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_docStatus.equals("IP")) {
            this.p_docAction = "PR";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        int C_Invoice_ID;
        if (this.m_C_Recurring_ID == 0 && this.p_Date == null) {
            return Msg.getElement(Env.getCtx(), "DateInvoiced") + " Null";
        }
        this.updateFactured();
        ArrayList<Integer> forfaitList = new ArrayList<Integer>();
        String sql = "select il.C_InvoiceLine_ID, r.C_Recurring_ID,  i.C_Invoice_ID from C_Recurring r inner join C_Invoice i on (i.C_Invoice_ID = r.C_Invoice_ID) inner join C_InvoiceLine il on (il.C_Invoice_ID = i.C_Invoice_ID)  inner join C_DocType dt on (dt.C_DocType_ID = i.C_DocTypeTarget_ID) where r.RecurringType = 'I'  and upper(dt.name) like '%CONTRAT%' and ZIsCompteur = 'N' and ZforfaitAvance = 'Y' and ZForfaitAvanceFacture = 'N' and r.IsActive = 'Y'";
        if (this.p_C_Invoice_ID != 0) {
            sql = sql + " and r.C_Invoice_ID = ?";
        }
        if (this.getC_Recurring_ID() != 0) {
            sql = sql + " and r.C_Recurring_ID = ?";
        }
        sql = sql + " order by r.C_Invoice_ID";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        this.log.info(sql);
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int k = 1;
            if (this.p_C_Invoice_ID != 0) {
                pstmt.setInt(k, this.p_C_Invoice_ID);
                ++k;
            }
            if (this.getC_Recurring_ID() != 0) {
                pstmt.setInt(k, this.getC_Recurring_ID());
                ++k;
            }
            rs = pstmt.executeQuery();
            YInvoice contrat = null;
            YInvoiceLine contratLine = null;
            int c_invoice_id = 0;
            double totalfacture = 0.0;
            int contrat_id = -1;
            while (rs.next()) {
                C_Invoice_ID = rs.getInt(3);
                YRecurring recurrence = new YRecurring(this.getCtx(), rs.getInt(2), this.get_TrxName());
                contrat = new YInvoice(this.getCtx(), recurrence.getC_Invoice_ID(), this.get_TrxName());
                if (contrat_id == -1 || contrat_id != contrat.getID()) {
                    contrat_id = contrat.getID();
                    totalfacture = this.getTotalLinesFactureForfait(contrat);
                }
                contratLine = new YInvoiceLine(this.getCtx(), rs.getInt(1), this.get_TrxName());
                if (this.m_Invoice != null && contrat.getC_Invoice_ID() != c_invoice_id) {
                    this.completeInvoice();
                    this.m_Invoice = null;
                    this.changeRecurring = false;
                }
                this.createLine(recurrence, contrat, contratLine, this.p_C_DocType_ID, this.p_DateFacturation, totalfacture);
                contratLine.setZForfaitAvanceFacture(true);
                contratLine.save(this.get_TrxName());
                forfaitList.add(contrat.getC_Invoice_ID());
                c_invoice_id = C_Invoice_ID;
            }
            if (contrat != null && (this.m_Invoice != null || !this.factured) && this.changeRecurring) {
                this.completeInvoice();
                this.changeRecurring = false;
                if (contratLine != null) {
                    contratLine.setZForfaitAvanceFacture(true);
                    contratLine.save(this.get_TrxName());
                }
                this.m_Invoice = null;
            }
            rs.close();
            pstmt.close();
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        this.m_Invoice = null;
        sql = "select il.C_InvoiceLine_ID, r.C_Recurring_ID, i.C_Invoice_ID, r.DateNextRun, r.RunsMax from C_Recurring r inner join C_Invoice i on (i.C_Invoice_ID = r.C_Invoice_ID) inner join C_InvoiceLine il on (il.C_Invoice_ID = i.C_Invoice_ID)  inner join C_DocType dt on (dt.C_DocType_ID = i.C_DocTypeTarget_ID) where r.RecurringType = 'I'  and upper(dt.name) like '%CONTRAT%' and r.IsActive = 'Y'";
        if (this.p_C_Invoice_ID != 0) {
            sql = sql + " and r.C_Invoice_ID = ?";
        }
        if (this.getC_Recurring_ID() != 0) {
            sql = sql + " and r.C_Recurring_ID = ?";
        }
        if (this.p_Date != null) {
            sql = sql + " and trunc(r.DateNextRun) <= ? ";
        }
        sql = sql + " order by r.C_Invoice_ID, ZIsCompteur desc";
        rs = null;
        pstmt = null;
        this.log.info(sql);
        X_C_Invoice contrat = null;
        X_C_Recurring recurrence = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            int k = 1;
            if (this.p_C_Invoice_ID != 0) {
                pstmt.setInt(k, this.p_C_Invoice_ID);
                ++k;
            }
            if (this.getC_Recurring_ID() != 0) {
                pstmt.setInt(k, this.getC_Recurring_ID());
                ++k;
            }
            if (this.p_Date != null) {
                pstmt.setTimestamp(k, this.p_Date);
            }
            rs = pstmt.executeQuery();
            double totalfacture = 0.0;
            int contrat_id = -1;
            this.changeRecurring = false;
            while (rs.next()) {
                MRecurringRun run;
                YInvoiceLine contratLine = new YInvoiceLine(this.getCtx(), rs.getInt(1), this.get_TrxName());
                C_Invoice_ID = rs.getInt(3);
                if (forfaitList.contains(C_Invoice_ID)) {
                    this.changeRecurring = false;
                    continue;
                }
                if (this.factured) {
                    if (this.m_Invoice != null && (contrat.getC_Invoice_ID() != C_Invoice_ID || contrat == null)) {
                        this.completeInvoice();
                        this.changeRecurring = false;
                        if (recurrence != null && recurrence.getC_Recurring_ID() != rs.getInt(2)) {
                            run = new MRecurringRun(this.getCtx(), (MRecurring)recurrence);
                            run.setC_Invoice_ID(recurrence.getC_Invoice_ID());
                            run.save(this.get_TrxName());
                            recurrence.setDateLastRun(run.getUpdated());
                            recurrence.setRunsRemaining(recurrence.getRunsRemaining() - 1);
                            this.setDateNextRun((YRecurring)recurrence);
                            recurrence.save(this.get_TrxName());
                        }
                    }
                } else if ((contrat == null || contrat.getC_Invoice_ID() != C_Invoice_ID) && this.changeRecurring) {
                    this.completeInvoice();
                    this.changeRecurring = false;
                    if (recurrence != null && recurrence.getC_Recurring_ID() != rs.getInt(2)) {
                        run = new MRecurringRun(this.getCtx(), (MRecurring)recurrence);
                        run.setC_Invoice_ID(recurrence.getC_Invoice_ID());
                        run.save(this.get_TrxName());
                        recurrence.setDateLastRun(run.getUpdated());
                        recurrence.setRunsRemaining(recurrence.getRunsRemaining() - 1);
                        this.setDateNextRun((YRecurring)recurrence);
                        recurrence.save(this.get_TrxName());
                    }
                }
                recurrence = new YRecurring(this.getCtx(), rs.getInt(2), this.get_TrxName());
                Timestamp dateDoc = recurrence.getDateNextRun();
                if (!((YRecurring)recurrence).calculateRuns()) {
                    this.changeRecurring = false;
                    continue;
                }
                contrat = new YInvoice(this.getCtx(), recurrence.getC_Invoice_ID(), this.get_TrxName());
                if (contrat_id == -1 || contrat_id != ((YInvoice)contrat).getID()) {
                    contrat_id = ((YInvoice)contrat).getID();
                    totalfacture = this.getTotalLinesFacture((YInvoice)contrat);
                }
                if (!((YInvoice)contrat).CanBeInvoiced()) {
                    this.changeRecurring = false;
                    continue;
                }
                if (contratLine.IsCompteur() && contratLine.getQtyEntered() != null && contratLine.getQtyEntered().compareTo(Env.ZERO) != 0) {
                    this.createLine((YRecurring)recurrence, (YInvoice)contrat, contratLine, this.p_C_DocType_ID, dateDoc, totalfacture);
                }
                if (!contratLine.IsCompteur() && contratLine.IsZforfaitAvance() && recurrence.getRunsMax() - ((YRecurring)recurrence).getRunsNbr() > 1) {
                    this.createLine((YRecurring)recurrence, (YInvoice)contrat, contratLine, this.p_C_DocType_ID, dateDoc, totalfacture);
                }
                if (contratLine.IsCompteur() || contratLine.IsZforfaitAvance()) continue;
                this.createLine((YRecurring)recurrence, (YInvoice)contrat, contratLine, this.p_C_DocType_ID, dateDoc, totalfacture);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        if (recurrence != null && (this.m_Invoice != null || !this.factured) && this.changeRecurring) {
            MRecurringRun run = new MRecurringRun(this.getCtx(), (MRecurring)recurrence);
            run.setC_Invoice_ID(recurrence.getC_Invoice_ID());
            run.save(this.get_TrxName());
            recurrence.setDateLastRun(run.getUpdated());
            recurrence.setRunsRemaining(recurrence.getRunsRemaining() - 1);
            this.setDateNextRun((YRecurring)recurrence);
            recurrence.save(this.get_TrxName());
        }
        this.completeInvoice();
        this.changeRecurring = false;
        return "@Ok@";
    }

    private void completeInvoice() {
        if (this.m_Invoice == null) {
            return;
        }
        if (!this.p_docStatus.equals("DR") && !this.m_Invoice.processIt(this.p_docAction)) {
            this.log.warning("completeInvoice - failed: " + this.m_Invoice);
        }
        this.m_Invoice.save();
        if (this.m_Invoice.getDocStatus().equals("CO") && this.p_formAcess.equals("Y")) {
            this.addLog(this.m_Invoice.getC_Invoice_ID(), this.m_Invoice.getDateInvoiced(), null, this.m_Invoice.getDocumentNo());
        }
        this.m_Invoice = null;
    }

    private void setDateNextRun(YRecurring recurrence) {
        if (recurrence.getFrequency() < 1) {
            recurrence.setFrequency(1);
        }
        int frequency = recurrence.getFrequency();
        Calendar cal = Calendar.getInstance();
        cal.setTime(recurrence.getDateNextRun());
        if (recurrence.getFrequencyType().equals("D")) {
            cal.add(6, frequency);
        } else if (recurrence.getFrequencyType().equals("W")) {
            cal.add(3, frequency);
        } else if (recurrence.getFrequencyType().equals("M")) {
            cal.add(2, frequency);
        } else if (recurrence.getFrequencyType().equals("Q")) {
            cal.add(2, 3 * frequency);
        } else if (recurrence.getFrequencyType().equals("B")) {
            cal.add(2, 2 * frequency);
        } else if (recurrence.getFrequencyType().equals("H")) {
            cal.add(2, 6 * frequency);
        } else if (recurrence.getFrequencyType().equals("Y")) {
            cal.add(2, 12 * frequency);
        }
        if (recurrence.getFrequencyType().equals("M") || recurrence.getFrequencyType().equals("Q") || recurrence.getFrequencyType().equals("B") || recurrence.getFrequencyType().equals("H") || recurrence.getFrequencyType().equals("Y")) {
            int maxDay = cal.getActualMaximum(5);
            int day = cal.get(5);
            if (day < maxDay) {
                cal.set(5, cal.getActualMaximum(5));
            }
        }
        Timestamp next = new Timestamp(cal.getTimeInMillis());
        recurrence.setDateNextRun(next);
    }

    private void createLine(YRecurring recurrence, YInvoice contrat, YInvoiceLine contratLine, int C_DocType_ID, Timestamp dateDoc, double totalfacture) {
        this.factured = false;
        this.changeRecurring = true;
        if (totalfacture >= 4.0) {
            this.factured = true;
            if (this.m_Invoice == null) {
                Timestamp dateOnInvoice = Env.getContextAsDate(Env.getCtx(), "#Date");
                this.m_Invoice = new YInvoice(contrat.getCtx(), 0, this.get_TrxName());
                PO.copyValues(contrat, this.m_Invoice);
                this.m_Invoice.setAD_Org_ID(contrat.getAD_Org_ID());
                this.m_Invoice.set_ValueOfColumn("AD_Client_ID", (Object)contrat.getAD_Client_ID());
                this.m_Invoice.setC_Invoice_ID(0);
                this.m_Invoice.set_ValueNoCheckSogexis("DocumentNo", null);
                this.m_Invoice.setDocStatus("DR");
                this.m_Invoice.setDocAction(this.p_docAction);
                this.m_Invoice.setC_DocType_ID(C_DocType_ID);
                this.m_Invoice.setC_DocTypeTarget_ID(C_DocType_ID);
                this.m_Invoice.setIsSOTrx(contrat.isSOTrx());
                if (this.p_dateOnProcess.equals("Y")) {
                    dateOnInvoice = this.p_Date;
                }
                this.m_Invoice.setDateInvoiced(dateOnInvoice);
                this.m_Invoice.setDateAcct(dateOnInvoice);
                this.m_Invoice.setDatePrinted(null);
                this.m_Invoice.setIsPrinted(false);
                this.m_Invoice.setIsApproved(false);
                this.m_Invoice.setC_Payment_ID(0);
                this.m_Invoice.setC_CashLine_ID(0);
                this.m_Invoice.setIsPaid(false);
                this.m_Invoice.setIsInDispute(false);
                this.m_Invoice.setGrandTotal(Env.ZERO);
                this.m_Invoice.setTotalLines(Env.ZERO);
                this.m_Invoice.setIsTransferred(false);
                this.m_Invoice.setPosted(false);
                this.m_Invoice.setProcessed(false);
                this.m_Invoice.setIsSelfService(false);
                if (!this.m_Invoice.save(this.get_TrxName())) {
                    throw new IllegalStateException("Could not create Invoice");
                }
                if (contrat != null && this.m_Invoice != null && this.p_formAcess.equals("N")) {
                    super.addLog("Contrat " + contrat.getDocumentNo() + "--> " + this.m_Invoice.getDocumentNo());
                }
            }
            YInvoiceLine line = new YInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(contratLine, line);
            line.setAD_Org_ID(contratLine.getAD_Org_ID());
            line.set_ValueOfColumn("AD_Client_ID", (Object)contratLine.getAD_Client_ID());
            PO.copyValues(contratLine, line);
            line.setC_Invoice_ID(this.m_Invoice.getC_Invoice_ID());
            if (line.IsCompteur()) {
                BigDecimal oldCompteur = contratLine.getZCompteurFacture();
                BigDecimal newCompteur = contratLine.getQtyEntered();
                BigDecimal forfait = contratLine.getqte_forfait();
                BigDecimal difference = newCompteur.subtract(oldCompteur).subtract(forfait);
                if (difference.compareTo(Env.ZERO) > 0) {
                    line.setQtyEntered(difference);
                    line.setQtyInvoiced(difference);
                } else {
                    line.setQtyEntered(Env.ZERO);
                    line.setQtyInvoiced(Env.ZERO);
                }
                if (line.save(this.get_TrxName())) {
                    contratLine.setZCompteurFacture(newCompteur);
                    contratLine.setQtyEntered(Env.ZERO);
                }
                if (!contratLine.Isrecurrent() && line.IsCompteur()) {
                    contratLine.setqte_forfait(Env.ZERO);
                }
                contratLine.set_ValueSogexis("IsFactured", "Y");
                if (!contratLine.save(this.get_TrxName())) {
                    throw new IllegalStateException("Le contrat n'a pas pu \u00eatre mis \u00e0 jour");
                }
            } else {
                line.setQtyEntered(contratLine.getQtyEntered());
                line.setQtyInvoiced(contratLine.getQtyEntered());
                int count = DB.getSQLValue(null, "SELECT count(*) FROM C_InvoiceLine WHERE ZInvoiceContrat_ID = ?", contrat.getC_Invoice_ID());
                StringBuffer description = new StringBuffer("du ");
                if (count <= 0) {
                    description.append(this.sdf.format(contrat.getDateInvoiced())).append(" au ").append(this.sdf.format(recurrence.getDateNextRun()));
                } else if (!contratLine.IsZforfaitAvance()) {
                    description.append(this.sdf.format(recurrence.calculateDate(-1))).append(" au ").append(this.sdf.format(recurrence.getDateNextRun()));
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(recurrence.getDateNextRun());
                    cal.add(5, 1);
                    description.append(this.sdf.format(new Timestamp(cal.getTimeInMillis()))).append(" au ").append(this.sdf.format(recurrence.calculateDate(1)));
                }
                line.setDescription(description.toString());
                if (recurrence.getRunsRemaining() == recurrence.getRunsMax() && count <= 0) {
                    BigDecimal prorata = this.calculateProrata(recurrence, contrat);
                    line.setPriceEntered(line.getPriceEntered().multiply(prorata).setScale(2, 4));
                    line.setPriceActual(line.getPriceActual().multiply(prorata).setScale(2, 4));
                }
            }
            line.setProcessed(false);
            line.setZInvoiceContrat_ID(contrat.getC_Invoice_ID());
            line.save(this.get_TrxName());
        } else if (contratLine.IsCompteur()) {
            BigDecimal newCompteur = contratLine.getQtyEntered();
            contratLine.setZCompteurFacture(newCompteur);
            contratLine.setQtyEntered(Env.ZERO);
            if (!contratLine.Isrecurrent()) {
                contratLine.setqte_forfait(Env.ZERO);
            }
            contratLine.set_ValueSogexis("IsFactured", "Y");
            if (!contratLine.save(this.get_TrxName())) {
                throw new IllegalStateException("Le contrat n'a pas pu \ufffdtre mis \ufffd jour");
            }
        }
    }

    public String doItNow() throws Exception {
        return this.doIt();
    }

    public int getC_Recurring_ID() {
        return this.m_C_Recurring_ID;
    }

    public void setC_Recurring_ID(int C_Recurring_ID) {
        this.m_C_Recurring_ID = C_Recurring_ID;
    }

    @Override
    public Properties getCtx() {
        if (this.localContext != null) {
            return this.localContext;
        }
        return super.getCtx();
    }

    public Properties getLocalContext() {
        return this.localContext;
    }

    public void setLocalContext(Properties localContext) {
        this.localContext = localContext;
    }

    @Override
    public String get_TrxName() {
        if (this.localTrx != null) {
            return this.localTrx.getTrxName();
        }
        return super.get_TrxName();
    }

    public Trx getLocalTrx() {
        return this.localTrx;
    }

    public void setLocalTrx(Trx localTrx) {
        this.localTrx = localTrx;
    }

    public void setDocType(int C_DocType_ID) {
        this.p_C_DocType_ID = C_DocType_ID;
    }

    public void setDateFacturation(Timestamp datefacturation) {
        this.p_DateFacturation = datefacturation;
    }

    private void updateFactured() {
        String sg = "UPDATE C_InvoiceLine set IsFactured='N'";
        int no = DB.executeUpdate(sg, this.get_TrxName());
        this.log.info(no + "Row updated");
    }

    private BigDecimal calculateProrata(YRecurring recurrence, YInvoice contrat) {
        Calendar calDoc = Calendar.getInstance();
        Calendar calNextRun = Calendar.getInstance();
        SimpleDateFormat smd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = smd.parse(contrat.getDateInvoiced().toString());
            Date date2 = smd.parse(recurrence.getDateNextRun().toString());
            calDoc.setTime(date1);
            calNextRun.setTime(date2);
        }
        catch (ParseException e) {
            this.log.severe("Parse Date incorrect : " + e.getMessage());
        }
        double nbr_jours = 0.0;
        if (recurrence.getFrequencyType().equals("D")) {
            nbr_jours = 1.0;
        } else if (recurrence.getFrequencyType().equals("W")) {
            nbr_jours = 7.0;
        } else if (recurrence.getFrequencyType().equals("M")) {
            nbr_jours = 30.0;
        } else if (recurrence.getFrequencyType().equals("Q")) {
            nbr_jours = 90.0;
        } else if (recurrence.getFrequencyType().equals("B")) {
            nbr_jours = 60.0;
        } else if (recurrence.getFrequencyType().equals("H")) {
            nbr_jours = 182.0;
        } else if (recurrence.getFrequencyType().equals("Y")) {
            nbr_jours = 365.0;
        }
        double diff = (double)(calNextRun.getTime().getTime() - calDoc.getTime().getTime()) / 8.64E7;
        BigDecimal difference = BigDecimal.valueOf(diff);
        BigDecimal prorata = difference.divide(BigDecimal.valueOf(nbr_jours), MathContext.DECIMAL32);
        BigDecimal proscal = prorata.setScale(2, 4);
        this.log.info("difference: " + difference + " -- First Prorata: " + prorata);
        if (proscal.compareTo(BigDecimal.valueOf(0.96)) == 1 && proscal.compareTo(BigDecimal.valueOf(1.04)) == -1) {
            prorata = Env.ONE;
        }
        this.log.info("difference: " + difference + " -- Last Prorata: " + prorata);
        return prorata;
    }

    private double getTotalLinesFacture(YInvoice contrat) {
        String sql = "select priceentered,qtyentered,zcompteurfacture,qte_forfait,ziscompteur from c_invoiceline where c_invoice_id = ?";
        double totalfacture = 0.0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, contrat.getID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString(5).equals("Y")) {
                    int difference = rs.getInt(2) - rs.getInt(3) - rs.getInt(4);
                    if (difference <= 0) continue;
                    totalfacture += rs.getDouble(1) * (double)difference;
                    continue;
                }
                totalfacture += rs.getDouble(1) * (double)rs.getInt(2);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return totalfacture;
    }

    private double getTotalLinesFactureForfait(YInvoice contrat) {
        String sql = "select priceentered,qtyentered,zcompteurfacture,qte_forfait,ziscompteur from c_invoiceline where c_invoice_id = ? and Zforfaitavance = 'Y' ";
        double totalfacture = 0.0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, contrat.getID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString(5).equals("Y")) {
                    int difference = rs.getInt(2) - rs.getInt(3) - rs.getInt(4);
                    if (difference <= 0) continue;
                    totalfacture += rs.getDouble(1) * (double)difference;
                    continue;
                }
                totalfacture += rs.getDouble(1) * (double)rs.getInt(2);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return totalfacture;
    }
}

