/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process.android.imp;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.X_M_Movement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SogexisUtils;

public class StockMoveImport
extends SvrProcess {
    private String pathWorking = "";
    private int POSITION_WAREHOUSE_SRC = 0;
    private int POSITION_WAREHOUSE_DEST = 0;
    private int POSITION_USER = 0;
    private int POSITION_SUMMARY = 0;
    private int POSITION_UPC = 0;
    private int POSITION_QTE = 0;
    private String STOCK_MOVE = "Transfert Inter Depot";
    private boolean p_IsCloseDocument = false;
    private List<List<String>> content = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("IsCloseDocument")) {
                this.p_IsCloseDocument = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.pathWorking = MSysConfig.getValue("SOGEXIS_ANDROID_STOCK_MOVE_DIR", "/home/adempiere/PDAAndroid/", MClient.get(Env.getCtx()).get_ID());
        this.POSITION_WAREHOUSE_SRC = 1;
        this.POSITION_WAREHOUSE_DEST = 2;
        this.POSITION_USER = 3;
        this.POSITION_SUMMARY = 4;
        this.POSITION_UPC = 5;
        this.POSITION_QTE = 6;
    }

    @Override
    protected String doIt() throws Exception {
        MMovement mMovement;
        List<File> inventoriesFiles = SogexisUtils.getFilesInDir(this.pathWorking, this.STOCK_MOVE, ".csv");
        String mMovements = "";
        String mWarehousesUsed = "";
        StringBuilder errorMess = null;
        for (File file : inventoriesFiles) {
            List<List<String>> allLines = SogexisUtils.readFile(file, "Transfert");
            if (allLines.size() != 0) {
                MWarehouse mWarehouseSrc = null;
                MLocator mLocatorSrc = null;
                MWarehouse mWarehouseDest = null;
                MLocator mLocatorDest = null;
                PO mMovement2 = null;
                String mWarehouseSrcName = "";
                String mWarehouseDestName = "";
                Integer M_Locator_ID = 0;
                for (int i2 = 0; i2 < allLines.size(); ++i2) {
                    ArrayList<String> tmpLines;
                    if (mWarehouseSrc == null || !mWarehouseSrcName.equals(allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC))) {
                        mWarehouseSrcName = allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC).toUpperCase();
                        mWarehouseSrc = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(value) || ' \u2013 ' || UPPER(name) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC)) + ")"), null);
                        if (mWarehouseSrc.get_ID() == 0) {
                            mWarehouseSrc = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(value) || ' - ' || UPPER(name) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC)) + ")"), null);
                        }
                        if (mWarehouseSrc.get_ID() == 0) {
                            mWarehouseSrc = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(Z_Alias) || ' \u2013 ' || UPPER(Z_Alias) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC)) + ")"), null);
                        }
                        if (mWarehouseSrc.get_ID() == 0) {
                            mWarehouseSrc = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(Z_Alias) || ' - ' || UPPER(Z_Alias) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC)) + ")"), null);
                        }
                        mLocatorSrc = new MLocator(this.getCtx(), DB.getSQLValue(null, "SELECT M_Locator_ID FROM M_Locator WHERE M_Warehouse_ID = " + mWarehouseSrc.get_ID() + " AND isActive = 'Y' AND isDefault = 'Y'"), null);
                        if (!mWarehousesUsed.contains(mWarehouseSrcName)) {
                            mWarehousesUsed = mWarehousesUsed + mWarehouseSrcName + ";";
                            mMovement2 = new MMovement(this.getCtx(), 0, null);
                            mMovement2.setAD_Org_ID(mWarehouseSrc.getAD_Org_ID());
                            ((X_M_Movement)mMovement2).setMovementDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
                            ((X_M_Movement)mMovement2).setC_DocType_ID(1000022);
                            ((X_M_Movement)mMovement2).setDocStatus("DR");
                            ((X_M_Movement)mMovement2).setDescription("// R\u00e9alis\u00e9 par : " + allLines.get(i2).get(this.POSITION_USER));
                            mMovement2.save();
                            mMovements = mMovements + mMovement2.get_ID() + ",";
                        } else {
                            for (String mMovementID : mMovements.split(",")) {
                                if (!mWarehouseSrcName.equals(DB.getSQLValueString(null, "SELECT UPPER(value) || ' \u2013 ' || UPPER(name) FROM M_Warehouse WHERE M_Warehouse_ID = (SELECT M_Warehouse_ID FROM M_Inventory WHERE M_Inventory_ID = " + mMovementID + ") ", new Object[0])) && !mWarehouseSrcName.equals(DB.getSQLValueString(null, "SELECT UPPER(value) || ' - ' || UPPER(name) FROM M_Warehouse WHERE M_Warehouse_ID = (SELECT M_Warehouse_ID FROM M_Inventory WHERE M_Inventory_ID = " + mMovementID + ") ", new Object[0])) && !mWarehouseSrcName.equals(DB.getSQLValueString(null, "SELECT UPPER(Z_Alias) || ' - ' || UPPER(Z_Alias) FROM M_Warehouse WHERE M_Warehouse_ID = (SELECT M_Warehouse_ID FROM M_Inventory WHERE M_Inventory_ID = " + mMovementID + ") ", new Object[0])) && !mWarehouseSrcName.equals(DB.getSQLValueString(null, "SELECT UPPER(Z_Alias) || ' - ' || UPPER(Z_Alias) FROM M_Warehouse WHERE M_Warehouse_ID = (SELECT M_Warehouse_ID FROM M_Inventory WHERE M_Inventory_ID = " + mMovementID + ") ", new Object[0]))) continue;
                                mMovement2 = new MMovement(this.getCtx(), Integer.parseInt(mMovementID), null);
                                break;
                            }
                        }
                    }
                    if (mWarehouseDest == null || !mWarehouseDestName.equals(allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST))) {
                        mWarehouseSrcName = allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST).toUpperCase();
                        mWarehouseDest = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(value) || ' \u2013 ' || UPPER(name) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST)) + ")"), null);
                        if (mWarehouseDest.get_ID() == 0) {
                            mWarehouseDest = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(value) || ' - ' || UPPER(name) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST)) + ")"), null);
                        }
                        if (mWarehouseDest.get_ID() == 0) {
                            mWarehouseDest = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(Z_Alias) || ' \u2013 ' || UPPER(Z_Alias) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST)) + ")"), null);
                        }
                        if (mWarehouseDest.get_ID() == 0) {
                            mWarehouseDest = new MWarehouse(this.getCtx(), DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(Z_Alias) || ' - ' || UPPER(Z_Alias) = UPPER(" + DB.TO_STRING(allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST)) + ")"), null);
                        }
                        mLocatorDest = new MLocator(this.getCtx(), DB.getSQLValue(null, "SELECT M_Locator_ID FROM M_Locator WHERE M_Warehouse_ID = " + mWarehouseDest.get_ID() + " AND isActive = 'Y' AND isDefault = 'Y'"), null);
                        M_Locator_ID = mLocatorDest.get_ID();
                    }
                    Integer M_Product_ID = SogexisUtils.getMProduct(allLines.get(i2).get(this.POSITION_UPC), this.getCtx());
                    BigDecimal qtyMove = new BigDecimal(allLines.get(i2).get(this.POSITION_QTE));
                    String description = allLines.get(i2).get(this.POSITION_SUMMARY);
                    if (M_Product_ID == null || M_Product_ID <= 0) {
                        if (errorMess == null) {
                            errorMess = new StringBuilder();
                            errorMess.append("<table border=\"1\" style=\"border-collapse:collapse;\" ><tr style=\"text-align:center;background-color:#6eb1dd;\"><th>Type</th><th>Menu</th><th>Stock (Src)</th><th>Stock (Dest)</th><th>Operateur</th><th>Description</th><th>Code Article</th><th>Qt\u00e9</th></tr>");
                            this.content = new ArrayList<List<String>>();
                        }
                        errorMess.append("<tr><td>Probleme article non trouv\u00e9.</td><td>" + allLines.get(i2).get(0) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_USER) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_SUMMARY) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_UPC) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_QTE) + "</td>" + "</tr>");
                        tmpLines = new ArrayList<String>();
                        tmpLines.add("Probleme article non trouv\u00e9");
                        tmpLines.addAll((Collection)allLines.get(i2));
                        this.content.add(tmpLines);
                        continue;
                    }
                    if (M_Locator_ID == null || M_Locator_ID <= 0) {
                        if (errorMess == null) {
                            errorMess = new StringBuilder();
                            errorMess.append("<table border=\"1\" style=\"border-collapse:collapse;\" ><tr style=\"text-align:center;background-color:#6eb1dd;\"><th>Type</th><th>Menu</th><th>Stock (Src)</th><th>Stock (Dest)</th><th>Operateur</th><th>Description</th><th>Code Article</th><th>Qt\u00e9</th></tr>");
                            this.content = new ArrayList<List<String>>();
                        }
                        errorMess.append("<tr><td>Probleme emplacement non trouv\u00e9.</td><td>" + allLines.get(i2).get(0) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_WAREHOUSE_SRC) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_WAREHOUSE_DEST) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_USER) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_SUMMARY) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_UPC) + "</td>" + "<td>" + allLines.get(i2).get(this.POSITION_QTE) + "</td>" + "</tr>");
                        tmpLines = new ArrayList();
                        tmpLines.add("Probleme emplacement non trouv\u00e9");
                        tmpLines.addAll((Collection)allLines.get(i2));
                        this.content.add(tmpLines);
                        continue;
                    }
                    MMovementLine mMovementLine = null;
                    int M_MovementLine_ID = DB.getSQLValue(null, "SELECT M_MovementLine_ID FROM M_MovementLine WHERE M_Product_ID = " + M_Product_ID + " AND M_LocatorTo_ID = " + M_Locator_ID + " AND M_Movement_ID = " + mMovement2.get_ID());
                    if (M_MovementLine_ID <= 0) {
                        mMovementLine = new MMovementLine((MMovement)mMovement2);
                        mMovementLine.setAD_Org_ID(mMovement2.getAD_Org_ID());
                        mMovementLine.setM_Product_ID(M_Product_ID);
                        mMovementLine.setM_Locator_ID(mLocatorSrc.get_ID());
                        mMovementLine.setMovementQty(qtyMove);
                        mMovementLine.setM_LocatorTo_ID(M_Locator_ID);
                        if (!StringUtils.isEmpty((String)description)) {
                            mMovementLine.setDescription(description);
                        }
                        mMovementLine.save();
                    } else {
                        mMovementLine = new MMovementLine(this.getCtx(), M_MovementLine_ID, null);
                        mMovementLine.setMovementQty(mMovementLine.getMovementQty().add(qtyMove));
                        if (!StringUtils.isEmpty((String)description)) {
                            mMovementLine.setDescription(StringUtils.isEmpty((String)mMovementLine.getDescription()) ? description : ((X_M_Movement)mMovement2).getDescription() + " : " + description);
                        }
                    }
                    mMovementLine.saveEx();
                }
            }
            if (file == null || !file.isFile()) continue;
            SogexisUtils.movedFile(this.pathWorking + "/" + file.getName(), "/" + this.pathWorking + "/processed/" + file.getName());
        }
        if (errorMess != null) {
            errorMess.append("</table>");
            ArrayList<String> header = new ArrayList<String>();
            header.add("Type");
            header.add("Menu");
            header.add("Stock");
            header.add("Op\u00e9rateur");
            header.add("Emplacement");
            header.add("Article");
            header.add("Quantit\u00e9");
            SogexisUtils.exportToFile("Probleme_Import_Inventaire", header, this.content);
        }
        if (mMovements.length() != 0 && this.p_IsCloseDocument) {
            for (String M_Movement_ID : mMovements.split(",")) {
                mMovement = new MMovement(this.getCtx(), Integer.parseInt(M_Movement_ID), null);
                mMovement.processIt("CO");
                mMovement.saveEx();
                this.addLog("Nouveau tranfert inter d\u00e9p\u00f4t : " + mMovement.getDocumentNo());
            }
        } else if (mMovements.length() != 0) {
            for (String M_Movement_ID : mMovements.split(",")) {
                mMovement = new MMovement(this.getCtx(), Integer.parseInt(M_Movement_ID), null);
                this.addLog("Nouveau tranfert inter d\u00e9p\u00f4t : " + mMovement.getDocumentNo());
            }
        }
        if (errorMess != null) {
            this.addLog(errorMess.toString());
        }
        return "Import Termin\u00e9.";
    }
}

