/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;

public class WarningDLCorDLUO
extends SvrProcess {
    private ArrayList<String> numsDoc;
    private ArrayList<ArrayList<Object>> mesLignes = new ArrayList();
    private String emailLodisFroid;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private ArrayList<String> lignesLodisMail = new ArrayList();

    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        int nbre = 0;
        this.numsDoc = new ArrayList();
        this.emailLodisFroid = (String)((PO)new Query(this.getCtx(), "AD_ORGINFO", "AD_ORG_ID = ?", null).setParameters(1000006).first()).get_Value("email");
        System.out.println("Email de lodis froid: " + this.emailLodisFroid);
        List monStock = new Query(this.getCtx(), "M_Storage", " QTYONHAND > ? AND M_AttributeSetInstance_ID <> 0 ", null).setParameters(0).list();
        Iterator g = monStock.iterator();
        while (g.hasNext()) {
            System.out.println("oh");
            MStorage maligneStock = (MStorage)g.next();
            System.out.println(maligneStock.get_ID() + " : " + maligneStock.getM_Product_ID() + " : " + maligneStock.getM_AttributeSetInstance_ID() + " : " + maligneStock.getM_Product().getName());
            int M_ASI_ID = maligneStock.getM_AttributeSetInstance_ID();
            MAttributeInstance M_AI = (MAttributeInstance)new Query(this.getCtx(), "M_AttributeInstance", "M_AttributeSetInstance_ID = ? AND M_ATTRIBUTE_ID = ?", null).setParameters(M_ASI_ID, 1000004).first();
            if (M_AI == null) continue;
            String valueDLCorDLUO = M_AI.getValue();
            MAttributeSetInstance M_ASI = new MAttributeSetInstance(this.getCtx(), M_ASI_ID, null);
            Timestamp dateGuarantee = M_ASI.getGuaranteeDate();
            MProduct produit = new MProduct(this.getCtx(), maligneStock.getM_Product_ID(), null);
            int productCat = produit.getM_Product_Category_ID();
            int ok = this.verifyProductCat(productCat);
            boolean warning = false;
            if (ok == 1) {
                System.out.println("categorie froid +");
                warning = this.calculDateFrigo(dateGuarantee);
            } else if (ok == 2) {
                System.out.println("categorie froid -");
                warning = this.calculDateCongelo(dateGuarantee);
            }
            MBPartner bpartner = (MBPartner)new Query(this.getCtx(), "C_BPartner", "AD_ORG_ID = ?", null).setParameters(maligneStock.getAD_Org_ID()).first();
            if (!warning) continue;
            System.out.println("warning egal true");
            Boolean found = false;
            System.out.println(this.numsDoc.size());
            if (this.numsDoc.size() == 0) {
                if (bpartner != null) {
                    this.numsDoc.add(bpartner.get_ID() + "_" + nbre);
                }
                found = true;
            } else if (g.hasNext()) {
                for (int i2 = 0; i2 < this.numsDoc.size(); ++i2) {
                    if (!this.numsDoc.get(i2).startsWith(bpartner.get_ID() + "")) continue;
                    found = true;
                    this.numsDoc.set(i2, this.numsDoc.get(i2) + "_" + nbre);
                }
                if (!found.booleanValue()) {
                    this.numsDoc.add(bpartner.get_ID() + "_" + nbre);
                }
            }
            ArrayList<Object> maLigne = new ArrayList<Object>();
            maLigne.add(bpartner);
            maLigne.add(produit);
            maLigne.add(valueDLCorDLUO);
            maLigne.add(dateGuarantee);
            maLigne.add(M_ASI.get_ID());
            maLigne.add(maligneStock.getM_Warehouse_ID());
            this.mesLignes.add(maLigne);
            System.out.println("Taille mes lignes: " + this.mesLignes.size());
            ++nbre;
        }
        this.parcoursVariable();
        return null;
    }

    private void parcoursVariable() {
        System.out.println(this.numsDoc.size());
        if (this.numsDoc.size() > 0) {
            Iterator<String> g = this.numsDoc.iterator();
            System.out.println("nombre de mail a envoyer: " + this.numsDoc.size());
            while (g.hasNext()) {
                String[] docAndIndex = g.next().split("_");
                Integer bpartner_id = Integer.parseInt(docAndIndex[0]);
                this.sendMail(bpartner_id, docAndIndex);
            }
        }
    }

    private void sendMail(Integer bpartner_id, String[] docAndIndex) {
        MClient client = (MClient)new Query(this.getCtx(), "ad_client", "AD_Client_ID = ? ", null).setParameters(1000004).first();
        List users = new Query(this.getCtx(), "AD_USER", "C_BPartner_ID = ? AND NOTIFICATIONTYPE = 'E'", null).setParameters(bpartner_id).list();
        Iterator g = users.iterator();
        String sujet = new String("Stock");
        StringBuffer prepMessage = new StringBuffer();
        prepMessage.append("Madame, Monsieur,<br/>");
        prepMessage.append("<br/>Nous vous informons que les produits ci-dessous arrivent bient\u00f4t \u00e0 leur date limite.<br/>");
        prepMessage.append("<br/><table style=\"text-aglin:center;\">");
        prepMessage.append("<tr style=\"background-color: #66CC33;text-align:center;\"><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">Tiers</th><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">Code</th><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">Nom</th><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">Quantit\u00e9</th><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">DLC - DLUO</th><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">Date de Garantie</th><th style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">Categorie</th></tr>");
        for (int j = 1; j < docAndIndex.length; ++j) {
            int indexLigne = Integer.parseInt(docAndIndex[j]);
            ArrayList<Object> detailLigne = this.mesLignes.get(indexLigne);
            MBPartner bpartner = (MBPartner)detailLigne.get(0);
            MProduct produit = (MProduct)detailLigne.get(1);
            String valueDLCorLUO = (String)detailLigne.get(2);
            Timestamp dateGuarantee = (Timestamp)detailLigne.get(3);
            String maDateGuarantee = sdf.format(new Date(dateGuarantee.getTime()));
            Integer M_ASI = (Integer)detailLigne.get(4);
            Integer M_Warehouse_ID = (Integer)detailLigne.get(5);
            String categorie = "";
            int productCat = produit.getM_Product_Category_ID();
            int ok = this.verifyProductCat(productCat);
            boolean warning = false;
            if (ok == 1) {
                categorie = "Froid +";
            } else if (ok == 2) {
                categorie = "Froid -";
            }
            String colorCSS = "";
            colorCSS = j % 2 == 0 ? "#9999FF" : "#CCCCFF";
            BigDecimal qtyOnHand = this.getQtyOnHand(produit, M_ASI, M_Warehouse_ID);
            StringBuffer ligneTemp = new StringBuffer("<tr style=\"text-align:center;background-color:" + colorCSS + ";\"><td style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">" + bpartner.getName() + "</td><td style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">" + produit.getValue() + "</td><td style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">" + produit.getName() + "</td><td style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">" + qtyOnHand + "</td><td style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">" + valueDLCorLUO + "</td><td style=\"border:1px solid black;\">" + maDateGuarantee + "</td><td style=\"border:1px solid black;padding-left:10px;padding-right:10px;\">" + categorie + "</td></tr>");
            prepMessage.append(ligneTemp.toString());
            this.lignesLodisMail.add(ligneTemp.toString());
        }
        prepMessage.append("</table><br/>A Votre Service,<br/>LODIS FROID");
        prepMessage.append("<br/><br/><span style=\"color:gray;font-style:italic;font-size: x-small;\">(Email g\u00e9n\u00e9r\u00e9 automatiquement par ADempiere de <a href=\"http://www.sogexis.fr\") style=\"text-decoration:underline;color:grey;\">Sogexis</a>)</span>");
        String message = prepMessage.toString();
        while (g.hasNext()) {
            MUser user = (MUser)g.next();
            if (user.getEMail() == null) continue;
            System.out.println("Nom email " + user.getName());
            System.out.println("Email " + user.getEMail());
            EMail email = client.createEMail(user.getEMail(), sujet, null);
            email.setMessageHTML(message);
            email.setFrom(this.emailLodisFroid);
            email.setReplyTo(this.emailLodisFroid);
            email.addCc(this.emailLodisFroid);
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            email.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getQtyOnHand(MProduct mProduct, Integer M_ASI, Integer M_Warehouse_ID) {
        String SQL = "SELECT s.QtyOnHand FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID)  INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID)  LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) WHERE s.M_Product_ID=" + mProduct.get_ID() + " AND l.M_Warehouse_ID=" + M_Warehouse_ID + " AND asi.M_AttributeSetInstance_ID=" + M_ASI;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal qtyOnHand = new BigDecimal(0);
        try {
            pstmt = DB.prepareStatement(SQL.toString(), null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                qtyOnHand = rs.getBigDecimal(1);
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, "Erreur - " + SQL, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return qtyOnHand;
    }

    private boolean calculDateCongelo(Timestamp dateGuarantee) {
        boolean warning = false;
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(dateGuarantee.getTime());
        if (cal.get(1) == cal2.get(1)) {
            System.out.println("meme anne congelo");
            int difference = cal.get(6) - cal2.get(6);
            System.out.println("difference 45/8 jours : " + difference);
            if (difference == 45) {
                warning = true;
            }
            if (difference == 8) {
                warning = true;
            }
        } else if (cal.get(1) - cal2.get(1) == 1) {
            GregorianCalendar cal3 = new GregorianCalendar();
            cal3.set(cal2.get(1) + 1, 0, 1);
            cal3.set(5, -1);
            int diffJour = cal3.get(6) - cal2.get(6);
            GregorianCalendar cal4 = new GregorianCalendar();
            cal4.set(cal.get(1), 0, 1);
            int diffJour2 = cal.get(6) - cal4.get(6);
            int diff = diffJour + diffJour2 + 1;
            System.out.println("difference 45/8 jours : " + diff);
            if (diff == 45) {
                warning = true;
            } else if (diff == 8) {
                warning = true;
            }
        }
        return warning;
    }

    private boolean calculDateFrigo(Timestamp dateGuarantee) {
        boolean warning = false;
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(dateGuarantee.getTime());
        if (cal.get(1) == cal2.get(1)) {
            System.out.println("meme anne frigo");
            int difference = cal.get(6) - cal2.get(6);
            System.out.println("difference 21/8 jours : " + difference);
            if (difference == 21) {
                warning = true;
            }
            if (difference == 8) {
                warning = true;
            }
        } else if (cal.get(1) - cal2.get(1) == 1) {
            GregorianCalendar cal3 = new GregorianCalendar();
            cal3.set(cal2.get(1) + 1, 0, 1);
            ((Calendar)cal3).add(5, -1);
            int diffJour = cal3.get(6) - cal2.get(6);
            GregorianCalendar cal4 = new GregorianCalendar();
            cal4.set(cal.get(1), 0, 1);
            int diffJour2 = cal.get(6) - cal4.get(6);
            int diff = diffJour + diffJour2 + 1;
            System.out.println("difference 21/8 jours : " + diff);
            if (diff == 21) {
                warning = true;
            } else if (diff == 8) {
                warning = true;
            }
        }
        return warning;
    }

    private int verifyProductCat(int productCat) {
        System.out.println("verif produit");
        if (productCat == 1000002) {
            System.out.println("froid plus cat\u00e9gorie");
            return 1;
        }
        if (productCat == 1000001) {
            System.out.println("froid moins categorie");
            return 2;
        }
        return 0;
    }
}

