/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataColumn;
import org.compiere.print.PrintDataElement;
import org.compiere.print.PrintDataFunction;
import org.compiere.print.PrintDataGroup;
import org.compiere.print.TableReference;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class DataEngine {
    private static CLogger log = CLogger.getCLogger(DataEngine.class);
    private String m_synonym = "A";
    private Language m_language = Language.getLoginLanguage();
    private PrintDataGroup m_group = new PrintDataGroup();
    private long m_startTime = System.currentTimeMillis();
    private int m_runningTotalLines = -1;
    private String m_runningTotalString = null;
    private String m_trxName = null;
    private boolean m_summary = false;
    public static final String KEY = "*";

    public DataEngine(Language language) {
        this(language, null);
    }

    public DataEngine(Language language, String trxName) {
        if (language != null) {
            this.m_language = language;
        }
        this.m_trxName = trxName;
    }

    public PrintData getPrintData(Properties ctx, MPrintFormat format, MQuery query) {
        return this.getPrintData(ctx, format, query, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintData getPrintData(Properties ctx, MPrintFormat format, MQuery query, boolean summary) {
        String reportName;
        String tableName;
        block10: {
            block9: {
                ResultSet rs;
                CPreparedStatement pstmt;
                block8: {
                    this.m_summary = summary;
                    if (format == null) {
                        throw new IllegalStateException("No print format");
                    }
                    tableName = null;
                    reportName = format.getName();
                    if (format.getAD_ReportView_ID() == 0) break block9;
                    String sql = "SELECT t.AD_Table_ID, t.TableName, rv.Name, rv.WhereClause FROM AD_Table t INNER JOIN AD_ReportView rv ON (t.AD_Table_ID=rv.AD_Table_ID) WHERE rv.AD_ReportView_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        pstmt = DB.prepareStatement(sql, this.m_trxName);
                        pstmt.setInt(1, format.getAD_ReportView_ID());
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block8;
                        tableName = rs.getString(2);
                        reportName = rs.getString(3);
                        String whereClause = rs.getString(4);
                        if (Util.isEmpty(whereClause)) break block8;
                        query.addRestriction(whereClause);
                    }
                    catch (SQLException e) {
                        PrintData printData;
                        try {
                            log.log(Level.SEVERE, sql, e);
                            printData = null;
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        return printData;
                    }
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                break block10;
            }
            tableName = MTable.getTableName(ctx, format.getAD_Table_ID());
        }
        if (tableName == null) {
            log.log(Level.SEVERE, "Not found Format=" + format);
            return null;
        }
        if (format.isTranslationView() && tableName.toLowerCase().endsWith("_v")) {
            tableName = tableName + "t";
        }
        format.setTranslationViewQuery(query);
        PrintData pd = this.getPrintDataInfo(ctx, format, query, reportName, tableName);
        if (pd == null) {
            return null;
        }
        this.loadPrintData(pd, format);
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintData getPrintDataInfo(Properties ctx, MPrintFormat format, MQuery query, String reportName, String tableName) {
        this.m_startTime = System.currentTimeMillis();
        log.info(reportName + " - " + this.m_language.getAD_Language());
        log.fine("TableName=" + tableName + ", Query=" + query);
        log.fine("Format=" + format);
        ArrayList<PrintDataColumn> columns = new ArrayList<PrintDataColumn>();
        this.m_group = new PrintDataGroup();
        int[] orderAD_Column_IDs = format.getOrderAD_Column_IDs();
        ArrayList<String> orderColumns = new ArrayList<String>(orderAD_Column_IDs.length);
        for (int i2 = 0; i2 < orderAD_Column_IDs.length; ++i2) {
            log.finest("Order AD_Column_ID=" + orderAD_Column_IDs[i2]);
            orderColumns.add("");
        }
        StringBuffer sqlSELECT = new StringBuffer("SELECT ");
        StringBuffer sqlFROM = new StringBuffer(" FROM ").append(tableName);
        ArrayList<String> groupByColumns = new ArrayList<String>();
        boolean IsGroupedBy = false;
        String sql = "SELECT c.AD_Column_ID,c.ColumnName,c.AD_Reference_ID,c.AD_Reference_Value_ID,c.FieldLength,c.IsMandatory,c.IsKey,c.IsParent,COALESCE(rvc.IsGroupFunction,'N'),rvc.FunctionColumn,pfi.IsGroupBy,pfi.IsSummarized,pfi.IsAveraged,pfi.IsCounted, pfi.IsPrinted,pfi.SortNo,pfi.IsPageBreak, pfi.IsMinCalc,pfi.IsMaxCalc, pfi.isRunningTotal,pfi.RunningTotalLines, pfi.IsVarianceCalc, pfi.IsDeviationCalc, c.ColumnSQL, COALESCE(pfi.FormatPattern, c.FormatPattern) FROM AD_PrintFormat pf INNER JOIN AD_PrintFormatItem pfi ON (pf.AD_PrintFormat_ID=pfi.AD_PrintFormat_ID) INNER JOIN AD_Column c ON (pfi.AD_Column_ID=c.AD_Column_ID) LEFT OUTER JOIN AD_ReportView_Col rvc ON (pf.AD_ReportView_ID=rvc.AD_ReportView_ID AND c.AD_Column_ID=rvc.AD_Column_ID) WHERE pf.AD_PrintFormat_ID=? AND pfi.IsActive='Y' AND (pfi.IsPrinted='Y' OR c.IsKey='Y' OR pfi.SortNo > 0)  AND pfi.PrintFormatType IN ('F','I','P') ORDER BY pfi.IsPrinted DESC, pfi.SeqNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.m_trxName);
            pstmt.setInt(1, format.get_ID());
            rs = pstmt.executeQuery();
            this.m_synonym = "A";
            while (rs.next()) {
                String orderName;
                String FunctionColumn;
                int AD_Column_ID = rs.getInt(1);
                String ColumnName = rs.getString(2);
                String ColumnSQL = rs.getString(24);
                if (ColumnSQL == null) {
                    ColumnSQL = "";
                }
                int AD_Reference_ID = rs.getInt(3);
                int AD_Reference_Value_ID = rs.getInt(4);
                int FieldLength = rs.getInt(5);
                boolean IsMandatory = "Y".equals(rs.getString(6));
                boolean IsKey = "Y".equals(rs.getString(7));
                boolean IsParent = "Y".equals(rs.getString(8));
                boolean IsGroupFunction = "Y".equals(rs.getString(9));
                if (IsGroupFunction) {
                    IsGroupedBy = true;
                }
                if ((FunctionColumn = rs.getString(10)) == null) {
                    FunctionColumn = "";
                }
                if ("Y".equals(rs.getString(11))) {
                    this.m_group.addGroupColumn(ColumnName);
                }
                if ("Y".equals(rs.getString(12))) {
                    this.m_group.addFunction(ColumnName, 'S');
                }
                if ("Y".equals(rs.getString(13))) {
                    this.m_group.addFunction(ColumnName, 'A');
                }
                if ("Y".equals(rs.getString(14))) {
                    this.m_group.addFunction(ColumnName, 'C');
                }
                if ("Y".equals(rs.getString(18))) {
                    this.m_group.addFunction(ColumnName, 'm');
                }
                if ("Y".equals(rs.getString(19))) {
                    this.m_group.addFunction(ColumnName, 'M');
                }
                if ("Y".equals(rs.getString(22))) {
                    this.m_group.addFunction(ColumnName, 'V');
                }
                if ("Y".equals(rs.getString(23))) {
                    this.m_group.addFunction(ColumnName, 'D');
                }
                if ("Y".equals(rs.getString(20))) {
                    this.m_runningTotalLines = Math.max(this.m_runningTotalLines, rs.getInt(21));
                }
                boolean IsPrinted = "Y".equals(rs.getString(15));
                int SortNo = rs.getInt(16);
                boolean isPageBreak = "Y".equals(rs.getString(17));
                String formatPattern = rs.getString(25);
                String lookupSQL = orderName = tableName + "." + ColumnName;
                PrintDataColumn pdc = null;
                if (IsKey) {
                    sqlSELECT.append(tableName).append(".").append(ColumnName).append(",");
                    groupByColumns.add(tableName + "." + ColumnName);
                    pdc = new PrintDataColumn(AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, KEY, isPageBreak);
                } else if (IsPrinted) {
                    String display;
                    if (IsParent && DisplayType.isLookup(AD_Reference_ID) || AD_Reference_ID == 19 || AD_Reference_ID == 30 && AD_Reference_Value_ID == 0) {
                        String eSql;
                        if (ColumnSQL.length() > 0) {
                            eSql = MLookupFactory.getLookup_TableDirEmbed(this.m_language, ColumnName, tableName, "(" + ColumnSQL + ")");
                            lookupSQL = ColumnSQL;
                        } else {
                            eSql = MLookupFactory.getLookup_TableDirEmbed(this.m_language, ColumnName, tableName);
                        }
                        String table2 = ColumnName;
                        if (table2.endsWith("_ID")) {
                            table2 = table2.substring(0, table2.length() - 3);
                        }
                        display = ColumnName;
                        sqlSELECT.append("(").append(eSql).append(") AS ").append(this.m_synonym).append(display).append(",").append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                        groupByColumns.add(lookupSQL);
                        orderName = this.m_synonym + display;
                        pdc = new PrintDataColumn(AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                        this.synonymNext();
                    } else if (AD_Reference_ID == 18 || AD_Reference_ID == 30 && AD_Reference_Value_ID != 0) {
                        if (ColumnSQL.length() > 0) {
                            lookupSQL = ColumnSQL;
                        }
                        if (AD_Reference_Value_ID <= 0) {
                            log.warning(ColumnName + " - AD_Reference_Value_ID not set");
                            continue;
                        }
                        TableReference tr2 = DataEngine.getTableReference(AD_Reference_Value_ID);
                        String display2 = tr2.DisplayColumn;
                        if (tr2.IsValueDisplayed) {
                            sqlSELECT.append(this.m_synonym).append(".Value||'-'||");
                        }
                        sqlSELECT.append(this.m_synonym).append(".").append(display2);
                        sqlSELECT.append(" AS ").append(this.m_synonym).append(display2).append(",").append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                        groupByColumns.add(this.m_synonym + display2);
                        groupByColumns.add(lookupSQL);
                        orderName = this.m_synonym + display2;
                        if (IsMandatory) {
                            sqlFROM.append(" INNER JOIN ");
                        } else {
                            sqlFROM.append(" LEFT OUTER JOIN ");
                        }
                        sqlFROM.append(tr2.TableName).append(" ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".").append(tr2.KeyColumn).append(")");
                        pdc = new PrintDataColumn(AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                        this.synonymNext();
                    } else if (AD_Reference_ID == 17 || AD_Reference_ID == 28 && AD_Reference_Value_ID != 0) {
                        if (ColumnSQL.length() > 0) {
                            lookupSQL = ColumnSQL;
                        }
                        if (Env.isBaseLanguage(this.m_language, "AD_Ref_List")) {
                            sqlSELECT.append(this.m_synonym).append(".Name AS ").append(this.m_synonym).append("Name,");
                            groupByColumns.add(this.m_synonym + ".Name");
                            orderName = this.m_synonym + "Name";
                            if (IsMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append("AD_Ref_List ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".Value").append(" AND ").append(this.m_synonym).append(".AD_Reference_ID=").append(AD_Reference_Value_ID).append(")");
                        } else {
                            sqlSELECT.append(this.m_synonym).append(".Name AS ").append(this.m_synonym).append("Name,");
                            groupByColumns.add(this.m_synonym + ".Name");
                            orderName = this.m_synonym + "Name";
                            if (IsMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append(" AD_Ref_List X").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=X").append(this.m_synonym).append(".Value AND X").append(this.m_synonym).append(".AD_Reference_ID=").append(AD_Reference_Value_ID).append(")");
                            if (IsMandatory) {
                                sqlFROM.append(" INNER JOIN ");
                            } else {
                                sqlFROM.append(" LEFT OUTER JOIN ");
                            }
                            sqlFROM.append(" AD_Ref_List_Trl ").append(this.m_synonym).append(" ON (X").append(this.m_synonym).append(".AD_Ref_List_ID=").append(this.m_synonym).append(".AD_Ref_List_ID").append(" AND ").append(this.m_synonym).append(".AD_Language='").append(this.m_language.getAD_Language()).append("')");
                        }
                        sqlSELECT.append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                        pdc = new PrintDataColumn(AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                        this.synonymNext();
                    } else if (AD_Reference_ID == 21 || AD_Reference_ID == 25 || AD_Reference_ID == 31 || AD_Reference_ID == 35) {
                        if (ColumnSQL.length() > 0) {
                            lookupSQL = ColumnSQL;
                        }
                        String table3 = "";
                        String key = "";
                        display = "";
                        String synonym = null;
                        if (AD_Reference_ID == 21) {
                            table3 = "C_Location";
                            key = "C_Location_ID";
                            display = "City||'.'";
                            synonym = "Address";
                        } else if (AD_Reference_ID == 25) {
                            table3 = "C_ValidCombination";
                            key = "C_ValidCombination_ID";
                            display = "Combination";
                        } else if (AD_Reference_ID == 31) {
                            table3 = "M_Locator";
                            key = "M_Locator_ID";
                            display = "Value";
                        } else if (AD_Reference_ID == 35) {
                            table3 = "M_AttributeSetInstance";
                            key = "M_AttributeSetInstance_ID";
                            display = "Description";
                            if (CLogMgt.isLevelFine()) {
                                display = display + "||'{'||" + this.m_synonym + ".M_AttributeSetInstance_ID||'}'";
                            }
                            synonym = "Description";
                        }
                        if (synonym == null) {
                            synonym = display;
                        }
                        sqlSELECT.append(this.m_synonym).append(".").append(display).append(" AS ").append(this.m_synonym).append(synonym).append(",").append(lookupSQL).append(" AS ").append(ColumnName).append(",");
                        groupByColumns.add(this.m_synonym + "." + synonym);
                        groupByColumns.add(lookupSQL);
                        orderName = this.m_synonym + synonym;
                        if (IsMandatory) {
                            sqlFROM.append(" INNER JOIN ");
                        } else {
                            sqlFROM.append(" LEFT OUTER JOIN ");
                        }
                        sqlFROM.append(table3).append(" ").append(this.m_synonym).append(" ON (").append(lookupSQL).append("=").append(this.m_synonym).append(".").append(key).append(")");
                        pdc = new PrintDataColumn(AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, orderName, isPageBreak);
                        this.synonymNext();
                    } else {
                        StringBuffer sb;
                        int index = FunctionColumn.indexOf(64);
                        if (ColumnSQL != null && ColumnSQL.length() > 0) {
                            sqlSELECT.append(ColumnSQL).append(" AS ").append(ColumnName).append(",");
                            if (!IsGroupFunction) {
                                groupByColumns.add(ColumnSQL);
                            }
                            orderName = ColumnName;
                        } else if (index == -1) {
                            sb = new StringBuffer();
                            sb.append(tableName).append(".").append(ColumnName);
                            sqlSELECT.append(sb).append(",");
                            if (!IsGroupFunction) {
                                groupByColumns.add(sb.toString());
                            }
                        } else {
                            sb = new StringBuffer();
                            sb.append(FunctionColumn.substring(0, index)).append(tableName).append(".").append(ColumnName).append(FunctionColumn.substring(index + 1));
                            sqlSELECT.append(sb).append(" AS ").append(ColumnName).append(",");
                            if (!IsGroupFunction) {
                                groupByColumns.add(sb.toString());
                            }
                            orderName = ColumnName;
                        }
                        pdc = new PrintDataColumn(AD_Column_ID, ColumnName, AD_Reference_ID, FieldLength, ColumnName, isPageBreak);
                    }
                }
                for (int i3 = 0; i3 < orderAD_Column_IDs.length; ++i3) {
                    if (AD_Column_ID != orderAD_Column_IDs[i3]) continue;
                    orderColumns.set(i3, orderName);
                    if (IsPrinted || IsGroupFunction) break;
                    groupByColumns.add(tableName + "." + ColumnName);
                    break;
                }
                if (pdc == null || !IsPrinted && !IsKey) continue;
                pdc.setFormatPattern(formatPattern);
                columns.add(pdc);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, "SQL=" + sql + " - ID=" + format.get_ID(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (columns.size() == 0) {
            log.log(Level.SEVERE, "No Colums - Delete Report Format " + reportName + " and start again");
            log.finest("No Colums - SQL=" + sql + " - ID=" + format.get_ID());
            return null;
        }
        boolean hasLevelNo = false;
        if (tableName.startsWith("T_Report")) {
            hasLevelNo = true;
            if (sqlSELECT.indexOf("LevelNo") == -1) {
                sqlSELECT.append("LevelNo,");
            }
        }
        StringBuffer finalSQL = new StringBuffer();
        finalSQL.append(sqlSELECT.substring(0, sqlSELECT.length() - 1)).append(sqlFROM);
        if (tableName.startsWith("T_Report")) {
            finalSQL.append(" WHERE ");
            for (int i4 = 0; i4 < query.getRestrictionCount(); ++i4) {
                String q = query.getWhereClause(i4);
                if (q.indexOf("AD_PInstance_ID") == -1) continue;
                finalSQL.append(q);
            }
        } else {
            MRole role;
            if (query != null && query.isActive()) {
                finalSQL.append(" WHERE ");
                if (!query.getTableName().equals(tableName)) {
                    query.setTableName(tableName);
                }
                finalSQL.append(query.getWhereClause(true));
            }
            if ((role = MRole.getDefault(ctx, false)).getAD_Role_ID() != 0 || Ini.isClient()) {
                finalSQL = new StringBuffer(role.addAccessSQL(finalSQL.toString(), tableName, true, false));
            }
        }
        if (IsGroupedBy) {
            for (int i5 = 0; i5 < groupByColumns.size(); ++i5) {
                if (i5 == 0) {
                    finalSQL.append(" GROUP BY ");
                } else {
                    finalSQL.append(",");
                }
                finalSQL.append((String)groupByColumns.get(i5));
            }
        }
        if (orderColumns != null) {
            for (int i6 = 0; i6 < orderColumns.size(); ++i6) {
                if (i6 == 0) {
                    finalSQL.append(" ORDER BY ");
                } else {
                    finalSQL.append(",");
                }
                String by = (String)orderColumns.get(i6);
                if (by == null || by.length() == 0) {
                    by = String.valueOf(i6 + 1);
                }
                finalSQL.append(by);
            }
        }
        PrintData pd = new PrintData(ctx, reportName);
        PrintDataColumn[] info = new PrintDataColumn[columns.size()];
        columns.toArray(info);
        pd.setColumnInfo(info);
        pd.setTableName(tableName);
        pd.setSQL(finalSQL.toString());
        pd.setHasLevelNo(hasLevelNo);
        log.finest(finalSQL.toString());
        log.finest("Group=" + this.m_group);
        return pd;
    }

    private void synonymNext() {
        int length = this.m_synonym.length();
        char cc = this.m_synonym.charAt(0);
        if (cc == 'Z') {
            cc = 'A';
            ++length;
        } else {
            cc = (char)(cc + 1);
        }
        this.m_synonym = String.valueOf(cc);
        if (length == 1) {
            return;
        }
        this.m_synonym = this.m_synonym + String.valueOf(cc);
        if (length == 2) {
            return;
        }
        this.m_synonym = this.m_synonym + String.valueOf(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableReference getTableReference(int AD_Reference_Value_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        TableReference tr2;
        block5: {
            if (AD_Reference_Value_ID <= 0) {
                throw new IllegalArgumentException("AD_Reference_Value_ID <= 0");
            }
            tr2 = new TableReference();
            String SQL = "SELECT t.TableName, ck.ColumnName AS KeyColumn, cd.ColumnName AS DisplayColumn, rt.IsValueDisplayed, cd.IsTranslated FROM AD_Ref_Table rt INNER JOIN AD_Table t ON (rt.AD_Table_ID = t.AD_Table_ID) INNER JOIN AD_Column ck ON (rt.AD_Key = ck.AD_Column_ID) INNER JOIN AD_Column cd ON (rt.AD_Display = cd.AD_Column_ID) WHERE rt.AD_Reference_ID=? AND rt.IsActive = 'Y' AND t.IsActive = 'Y'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(SQL, null);
                pstmt.setInt(1, AD_Reference_Value_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                tr2.TableName = rs.getString(1);
                tr2.KeyColumn = rs.getString(2);
                tr2.DisplayColumn = rs.getString(3);
                tr2.IsValueDisplayed = "Y".equals(rs.getString(4));
                tr2.IsTranslated = "Y".equals(rs.getString(5));
            }
            catch (SQLException ex) {
                try {
                    log.log(Level.SEVERE, SQL, ex);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return tr2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrintData(PrintData pd, MPrintFormat format) {
        String valueString;
        Object value;
        boolean translateSpool = pd.getTableName().equals("T_Spool");
        this.m_runningTotalString = Msg.getMsg(format.getLanguage(), "RunningTotal");
        int rowNo = 0;
        PrintDataColumn pdc = null;
        boolean hasLevelNo = pd.hasLevelNo();
        int levelNo = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(pd.getSQL(), this.m_trxName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                levelNo = hasLevelNo ? rs.getInt("LevelNo") : 0;
                if (this.m_group.getGroupColumnCount() > 1) {
                    for (int i2 = pd.getColumnInfo().length - 1; i2 >= 0; --i2) {
                        PrintDataColumn group_pdc = pd.getColumnInfo()[i2];
                        if (!this.m_group.isGroupColumn(group_pdc.getColumnName()) || (value = this.m_group.groupChange(group_pdc.getColumnName(), rs.getObject(group_pdc.getAlias()))) == null) continue;
                        char[] functions = this.m_group.getFunctions(group_pdc.getColumnName());
                        for (int f = 0; f < functions.length; ++f) {
                            this.printRunningTotal(pd, levelNo, rowNo++);
                            pd.addRow(true, levelNo);
                            for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                                pdc = pd.getColumnInfo()[c];
                                if (group_pdc.getColumnName().equals(pdc.getColumnName())) {
                                    valueString = value.toString();
                                    if (value instanceof Timestamp) {
                                        valueString = DisplayType.getDateFormat(pdc.getDisplayType(), this.m_language).format(value);
                                    }
                                    valueString = valueString + PrintDataFunction.getFunctionSymbol(functions[f]);
                                    pd.addNode(new PrintDataElement(pdc.getColumnName(), valueString, 10, false, pdc.isPageBreak(), pdc.getFormatPattern()));
                                    continue;
                                }
                                if (!this.m_group.isFunctionColumn(pdc.getColumnName(), functions[f])) continue;
                                pd.addNode(new PrintDataElement(pdc.getColumnName(), this.m_group.getValue(group_pdc.getColumnName(), pdc.getColumnName(), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), false, pdc.isPageBreak(), pdc.getFormatPattern()));
                            }
                        }
                        for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                            pdc = pd.getColumnInfo()[c];
                            this.m_group.reset(group_pdc.getColumnName(), pdc.getColumnName());
                        }
                    }
                }
                this.printRunningTotal(pd, levelNo, rowNo++);
                if (!this.m_summary) {
                    pd.addRow(false, levelNo);
                }
                int counter = 1;
                for (int i3 = 0; i3 < pd.getColumnInfo().length; ++i3) {
                    pdc = pd.getColumnInfo()[i3];
                    PrintDataElement pde = null;
                    if (pdc.getAlias().equals(KEY)) {
                        if (pdc.getColumnName().endsWith("_ID")) {
                            int id = rs.getInt(counter++);
                            if (!rs.wasNull()) {
                                KeyNamePair pp = new KeyNamePair(id, KEY);
                                pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), true, pdc.isPageBreak(), pdc.getFormatPattern());
                            }
                        } else {
                            String id = rs.getString(counter++);
                            if (!rs.wasNull()) {
                                ValueNamePair pp = new ValueNamePair(id, KEY);
                                pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), true, pdc.isPageBreak(), pdc.getFormatPattern());
                            }
                        }
                    } else if (pdc.hasAlias()) {
                        String display = rs.getString(counter++);
                        if (pdc.getColumnName().endsWith("_ID")) {
                            int id = rs.getInt(counter++);
                            if (display != null && !rs.wasNull()) {
                                KeyNamePair pp = new KeyNamePair(id, display);
                                pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), pdc.getFormatPattern());
                            }
                        } else {
                            String id = rs.getString(counter++);
                            if (display != null && !rs.wasNull()) {
                                ValueNamePair pp = new ValueNamePair(id, display);
                                pde = new PrintDataElement(pdc.getColumnName(), pp, pdc.getDisplayType(), pdc.getFormatPattern());
                            }
                        }
                    } else if (pdc.getDisplayType() == 20) {
                        String s = rs.getString(counter++);
                        if (!rs.wasNull()) {
                            boolean b2 = s.equals("Y");
                            pde = new PrintDataElement(pdc.getColumnName(), new Boolean(b2), pdc.getDisplayType(), pdc.getFormatPattern());
                        }
                    } else if (pdc.getDisplayType() == 36) {
                        Clob clob;
                        String value2 = "";
                        if ("java.lang.String".equals(rs.getMetaData().getColumnClassName(counter))) {
                            value2 = rs.getString(counter++);
                        } else if ((clob = rs.getClob(counter++)) != null) {
                            long length = clob.length();
                            value2 = clob.getSubString(1L, (int)length);
                        }
                        pde = new PrintDataElement(pdc.getColumnName(), value2, pdc.getDisplayType(), pdc.getFormatPattern());
                    } else if (pdc.getDisplayType() == 16) {
                        Timestamp datetime = rs.getTimestamp(counter++);
                        pde = new PrintDataElement(pdc.getColumnName(), datetime, pdc.getDisplayType(), pdc.getFormatPattern());
                    } else {
                        Object obj;
                        if ((obj = rs.getObject(counter++)) != null && obj instanceof String && ((String)(obj = ((String)obj).trim())).length() == 0) {
                            obj = null;
                        }
                        if (obj != null) {
                            if (translateSpool && obj instanceof String) {
                                String s = (String)obj;
                                s = Msg.parseTranslation(pd.getCtx(), s);
                                pde = new PrintDataElement(pdc.getColumnName(), s, pdc.getDisplayType(), pdc.getFormatPattern());
                            } else {
                                pde = new PrintDataElement(pdc.getColumnName(), obj, pdc.getDisplayType(), pdc.getFormatPattern());
                            }
                        }
                    }
                    if (pde == null) continue;
                    if (!this.m_summary) {
                        pd.addNode(pde);
                    }
                    this.m_group.addValue(pde.getColumnName(), pde.getFunctionValue());
                }
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, pdc + " - " + e.getMessage() + "\nSQL=" + pd.getSQL());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.m_group.getGroupColumnCount() > 1) {
            for (int i4 = pd.getColumnInfo().length - 1; i4 >= 0; --i4) {
                PrintDataColumn group_pdc = pd.getColumnInfo()[i4];
                if (!this.m_group.isGroupColumn(group_pdc.getColumnName()) || (value = this.m_group.groupChange(group_pdc.getColumnName(), new Object())) == null) continue;
                char[] functions = this.m_group.getFunctions(group_pdc.getColumnName());
                for (int f = 0; f < functions.length; ++f) {
                    this.printRunningTotal(pd, levelNo, rowNo++);
                    pd.addRow(true, levelNo);
                    for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                        pdc = pd.getColumnInfo()[c];
                        if (group_pdc.getColumnName().equals(pdc.getColumnName())) {
                            valueString = value.toString();
                            if (value instanceof Timestamp) {
                                valueString = DisplayType.getDateFormat(pdc.getDisplayType(), this.m_language).format(value);
                            }
                            valueString = valueString + PrintDataFunction.getFunctionSymbol(functions[f]);
                            pd.addNode(new PrintDataElement(pdc.getColumnName(), valueString, 10, pdc.getFormatPattern()));
                            continue;
                        }
                        if (!this.m_group.isFunctionColumn(pdc.getColumnName(), functions[f])) continue;
                        pd.addNode(new PrintDataElement(pdc.getColumnName(), this.m_group.getValue(group_pdc.getColumnName(), pdc.getColumnName(), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), pdc.getFormatPattern()));
                    }
                }
            }
        }
        if (this.m_group.isGroupColumn("=TOTAL=")) {
            char[] functions = this.m_group.getFunctions("=TOTAL=");
            for (int f = 0; f < functions.length; ++f) {
                this.printRunningTotal(pd, levelNo, rowNo++);
                pd.addRow(true, levelNo);
                for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                    pdc = pd.getColumnInfo()[c];
                    if (c == 0) {
                        String name = "";
                        if (!format.getTableFormat().isPrintFunctionSymbols()) {
                            name = Msg.getMsg(format.getLanguage(), PrintDataFunction.getFunctionName(functions[f]));
                        }
                        name = name + PrintDataFunction.getFunctionSymbol(functions[f]);
                        pd.addNode(new PrintDataElement(pdc.getColumnName(), name.trim(), 10, pdc.getFormatPattern()));
                        continue;
                    }
                    if (!this.m_group.isFunctionColumn(pdc.getColumnName(), functions[f])) continue;
                    pd.addNode(new PrintDataElement(pdc.getColumnName(), this.m_group.getValue("=TOTAL=", pdc.getColumnName(), functions[f]), PrintDataFunction.getFunctionDisplayType(functions[f], pdc.getDisplayType()), pdc.getFormatPattern()));
                }
            }
        }
        if (pd.getRowCount() == 0) {
            if (CLogMgt.isLevelFiner()) {
                log.warning("NO Rows - ms=" + (System.currentTimeMillis() - this.m_startTime) + " - " + pd.getSQL());
            } else {
                log.warning("NO Rows - ms=" + (System.currentTimeMillis() - this.m_startTime));
            }
        } else {
            log.info("Rows=" + pd.getRowCount() + " - ms=" + (System.currentTimeMillis() - this.m_startTime));
        }
    }

    private void printRunningTotal(PrintData pd, int levelNo, int rowNo) {
        if (this.m_runningTotalLines < 1) {
            return;
        }
        log.fine("(" + this.m_runningTotalLines + ") - Row=" + rowNo + ", mod=" + rowNo % this.m_runningTotalLines);
        if (rowNo % this.m_runningTotalLines != 0) {
            return;
        }
        log.fine("Row=" + rowNo);
        PrintDataColumn pdc = null;
        int start = 0;
        if (rowNo == 0) {
            start = 1;
        }
        for (int rt = start; rt < 2; ++rt) {
            pd.addRow(true, levelNo);
            for (int c = 0; c < pd.getColumnInfo().length; ++c) {
                pdc = pd.getColumnInfo()[c];
                if (c == 0) {
                    String title = "RunningTotal";
                    pd.addNode(new PrintDataElement(pdc.getColumnName(), title, 10, false, rt == 0, pdc.getFormatPattern()));
                    continue;
                }
                if (!this.m_group.isFunctionColumn(pdc.getColumnName(), 'S')) continue;
                pd.addNode(new PrintDataElement(pdc.getColumnName(), this.m_group.getValue("=TOTAL=", pdc.getColumnName(), 'S'), PrintDataFunction.getFunctionDisplayType('S', pdc.getDisplayType()), false, false, pdc.getFormatPattern()));
            }
        }
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        DataEngine de = new DataEngine(Language.getLanguage("de_DE"));
        MQuery query = new MQuery();
        query.addRestriction("AD_Table_ID", "<", 105);
    }
}

