/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model.cbl;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.cbl.YInvoiceLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class YInvoice
extends MInvoice {
    private static final long serialVersionUID = -7140743911057314076L;

    public YInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
    }

    public boolean set_ValueNoCheckSogexis(String ColumnName, Object value) {
        return super.set_ValueNoCheck(ColumnName, value);
    }

    public YInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YInvoiceLine[] getLines(String whereClause) {
        ArrayList<YInvoiceLine> list = new ArrayList<YInvoiceLine>();
        String sql = "SELECT * FROM C_InvoiceLine WHERE C_Invoice_ID=? ";
        if (whereClause != null) {
            sql = sql + whereClause;
        }
        sql = sql + " ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Invoice_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                YInvoiceLine il = new YInvoiceLine(this.getCtx(), rs, this.get_TrxName());
                il.setInvoice(this);
                list.add(il);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", e);
        }
        finally {
            DB.close(null, pstmt);
        }
        YInvoiceLine[] lines = new YInvoiceLine[list.size()];
        list.toArray(lines);
        return lines;
    }

    public boolean CanBeInvoiced() {
        YInvoiceLine[] Lines = this.getLines(" AND IsFactured = 'N'");
        int C_DocTypeTarget_ID = this.getC_DocTypeTarget_ID();
        String sql = "select dt.C_DocType_ID from C_DocType dt where upper(dt.name) LIKE '%CONTRAT%' and dt.C_DocType_ID = ?";
        int c_doctype_id = DB.getSQLValue(this.get_TrxName(), sql, C_DocTypeTarget_ID);
        boolean aFacturer = true;
        for (int i2 = 0; i2 < Lines.length; ++i2) {
            YInvoiceLine invoiceLine = Lines[i2];
            if (invoiceLine.getQtyEntered() == null || invoiceLine.getQtyEntered().compareTo(Env.ZERO) == 0) {
                aFacturer = false;
                break;
            }
            if (c_doctype_id == -1) continue;
            if (invoiceLine.IsCompteur() && invoiceLine.getQtyEntered().compareTo(Env.ZERO) != 0 && invoiceLine.getQtyEntered().compareTo(invoiceLine.getZCompteurInitial()) < 0) {
                aFacturer = false;
                break;
            }
            if (invoiceLine.IsCompteur() && invoiceLine.getZCompteurInterm().compareTo(Env.ZERO) != 0 && invoiceLine.getZCompteurInterm().compareTo(invoiceLine.getZCompteurInitial()) < 0) {
                aFacturer = false;
                break;
            }
            if (invoiceLine.IsCompteur() && invoiceLine.getQtyEntered().compareTo(Env.ZERO) != 0 && invoiceLine.getZCompteurInterm().compareTo(Env.ZERO) != 0 && invoiceLine.getQtyEntered().compareTo(invoiceLine.getZCompteurInterm()) < 0) {
                aFacturer = false;
                break;
            }
            if (!invoiceLine.IsCompteur() || invoiceLine.getQtyEntered().compareTo(Env.ZERO) == 0 || invoiceLine.getZCompteurFacture().compareTo(Env.ZERO) == 0 || invoiceLine.getQtyEntered().compareTo(invoiceLine.getZCompteurFacture()) >= 0) continue;
            aFacturer = false;
            break;
        }
        return aFacturer;
    }

    public int getID() {
        return super.get_ID();
    }
}

