/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTree_Base;
import org.compiere.model.X_AD_TreeNodeCMS;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MTree_NodeCMS
extends X_AD_TreeNodeCMS {
    private static final long serialVersionUID = -8092902713429554718L;
    private static CLogger s_log = CLogger.getCLogger(MTree_NodeCMS.class);

    public static MTree_NodeCMS[] getTree(Properties ctx, int AD_Tree_ID, String trxName) {
        ArrayList<MTree_NodeCMS> list = new ArrayList<MTree_NodeCMS>();
        String sql = "SELECT * FROM AD_TreeNodeCMS WHERE AD_Tree_ID=? ORDER BY Node_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Tree_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTree_NodeCMS(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MTree_NodeCMS[] retValue = new MTree_NodeCMS[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MTree_NodeCMS get(MTree_Base tree, int Node_ID) {
        MTree_NodeCMS retValue = null;
        String sql = "SELECT * FROM AD_TreeNodeCMS WHERE AD_Tree_ID=? AND Node_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, tree.get_TrxName());
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, Node_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MTree_NodeCMS(tree.getCtx(), rs, tree.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "get", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MTree_NodeCMS(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTree_NodeCMS(MTree_Base tree, int Node_ID) {
        super(tree.getCtx(), 0, tree.get_TrxName());
        this.setClientOrg(tree);
        this.setAD_Tree_ID(tree.getAD_Tree_ID());
        this.setNode_ID(Node_ID);
        this.setParent_ID(0);
        this.setSeqNo(0);
    }
}

