/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_M_ProductPrice;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class MProductPrice
extends X_M_ProductPrice {
    private static final long serialVersionUID = 9187555438223385521L;
    private static CLogger s_log = CLogger.getCLogger(MProductPrice.class);

    public static MProductPrice get(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, String trxName) {
        String whereClause = "M_PriceList_Version_ID=? AND M_Product_ID=?";
        MProductPrice retValue = (MProductPrice)new Query(ctx, "M_ProductPrice", "M_PriceList_Version_ID=? AND M_Product_ID=?", trxName).setParameters(M_PriceList_Version_ID, M_Product_ID).first();
        return retValue;
    }

    public MProductPrice(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setPriceLimit(Env.ZERO);
        this.setPriceList(Env.ZERO);
        this.setPriceStd(Env.ZERO);
    }

    public MProductPrice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductPrice(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.setM_Product_ID(M_Product_ID);
    }

    public MProductPrice(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit, String trxName) {
        this(ctx, M_PriceList_Version_ID, M_Product_ID, trxName);
        this.setPrices(PriceList, PriceStd, PriceLimit);
    }

    public MProductPrice(MPriceListVersion plv, int M_Product_ID, BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit) {
        this(plv.getCtx(), 0, plv.get_TrxName());
        this.setClientOrg(plv);
        this.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setPrices(PriceList, PriceStd, PriceLimit);
    }

    public void setPrices(BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit) {
        this.setPriceLimit(PriceLimit.setScale(this.getM_PriceList_Version().getM_PriceList().getPricePrecision(), 4));
        this.setPriceList(PriceList.setScale(this.getM_PriceList_Version().getM_PriceList().getPricePrecision(), 4));
        this.setPriceStd(PriceStd.setScale(this.getM_PriceList_Version().getM_PriceList().getPricePrecision(), 4));
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProductPrice[");
        sb.append(this.getM_PriceList_Version_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",PriceList=").append(this.getPriceList()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return super.beforeSave(newRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block40: {
            String group;
            block42: {
                String UpdateProductPriceForGroup = MSysConfig.getValue("SOGEXIS_SAE_PRODUCT_SYNCHRONIZE", "N", MClient.get(Env.getCtx()).get_ID());
                if (!UpdateProductPriceForGroup.equals("Y")) break block40;
                if (newRecord) break block42;
                String group2 = DB.getSQLValueString(null, "SELECT group1 FROM M_Product WHERE M_Product_ID = " + this.getM_Product_ID(), new Object[0]);
                if (group2 != null && !group2.isEmpty()) {
                    Trx trx2 = Trx.get("Synchro", true);
                    String sqlUpdate = "";
                    String isSOList = DB.getSQLValueString(null, "SELECT issopricelist FROM M_PriceList WHERE M_PriceList_ID = (SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID = " + this.getM_PriceList_Version_ID() + ")", new Object[0]);
                    if (isSOList.equals("Y")) {
                        String typeMargin = MSysConfig.getValue("SOGEXIS_TYPE_MARGE", "MT", MClient.get(Env.getCtx()).get_ID());
                        if (typeMargin.equals("MT")) {
                            sqlUpdate = "UPDATE M_ProductPrice SET PriceList = " + this.getPriceList() + ", PriceStd =" + this.getPriceStd() + ", Z_Marge = ROUND(COALESCE((((" + this.getPriceStd() + " * 100) / PriceLimit) - 100),0),2)" + " WHERE M_Product_ID <> " + this.getM_Product_ID() + " AND M_PriceList_Version_ID = " + this.getM_PriceList_Version_ID() + " AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE upper(group1) = (SELECT upper(group1) FROM M_Product WHERE M_Product_ID = " + this.getM_Product_ID() + ")) ";
                        } else if (typeMargin.equals("MB")) {
                            sqlUpdate = "UPDATE M_ProductPrice SET PriceList = " + this.getPriceList() + ", PriceStd =" + this.getPriceStd() + ", Z_Marge = CASE WHEN (" + this.getPriceStd() + " =0) THEN 0 ELSE ROUND((((" + this.getPriceStd() + " - PriceLimit) / " + this.getPriceStd() + ") * 100),2) END" + " WHERE M_Product_ID <> " + this.getM_Product_ID() + " AND M_PriceList_Version_ID = " + this.getM_PriceList_Version_ID() + " AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE upper(group1) = (SELECT upper(group1) FROM M_Product WHERE M_Product_ID = " + this.getM_Product_ID() + ")) ";
                        }
                    } else {
                        sqlUpdate = "UPDATE M_ProductPrice SET PriceList = " + this.getPriceList() + ", PriceStd =" + this.getPriceStd() + " WHERE M_Product_ID <> " + this.getM_Product_ID() + " AND M_PriceList_Version_ID = " + this.getM_PriceList_Version_ID() + " AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product WHERE upper(group1) = (SELECT upper(group1) FROM M_Product WHERE M_Product_ID = " + this.getM_Product_ID() + ")) ";
                    }
                    DB.executeUpdate(sqlUpdate, trx2.getTrxName());
                    try {
                        DB.commit(false, trx2.getTrxName());
                    }
                    catch (Exception e) {
                        trx2.rollback();
                    }
                    finally {
                        trx2.close();
                    }
                }
                break block40;
            }
            if (this.get_TrxName() != null && !this.get_TrxName().equals("ToCreate") && (group = DB.getSQLValueString(null, "SELECT group1 FROM M_Product WHERE M_Product_ID = " + this.getM_Product_ID(), new Object[0])) != null && !group.isEmpty()) {
                Trx trx = Trx.get("ToCreate", true);
                String sqlProducts = "SELECT M_Product_ID, value, Z_PUMP FROM M_Product WHERE M_Product_ID <> " + this.getM_Product_ID() + " AND isActive = 'Y' " + " AND upper(Group1) = (SELECT upper(group1) FROM M_Product WHERE M_Product_ID = " + this.getM_Product_ID() + ") ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                pstmt = DB.prepareStatement(sqlProducts, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MProductPrice mProductPrice = new MProductPrice(this.getCtx(), 0, trx.getTrxName());
                    mProductPrice.setM_Product_ID(rs.getInt(1));
                    mProductPrice.setM_PriceList_Version_ID(this.getM_PriceList_Version_ID());
                    mProductPrice.setPriceLimit(rs.getBigDecimal(3));
                    mProductPrice.setPriceList(this.getPriceList());
                    mProductPrice.setPriceStd(this.getPriceStd());
                    String isSOList = DB.getSQLValueString(null, "SELECT issopricelist FROM M_PriceList WHERE M_PriceList_ID = (SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID = " + this.getM_PriceList_Version_ID() + ")", new Object[0]);
                    if (isSOList.equals("Y")) {
                        BigDecimal marge;
                        String typeMargin = MSysConfig.getValue("SOGEXIS_TYPE_MARGE", "MT", MClient.get(Env.getCtx()).get_ID());
                        if (typeMargin.equals("MT")) {
                            if (rs.getBigDecimal(3).compareTo(Env.ZERO) == 0) {
                                mProductPrice.set_Value("Z_Marge", (Object)Env.ZERO);
                            } else {
                                marge = this.getPriceStd().multiply(Env.ONEHUNDRED);
                                marge = marge.divide(rs.getBigDecimal(3), 2, 5);
                                marge = marge.subtract(Env.ONEHUNDRED);
                                mProductPrice.set_Value("Z_Marge", (Object)marge.setScale(2, 5));
                            }
                        } else if (typeMargin.equals("MB")) {
                            if (this.getPriceStd().compareTo(Env.ZERO) == 0) {
                                mProductPrice.set_Value("Z_Marge", (Object)Env.ZERO);
                            } else {
                                marge = this.getPriceStd().subtract(rs.getBigDecimal(3));
                                marge = marge.divide(this.getPriceStd(), 2, 5);
                                marge = marge.multiply(Env.ONEHUNDRED);
                                mProductPrice.set_Value("Z_Marge", (Object)marge.setScale(2, 5));
                            }
                        }
                    }
                    mProductPrice.save();
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                try {
                    DB.commit(false, trx.getTrxName());
                }
                catch (Exception e) {
                    trx.rollback();
                }
                finally {
                    trx.close();
                }
                catch (SQLException ex) {
                    try {
                        this.log.log(Level.SEVERE, sqlProducts, ex);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        try {
                            DB.commit(false, trx.getTrxName());
                        }
                        catch (Exception e) {
                            trx.rollback();
                        }
                        finally {
                            trx.close();
                        }
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    try {
                        DB.commit(false, trx.getTrxName());
                    }
                    catch (Exception e) {
                        trx.rollback();
                    }
                    finally {
                        trx.close();
                    }
                }
            }
        }
        return super.afterSave(newRecord, success);
    }
}

