/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MExpenseType;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductCosting;
import org.compiere.model.MProductDownload;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.model.X_I_Product;
import org.compiere.model.X_M_Product;
import org.compiere.model.X_z_marque;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class MProduct
extends X_M_Product {
    private static final long serialVersionUID = 285926961771269935L;
    private static CCache<Integer, MProduct> s_cache = new CCache("M_Product", 40, 5);
    private MProductDownload[] m_downloads = null;
    private Integer m_precision = null;

    public static MProduct get(Properties ctx, int M_Product_ID) {
        if (M_Product_ID <= 0) {
            return null;
        }
        Integer key = new Integer(M_Product_ID);
        MProduct retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProduct(ctx, M_Product_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MProduct[] get(Properties ctx, String whereClause, String trxName) {
        List<MProduct> list = new Query(ctx, "M_Product", whereClause, trxName).setClient_ID().list();
        return list.toArray(new MProduct[list.size()]);
    }

    public static List<MProduct> getByUPC(Properties ctx, String upc, String trxName) {
        String whereClause = "UPC LIKE ?";
        Query q = new Query(ctx, "M_Product", "UPC LIKE ?", trxName);
        q.setParameters("%" + upc + "%").setClient_ID();
        return q.list();
    }

    public static MProduct forS_Resource_ID(Properties ctx, int S_Resource_ID) {
        return MProduct.forS_Resource_ID(ctx, S_Resource_ID, null);
    }

    public static MProduct forS_Resource_ID(Properties ctx, int S_Resource_ID, String trxName) {
        MProduct p2;
        if (S_Resource_ID <= 0) {
            return null;
        }
        if (trxName == null) {
            for (MProduct p3 : s_cache.values()) {
                if (p3.getS_Resource_ID() != S_Resource_ID) continue;
                return p3;
            }
        }
        if ((p2 = (MProduct)new Query(ctx, "M_Product", "S_Resource_ID=?", trxName).setParameters(S_Resource_ID).firstOnly()) != null && trxName == null) {
            s_cache.put(p2.getM_Product_ID(), p2);
        }
        return p2;
    }

    public static boolean isProductStocked(Properties ctx, int M_Product_ID) {
        MProduct product = MProduct.get(ctx, M_Product_ID);
        return product.isStocked();
    }

    public MProduct(Properties ctx, int M_Product_ID, String trxName) {
        super(ctx, M_Product_ID, trxName);
        if (M_Product_ID == 0) {
            this.setProductType("I");
            this.setIsBOM(false);
            this.setIsInvoicePrintDetails(false);
            this.setIsPickListPrintDetails(false);
            this.setIsPurchased(true);
            this.setIsSold(true);
            this.setIsStocked(true);
            this.setIsSummary(false);
            this.setIsVerified(false);
            this.setIsWebStoreFeatured(false);
            this.setIsSelfService(true);
            this.setIsExcludeAutoDelivery(false);
            this.setProcessing(false);
            this.setLowLevel(0);
        }
    }

    public MProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct(MExpenseType et) {
        this(et.getCtx(), 0, et.get_TrxName());
        this.setProductType("E");
        this.setExpenseType(et);
    }

    public MProduct(MResource resource, MResourceType resourceType) {
        this(resource.getCtx(), 0, resource.get_TrxName());
        this.setAD_Org_ID(resource.getAD_Org_ID());
        this.setProductType("R");
        this.setResource(resource);
        this.setResource(resourceType);
    }

    public MProduct(X_I_Product impP) {
        this(impP.getCtx(), 0, impP.get_TrxName());
        this.setClientOrg(impP);
        this.setUpdatedBy(impP.getUpdatedBy());
        this.setValue(impP.getValue());
        this.setName(impP.getName());
        this.setDescription(impP.getDescription());
        this.setDocumentNote(impP.getDocumentNote());
        this.setHelp(impP.getHelp());
        this.setUPC(impP.getUPC());
        this.setSKU(impP.getSKU());
        this.setC_UOM_ID(impP.getC_UOM_ID());
        this.setM_Product_Category_ID(impP.getM_Product_Category_ID());
        this.setProductType(impP.getProductType());
        this.setImageURL(impP.getImageURL());
        this.setDescriptionURL(impP.getDescriptionURL());
    }

    public boolean setExpenseType(MExpenseType parent) {
        boolean changed = false;
        if (!"E".equals(this.getProductType())) {
            this.setProductType("E");
            changed = true;
        }
        if (parent.getS_ExpenseType_ID() != this.getS_ExpenseType_ID()) {
            this.setS_ExpenseType_ID(parent.getS_ExpenseType_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResource parent) {
        boolean changed = false;
        if (!"R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getS_Resource_ID() != this.getS_Resource_ID()) {
            this.setS_Resource_ID(parent.getS_Resource_ID());
            changed = true;
        }
        if (parent.isActive() != this.isActive()) {
            this.setIsActive(parent.isActive());
            changed = true;
        }
        if (!parent.getValue().equals(this.getValue())) {
            this.setValue(parent.getValue());
            changed = true;
        }
        if (!parent.getName().equals(this.getName())) {
            this.setName(parent.getName());
            changed = true;
        }
        if (parent.getDescription() == null && this.getDescription() != null || parent.getDescription() != null && !parent.getDescription().equals(this.getDescription())) {
            this.setDescription(parent.getDescription());
            changed = true;
        }
        return changed;
    }

    public boolean setResource(MResourceType parent) {
        boolean changed = false;
        if ("R".equals(this.getProductType())) {
            this.setProductType("R");
            changed = true;
        }
        if (parent.getC_UOM_ID() != this.getC_UOM_ID()) {
            this.setC_UOM_ID(parent.getC_UOM_ID());
            changed = true;
        }
        if (parent.getM_Product_Category_ID() != this.getM_Product_Category_ID()) {
            this.setM_Product_Category_ID(parent.getM_Product_Category_ID());
            changed = true;
        }
        if (parent.getC_TaxCategory_ID() != this.getC_TaxCategory_ID()) {
            this.setC_TaxCategory_ID(parent.getC_TaxCategory_ID());
            changed = true;
        }
        return changed;
    }

    public int getUOMPrecision() {
        if (this.m_precision == null) {
            int C_UOM_ID = this.getC_UOM_ID();
            if (C_UOM_ID == 0) {
                return 0;
            }
            this.m_precision = new Integer(MUOM.getPrecision(this.getCtx(), C_UOM_ID));
        }
        return this.m_precision;
    }

    public int getA_Asset_Group_ID() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID();
    }

    public boolean isCreateAsset() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        return pc.getA_Asset_Group_ID() != 0;
    }

    public MAttributeSet getAttributeSet() {
        if (this.getM_AttributeSet_ID() != 0) {
            return MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        }
        return null;
    }

    public boolean isInstanceAttribute() {
        if (this.getM_AttributeSet_ID() == 0) {
            return false;
        }
        MAttributeSet mas = MAttributeSet.get(this.getCtx(), this.getM_AttributeSet_ID());
        return mas.isInstanceAttribute();
    }

    public boolean isOneAssetPerUOM() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return false;
        }
        MAssetGroup ag = MAssetGroup.get(this.getCtx(), pc.getA_Asset_Group_ID());
        return ag.isOneAssetPerUOM();
    }

    public boolean isItem() {
        return "I".equals(this.getProductType());
    }

    @Override
    public boolean isStocked() {
        return super.isStocked() && this.isItem();
    }

    public boolean isService() {
        return !this.isItem();
    }

    public String getUOMSymbol() {
        int C_UOM_ID = this.getC_UOM_ID();
        if (C_UOM_ID == 0) {
            return "";
        }
        return MUOM.get(this.getCtx(), C_UOM_ID).getUOMSymbol();
    }

    public MProductDownload[] getProductDownloads(boolean requery) {
        if (this.m_downloads != null && !requery) {
            return this.m_downloads;
        }
        List<MProductDownload> list = new Query(this.getCtx(), "M_ProductDownload", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("Name").setParameters(this.get_ID()).list();
        this.m_downloads = list.toArray(new MProductDownload[list.size()]);
        return this.m_downloads;
    }

    public boolean hasDownloads() {
        return this.getProductDownloads(false).length > 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProduct[");
        sb.append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && (this.is_ValueChanged("IsActive") && !this.isActive() || this.is_ValueChanged("IsStocked") && !this.isStocked() || this.is_ValueChanged("ProductType") && "I".equals(this.get_ValueOld("ProductType")))) {
            MStorage[] storages = MStorage.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
            BigDecimal OnHand = Env.ZERO;
            BigDecimal Ordered = Env.ZERO;
            BigDecimal Reserved = Env.ZERO;
            for (int i2 = 0; i2 < storages.length; ++i2) {
                OnHand = OnHand.add(storages[i2].getQtyOnHand());
                Ordered = Ordered.add(storages[i2].getQtyOrdered());
                Reserved = Reserved.add(storages[i2].getQtyReserved());
            }
            String errMsg = "";
            if (OnHand.signum() != 0) {
                errMsg = "@QtyOnHand@ = " + OnHand;
            }
            if (Ordered.signum() != 0) {
                errMsg = errMsg + " - @QtyOrdered@ = " + Ordered;
            }
            if (Reserved.signum() != 0) {
                errMsg = errMsg + " - @QtyReserved@" + Reserved;
            }
            if (errMsg.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), errMsg));
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("C_UOM_ID") && this.hasInventoryOrCost()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "SaveUomError"));
            return false;
        }
        if (!"I".equals(this.getProductType())) {
            this.setIsStocked(false);
        }
        if (this.m_precision != null && this.is_ValueChanged("C_UOM_ID")) {
            this.m_precision = null;
        }
        if (this.is_ValueChanged("M_AttributeSet_ID")) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(0);
            try {
                asi.deleteEx(true, this.get_TrxName());
            }
            catch (AdempiereException ex) {
                this.log.saveError("Error", "Error deleting the AttributeSetInstance");
                return false;
            }
        }
        String activeOptionSomid = MSysConfig.getValue("SOGEXIS_SOMID_ARTICLE_BEFORE_SAVE", "N", MClient.get(this.getCtx()).get_ID());
        String nbrCaractereCodeArticle = MSysConfig.getValue("SOGEXIS_SOMID_ARTICLE_NBR_CARACTERE", "6", MClient.get(this.getCtx()).get_ID());
        if (activeOptionSomid.equals("Y") && (this.getValue() == null || this.getValue().trim().length() == 0)) {
            String genCodeToConcat = "";
            X_z_marque mMarque = null;
            if (this.getUPC() != null && this.getUPC().length() > Integer.parseInt(nbrCaractereCodeArticle)) {
                genCodeToConcat = this.getUPC().substring(this.getUPC().length() - Integer.parseInt(nbrCaractereCodeArticle));
            } else if (this.getUPC() != null && this.getUPC().length() < Integer.parseInt(nbrCaractereCodeArticle)) {
                genCodeToConcat = this.getUPC();
            } else if (this.getUPC() != null && this.getUPC().length() == Integer.parseInt(nbrCaractereCodeArticle)) {
                genCodeToConcat = this.getUPC();
            } else {
                throw new AdempiereException("Il n'y a pas de code barre");
            }
            if (genCodeToConcat.length() != 0) {
                Integer idMarque = (Integer)this.get_Value("z_marque_id");
                if (idMarque != null) {
                    mMarque = new X_z_marque(this.getCtx(), idMarque, null);
                    this.setValue(mMarque.getValue() + genCodeToConcat);
                } else {
                    throw new AdempiereException("Il n'y a pas de marque : M_Product_ID = " + this.get_ID());
                }
            }
        }
        return true;
    }

    protected boolean hasInventoryOrCost() {
        boolean hasTrx = new Query(this.getCtx(), "M_Transaction", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.get_ID()).match();
        if (hasTrx) {
            return true;
        }
        boolean hasCosts = new Query(this.getCtx(), "M_CostDetail", "M_Product_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.get_ID()).match();
        return hasCosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        String UpdateProductPriceForGroup;
        String activeOptionSomid;
        if (!success) {
            return success;
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "M_Product_ID=" + this.getM_Product_ID(), this.get_TrxName());
        }
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description"))) {
            String sql = "UPDATE A_Asset a SET (Name, Description)=(SELECT SUBSTR((SELECT bp.Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=a.C_BPartner_ID) || ' - ' || p.Name,1,60), p.Description FROM M_Product p WHERE p.M_Product_ID=a.M_Product_ID) WHERE IsActive='Y'  AND M_Product_ID=" + this.getM_Product_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Asset Description updated #" + no);
        }
        if (newRecord) {
            this.insert_Accounting("M_Product_Acct", "M_Product_Category_Acct", "p.M_Product_Category_ID=" + this.getM_Product_Category_ID());
            this.insert_Tree("PR");
            MAcctSchema[] mass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
            for (int i2 = 0; i2 < mass.length; ++i2) {
                MProductCosting pcOld = new MProductCosting(this, mass[i2].getC_AcctSchema_ID());
                pcOld.save();
            }
        }
        if (newRecord || this.is_ValueChanged("M_Product_Category_ID")) {
            MCost.create(this);
        }
        if ((activeOptionSomid = MSysConfig.getValue("SOGEXIS_SOMID_ARTICLE_BEFORE_SAVE", "N", MClient.get(this.getCtx()).get_ID())).equals("Y") && this.getSKU() != null && this.getSKU().trim().length() != 0) {
            if (new Query(this.getCtx(), "M_Product", " M_Product_ID = ? ", null).setParameters(this.getM_Product_ID()).first() == null) {
                Trx trx = Trx.get(this.get_TrxName(), true);
                trx.commit();
            }
            X_z_marque mMarque = null;
            Integer idMarque = (Integer)this.get_Value("z_marque_id");
            mMarque = new X_z_marque(this.getCtx(), idMarque, null);
            if (mMarque.getC_BPartner_ID() == 0) throw new AdempiereException("La marque ne poss\u00e8de pas de fournisseur");
            MProductPO mProductPO = (MProductPO)new Query(this.getCtx(), "M_Product_PO", " C_BPartner_ID = ? AND M_Product_ID = ?", null).setParameters(mMarque.getC_BPartner_ID(), this.getM_Product_ID()).first();
            if (mProductPO == null) {
                List mProductPOs = new Query(this.getCtx(), "M_Product_PO", " M_Product_ID = ?", null).setParameters(this.getM_Product_ID()).list();
                for (MProductPO mProductPOToDelete : mProductPOs) {
                    mProductPOToDelete.delete(true);
                }
                mProductPO = new MProductPO(this.getCtx(), 0, null);
                mProductPO.setM_Product_ID(this.getM_Product_ID());
                mProductPO.setAD_Client_ID(this.getAD_Client_ID());
                mProductPO.setAD_Org_ID(this.getAD_Org_ID());
                mProductPO.setC_BPartner_ID(mMarque.getC_BPartner_ID());
                mProductPO.setVendorProductNo(this.getSKU());
                mProductPO.setOrder_Pack(new BigDecimal(this.getUnitsPerPack()));
            } else {
                mProductPO.setVendorProductNo(this.getSKU());
                mProductPO.setOrder_Pack(new BigDecimal(this.getUnitsPerPack()));
            }
            Trx trx = Trx.get(this.get_TrxName(), true);
            trx.commit();
            mProductPO.saveEx();
        }
        if (!(UpdateProductPriceForGroup = MSysConfig.getValue("SOGEXIS_SAE_PRODUCT_SYNCHRONIZE", "N", MClient.get(Env.getCtx()).get_ID())).equals("Y")) return success;
        if (this.getGroup1() == null) return success;
        if (this.getGroup1().isEmpty()) return success;
        if (!newRecord) {
            Trx trx = Trx.get("Synchro", true);
            String sqlUpdate = "UPDATE M_Product SET group1 = upper(group1), M_Product_Category_ID = " + this.getM_Product_Category_ID() + ", UnitsPerPallet = " + this.getUnitsPerPallet() + ", M_Locator_ID = " + this.getM_Locator_ID() + ", Z_Picking_Priority = " + this.get_Value("Z_Picking_Priority") + ", ProductType = '" + this.getProductType() + "'" + " WHERE M_Product_ID <> " + this.getM_Product_ID() + " AND upper(group1) = '" + this.getGroup1().toUpperCase() + "'";
            DB.executeUpdate(sqlUpdate, trx.getTrxName());
            try {
                DB.commit(false, trx.getTrxName());
                return success;
            }
            catch (Exception e) {
                trx.rollback();
                return success;
            }
            finally {
                trx.close();
            }
        }
        String sqlProductMaster = "SELECT MIN(M_Product_ID) FROM M_Product WHERE M_Product_ID <> " + this.getM_Product_ID() + " AND upper(Group1) = '" + this.getGroup1().toUpperCase() + "'";
        Integer M_Product_ID = DB.getSQLValue(null, sqlProductMaster);
        try {
            DB.commit(false, this.get_TrxName());
        }
        catch (IllegalStateException e1) {
        }
        catch (SQLException e1) {
            // empty catch block
        }
        if (M_Product_ID == -1) return success;
        if (M_Product_ID == 0) return success;
        if (M_Product_ID == null) {
            return success;
        }
        String sqlProductPrice = "SELECT M_PriceList_Version_ID, M_Product_ID, PriceList, PriceStd, isActive FROM M_ProductPrice WHERE M_Product_ID = " + M_Product_ID;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Trx trx = Trx.get("ToCreate", true);
        pstmt = DB.prepareStatement(sqlProductPrice, null);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            MProductPrice mProductPrice2 = new MProductPrice(this.getCtx(), 0, trx.getTrxName());
            mProductPrice2.setM_Product_ID(this.getM_Product_ID());
            mProductPrice2.setM_PriceList_Version_ID(rs.getInt(1));
            mProductPrice2.setPriceLimit(Env.ZERO);
            mProductPrice2.setPriceList(rs.getBigDecimal(3));
            mProductPrice2.setPriceStd(rs.getBigDecimal(4));
            mProductPrice2.setIsActive(rs.getString(5).equals("Y"));
            String isSOList = DB.getSQLValueString(null, "SELECT issopricelist FROM M_PriceList WHERE M_PriceList_ID = (SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID = " + rs.getInt(1) + ")", new Object[0]);
            if (isSOList.equals("Y")) {
                String typeMargin = MSysConfig.getValue("SOGEXIS_TYPE_MARGE", "MT", MClient.get(Env.getCtx()).get_ID());
                if (typeMargin.equals("MT")) {
                    mProductPrice2.set_Value("Z_Marge", (Object)Env.ZERO);
                } else if (typeMargin.equals("MB")) {
                    mProductPrice2.set_Value("Z_Marge", (Object)Env.ONEHUNDRED);
                }
            }
            mProductPrice2.save();
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        try {
            DB.commit(false, trx.getTrxName());
        }
        catch (Exception e) {
            trx.rollback();
        }
        finally {
            trx.close();
        }
        catch (SQLException ex) {
            try {
                this.log.log(Level.SEVERE, sqlProductPrice, ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                try {
                    DB.commit(false, trx.getTrxName());
                    throw throwable;
                }
                catch (Exception e) {
                    trx.rollback();
                    throw throwable;
                }
                finally {
                    trx.close();
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            try {
                DB.commit(false, trx.getTrxName());
            }
            catch (Exception e) {
                trx.rollback();
            }
            finally {
                trx.close();
            }
        }
        String sqlProductPo = "SELECT C_BPartner_ID, Order_Min, Order_Pack, DeliveryTime_Promised, isActive FROM M_Product_PO WHERE M_Product_ID = " + M_Product_ID;
        trx = Trx.get("ToCreate", true);
        try {
            pstmt = DB.prepareStatement(sqlProductPo, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MProductPO mProductPO2 = new MProductPO(this.getCtx(), 0, trx.getTrxName());
                mProductPO2.setM_Product_ID(this.getM_Product_ID());
                mProductPO2.setC_BPartner_ID(rs.getInt(1));
                mProductPO2.setOrder_Min(rs.getBigDecimal(2));
                mProductPO2.setOrder_Pack(rs.getBigDecimal(3));
                mProductPO2.setDeliveryTime_Promised(rs.getInt(4));
                mProductPO2.setVendorProductNo(this.getValue());
                mProductPO2.setIsActive(rs.getString(5).equals("Y"));
                mProductPO2.save();
            }
            return success;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sqlProductPo, ex);
            return success;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            try {
                DB.commit(false, trx.getTrxName());
            }
            catch (Exception e) {
                trx.rollback();
            }
            finally {
                trx.close();
            }
        }
    }

    @Override
    protected boolean beforeDelete() {
        if ("R".equals(this.getProductType()) && this.getS_Resource_ID() > 0) {
            throw new AdempiereException("@S_Resource_ID@<>0");
        }
        if (this.isStocked() || "I".equals(this.getProductType())) {
            MStorage[] storages = MStorage.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
            BigDecimal OnHand = Env.ZERO;
            BigDecimal Ordered = Env.ZERO;
            BigDecimal Reserved = Env.ZERO;
            for (int i2 = 0; i2 < storages.length; ++i2) {
                OnHand = OnHand.add(storages[i2].getQtyOnHand());
                Ordered = OnHand.add(storages[i2].getQtyOrdered());
                Reserved = OnHand.add(storages[i2].getQtyReserved());
            }
            String errMsg = "";
            if (OnHand.signum() != 0) {
                errMsg = "@QtyOnHand@ = " + OnHand;
            }
            if (Ordered.signum() != 0) {
                errMsg = errMsg + " - @QtyOrdered@ = " + Ordered;
            }
            if (Reserved.signum() != 0) {
                errMsg = errMsg + " - @QtyReserved@" + Reserved;
            }
            if (errMsg.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), errMsg));
                return false;
            }
        }
        MProductCosting[] costings = MProductCosting.getOfProduct(this.getCtx(), this.get_ID(), this.get_TrxName());
        for (int i3 = 0; i3 < costings.length; ++i3) {
            costings[i3].delete(true, this.get_TrxName());
        }
        MCost.delete(this);
        String whereClause = "M_Product_ID=?";
        List conversions = new Query(this.getCtx(), "C_UOM_Conversion", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).setOnlyActiveRecords(false).list();
        for (MUOMConversion conversion : conversions) {
            conversion.deleteEx(true);
        }
        List downloads = new Query(this.getCtx(), "M_ProductDownload", "M_Product_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.get_ID()).setOnlyActiveRecords(false).list();
        for (MProductDownload download : downloads) {
            download.deleteEx(true);
        }
        return this.delete_Accounting("M_Product_Acct");
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("PR");
        }
        return success;
    }

    public MAttributeInstance getAttributeInstance(String name, String trxName) {
        MAttributeInstance instance = null;
        MTable table2 = MTable.get(Env.getCtx(), MAttribute.Table_ID);
        MAttribute attribute = (MAttribute)table2.getPO("Name = ?", new Object[]{name}, trxName);
        if (attribute == null) {
            return null;
        }
        table2 = MTable.get(Env.getCtx(), MAttributeInstance.Table_ID);
        instance = (MAttributeInstance)table2.getPO("M_AttributeSetInstance_ID=? and M_Attribute_ID=?", new Object[]{this.getM_AttributeSetInstance_ID(), attribute.getM_Attribute_ID()}, trxName);
        return instance;
    }

    public String getMMPolicy() {
        MProductCategory pc = MProductCategory.get(this.getCtx(), this.getM_Product_Category_ID());
        String MMPolicy = pc.getMMPolicy();
        if (MMPolicy == null || MMPolicy.length() == 0) {
            MMPolicy = MClient.get(this.getCtx()).getMMPolicy();
        }
        return MMPolicy;
    }

    public boolean isASIMandatory(boolean isSOTrx) {
        MAcctSchema[] mass;
        for (MAcctSchema as : mass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName())) {
            String cl = this.getCostingLevel(as);
            if (!"B".equals(cl)) continue;
            return true;
        }
        int M_AttributeSet_ID = this.getM_AttributeSet_ID();
        if (M_AttributeSet_ID != 0) {
            MAttributeSet mas = MAttributeSet.get(this.getCtx(), M_AttributeSet_ID);
            if (mas == null || !mas.isInstanceAttribute()) {
                return false;
            }
            if (isSOTrx) {
                return mas.isMandatory();
            }
            return mas.isMandatoryAlways();
        }
        return false;
    }

    public String getCostingLevel(MAcctSchema as) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), as.get_ID(), this.get_TrxName());
        String costingLevel = pca.getCostingLevel();
        if (costingLevel == null) {
            costingLevel = as.getCostingLevel();
        }
        return costingLevel;
    }

    public String getCostingMethod(MAcctSchema as) {
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), this.getM_Product_Category_ID(), as.get_ID(), this.get_TrxName());
        String costingMethod = pca.getCostingMethod();
        if (costingMethod == null) {
            costingMethod = as.getCostingMethod();
        }
        return costingMethod;
    }
}

