/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_R_MailText;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MMailText
extends X_R_MailText {
    private static final long serialVersionUID = -9121875595478208460L;
    private MUser m_user = null;
    private MBPartner m_bpartner = null;
    private PO m_po = null;
    private String m_MailHeader = null;
    private String m_MailText = null;
    private String m_MailText2 = null;
    private String m_MailText3 = null;
    private static CCache<String, MMailTextTrl> s_cacheTrl = new CCache("", 20);

    public MMailText(Properties ctx, int R_MailText_ID, String trxName) {
        super(ctx, R_MailText_ID, trxName);
    }

    public MMailText(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getMailText(boolean all) {
        if (this.m_MailText == null) {
            this.translate();
        }
        if (!all) {
            return this.parse(this.m_MailText);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_MailText);
        String s = this.m_MailText2;
        if (s != null && s.length() > 0) {
            sb.append("\n").append(s);
        }
        if ((s = this.m_MailText3) != null && s.length() > 0) {
            sb.append("\n").append(s);
        }
        return this.parse(sb.toString());
    }

    @Override
    public String getMailText() {
        if (this.m_MailText == null) {
            this.translate();
        }
        return this.parse(this.m_MailText);
    }

    @Override
    public String getMailText2() {
        if (this.m_MailText == null) {
            this.translate();
        }
        return this.parse(this.m_MailText2);
    }

    @Override
    public String getMailText3() {
        if (this.m_MailText == null) {
            this.translate();
        }
        return this.parse(this.m_MailText3);
    }

    @Override
    public String getMailHeader() {
        if (this.m_MailHeader == null) {
            this.translate();
        }
        return this.parse(this.m_MailHeader);
    }

    private String parse(String text) {
        if (text.indexOf(64) == -1) {
            return text;
        }
        text = this.parse(text, this.m_user);
        text = this.parse(text, this.m_bpartner);
        text = this.parse(text, this.m_po);
        return text;
    }

    private String parse(String text, PO po) {
        if (po == null || text.indexOf(64) == -1) {
            return text;
        }
        String inStr = text;
        StringBuffer outStr = new StringBuffer();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                inStr = "@" + inStr;
                break;
            }
            String token = inStr.substring(0, j);
            outStr.append(this.parseVariable(token, po));
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        return outStr.toString();
    }

    private String parseVariable(String variable, PO po) {
        int index = po.get_ColumnIndex(variable);
        if (index == -1) {
            return "@" + variable + "@";
        }
        Object value = po.get_Value(index);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public void setUser(int AD_User_ID) {
        this.m_user = MUser.get(this.getCtx(), AD_User_ID);
    }

    public void setUser(MUser user) {
        this.m_user = user;
    }

    public void setBPartner(int C_BPartner_ID) {
        this.m_bpartner = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
    }

    public void setBPartner(MBPartner bpartner) {
        this.m_bpartner = bpartner;
    }

    public void setPO(PO po) {
        this.m_po = po;
    }

    public void setPO(PO po, boolean analyse) {
        this.m_po = po;
        if (analyse) {
            Object oo;
            int index = po.get_ColumnIndex("C_BPartner_ID");
            if (index > 0 && (oo = po.get_Value(index)) instanceof Integer) {
                int C_BPartner_ID = (Integer)oo;
                this.setBPartner(C_BPartner_ID);
            }
            if ((index = po.get_ColumnIndex("AD_User_ID")) > 0 && (oo = po.get_Value(index)) instanceof Integer) {
                int AD_User_ID = (Integer)oo;
                this.setUser(AD_User_ID);
            }
        }
    }

    private void translate() {
        if (this.m_bpartner != null && this.m_bpartner.getAD_Language() != null) {
            String key = this.m_bpartner.getAD_Language() + this.get_ID();
            MMailTextTrl trl = s_cacheTrl.get(key);
            if (trl == null && (trl = this.getTranslation(this.m_bpartner.getAD_Language())) != null) {
                s_cacheTrl.put(key, trl);
            }
            if (trl != null) {
                this.m_MailHeader = trl.MailHeader;
                this.m_MailText = trl.MailText;
                this.m_MailText2 = trl.MailText2;
                this.m_MailText3 = trl.MailText3;
            }
        }
        this.m_MailHeader = super.getMailHeader();
        this.m_MailText = super.getMailText();
        this.m_MailText2 = super.getMailText2();
        this.m_MailText3 = super.getMailText3();
    }

    private MMailTextTrl getTranslation(String AD_Language) {
        MMailTextTrl trl = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM R_MailText_Trl WHERE R_MailText_ID=? AND AD_Language=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getR_MailText_ID());
            pstmt.setString(2, AD_Language);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                trl = new MMailTextTrl();
                trl.AD_Language = rs.getString("AD_Language");
                trl.MailHeader = rs.getString("MailHeader");
                trl.MailText = rs.getString("MailText");
                trl.MailText2 = rs.getString("MailText2");
                trl.MailText3 = rs.getString("MailText3");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return trl;
    }

    class MMailTextTrl {
        String AD_Language = null;
        String MailHeader = null;
        String MailText = null;
        String MailText2 = null;
        String MailText3 = null;

        MMailTextTrl() {
        }
    }
}

