/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner_Location;
import org.compiere.util.DB;

public class MBPartnerLocation
extends X_C_BPartner_Location {
    private static final long serialVersionUID = 1062151267747257338L;
    private MLocation m_location = null;
    private String m_uniqueName = null;
    private int m_unique = 0;

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID) {
        return MBPartnerLocation.getForBPartner(ctx, C_BPartner_ID, null);
    }

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List<MBPartnerLocation> list = new Query(ctx, "C_BPartner_Location", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        MBPartnerLocation[] retValue = new MBPartnerLocation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBPartnerLocation(Properties ctx, int C_BPartner_Location_ID, String trxName) {
        super(ctx, C_BPartner_Location_ID, trxName);
        if (C_BPartner_Location_ID == 0) {
            this.setName(".");
            this.setIsShipTo(true);
            this.setIsRemitTo(true);
            this.setIsPayFrom(true);
            this.setIsBillTo(true);
        }
    }

    public MBPartnerLocation(MBPartner bp) {
        this(bp.getCtx(), 0, bp.get_TrxName());
        this.setClientOrg(bp);
        this.set_ValueNoCheck("C_BPartner_ID", new Integer(bp.getC_BPartner_ID()));
    }

    public MBPartnerLocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLocation getLocation(boolean requery) {
        if (this.m_location == null) {
            this.m_location = MLocation.get(this.getCtx(), this.getC_Location_ID(), this.get_TrxName());
        }
        return this.m_location;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MBPartner_Location[ID=").append(this.get_ID()).append(",C_Location_ID=").append(this.getC_Location_ID()).append(",Name=").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MBPartnerLocation[] locations;
        boolean unique;
        if (this.getC_Location_ID() == 0) {
            return false;
        }
        if (!newRecord) {
            return true;
        }
        MLocation address = this.getLocation(true);
        this.m_uniqueName = this.getName();
        this.m_unique = MSysConfig.getIntValue("START_VALUE_BPLOCATION_NAME", 0, this.getAD_Client_ID(), this.getAD_Org_ID());
        if (this.m_unique < 0 || this.m_unique > 4) {
            this.m_unique = 0;
        }
        if (this.m_uniqueName != null && this.m_uniqueName.equals(".")) {
            this.m_uniqueName = null;
            this.makeUnique(address);
        }
        boolean bl = unique = (locations = MBPartnerLocation.getForBPartner(this.getCtx(), this.getC_BPartner_ID())).length == 0;
        block0: while (!unique) {
            unique = true;
            for (int i2 = 0; i2 < locations.length; ++i2) {
                MBPartnerLocation location = locations[i2];
                if (location.getC_BPartner_Location_ID() == this.get_ID() || !this.m_uniqueName.equals(location.getName())) continue;
                ++this.m_unique;
                this.makeUnique(address);
                unique = false;
                continue block0;
            }
        }
        this.setName(this.m_uniqueName);
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (MUser.get(this.getCtx()).get_ID() == this.get_ValueAsInt("AD_User_ID")) {
            DB.executeUpdate("UPDATE C_BPartner_Location SET AD_User_ID = null WHERE C_BPartner_Location_ID = " + this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        int nbrUseInPlanning = new Query(this.getCtx(), "Z_Event", " C_BPartner_Location_ID = ? ", null).setOnlyActiveRecords(true).setClient_ID().setParameters(this.getC_BPartner_Location_ID()).count();
        if (nbrUseInPlanning != 0) {
            throw new AdempiereException("L'adresse est li\u00e9e \u00e0 un \u00e9v\u00e8nement du planning, vous ne pouvez supprimer l'adresse.");
        }
        return super.beforeDelete();
    }

    private void makeUnique(MLocation address) {
        String xx;
        this.m_uniqueName = "";
        if ((this.m_unique >= 0 || this.m_uniqueName.length() == 0) && (xx = address.getCity()) != null && xx.length() > 0) {
            this.m_uniqueName = xx;
        }
        if ((this.m_unique >= 1 || this.m_uniqueName.length() == 0) && (xx = address.getAddress1()) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = this.m_uniqueName + " ";
            }
            this.m_uniqueName = this.m_uniqueName + xx;
        }
        if ((this.m_unique >= 2 || this.m_uniqueName.length() == 0) && (xx = address.getAddress2()) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = this.m_uniqueName + " ";
            }
            this.m_uniqueName = this.m_uniqueName + xx;
        }
        if ((this.m_unique >= 3 || this.m_uniqueName.length() == 0) && (xx = address.getRegionName(true)) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = this.m_uniqueName + " ";
            }
            this.m_uniqueName = this.m_uniqueName + xx;
        }
        if (this.m_unique >= 4 || this.m_uniqueName.length() == 0) {
            int id = this.get_ID();
            if (id == 0) {
                id = address.get_ID();
            }
            this.m_uniqueName = this.m_uniqueName + "#" + id;
        }
    }
}

