/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MElementValue;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MSalesRegion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Activity;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_Location;
import org.compiere.model.X_C_Project;
import org.compiere.model.X_C_SalesRegion;
import org.compiere.model.X_C_SubAcct;
import org.compiere.model.X_C_ValidCombination;
import org.compiere.model.X_Fact_Acct;
import org.compiere.model.X_M_Product;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MAccount
extends X_C_ValidCombination {
    private static final long serialVersionUID = -1936396369349550834L;
    private static CLogger s_log = CLogger.getCLogger(MAccount.class);
    private MElementValue m_accountEV = null;

    public static MAccount get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int C_AcctSchema_ID, int Account_ID, int C_SubAcct_ID, int M_Product_ID, int C_BPartner_ID, int AD_OrgTrx_ID, int C_LocFrom_ID, int C_LocTo_ID, int C_SalesRegion_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int User1_ID, int User2_ID, int UserElement1_ID, int UserElement2_ID) {
        StringBuffer info = new StringBuffer();
        info.append("AD_Client_ID=").append(AD_Client_ID).append(",AD_Org_ID=").append(AD_Org_ID);
        info.append(",C_AcctSchema_ID=").append(C_AcctSchema_ID);
        info.append(",Account_ID=").append(Account_ID).append(" ");
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=? AND AD_Org_ID=? AND C_AcctSchema_ID=? AND Account_ID=?");
        params.add(AD_Client_ID);
        params.add(AD_Org_ID);
        params.add(C_AcctSchema_ID);
        params.add(Account_ID);
        if (C_SubAcct_ID == 0) {
            whereClause.append(" AND C_SubAcct_ID IS NULL");
        } else {
            whereClause.append(" AND C_SubAcct_ID=?");
            params.add(C_SubAcct_ID);
        }
        if (M_Product_ID == 0) {
            whereClause.append(" AND M_Product_ID IS NULL");
        } else {
            whereClause.append(" AND M_Product_ID=?");
            params.add(M_Product_ID);
        }
        if (C_BPartner_ID == 0) {
            whereClause.append(" AND C_BPartner_ID IS NULL");
        } else {
            whereClause.append(" AND C_BPartner_ID=?");
            params.add(C_BPartner_ID);
        }
        if (AD_OrgTrx_ID == 0) {
            whereClause.append(" AND AD_OrgTrx_ID IS NULL");
        } else {
            whereClause.append(" AND AD_OrgTrx_ID=?");
            params.add(AD_OrgTrx_ID);
        }
        if (C_LocFrom_ID == 0) {
            whereClause.append(" AND C_LocFrom_ID IS NULL");
        } else {
            whereClause.append(" AND C_LocFrom_ID=?");
            params.add(C_LocFrom_ID);
        }
        if (C_LocTo_ID == 0) {
            whereClause.append(" AND C_LocTo_ID IS NULL");
        } else {
            whereClause.append(" AND C_LocTo_ID=?");
            params.add(C_LocTo_ID);
        }
        if (C_SalesRegion_ID == 0) {
            whereClause.append(" AND C_SalesRegion_ID IS NULL");
        } else {
            whereClause.append(" AND C_SalesRegion_ID=?");
            params.add(C_SalesRegion_ID);
        }
        if (C_Project_ID == 0) {
            whereClause.append(" AND C_Project_ID IS NULL");
        } else {
            whereClause.append(" AND C_Project_ID=?");
            params.add(C_Project_ID);
        }
        if (C_Campaign_ID == 0) {
            whereClause.append(" AND C_Campaign_ID IS NULL");
        } else {
            whereClause.append(" AND C_Campaign_ID=?");
            params.add(C_Campaign_ID);
        }
        if (C_Activity_ID == 0) {
            whereClause.append(" AND C_Activity_ID IS NULL");
        } else {
            whereClause.append(" AND C_Activity_ID=?");
            params.add(C_Activity_ID);
        }
        if (User1_ID == 0) {
            whereClause.append(" AND User1_ID IS NULL");
        } else {
            whereClause.append(" AND User1_ID=?");
            params.add(User1_ID);
        }
        if (User2_ID == 0) {
            whereClause.append(" AND User2_ID IS NULL");
        } else {
            whereClause.append(" AND User2_ID=?");
            params.add(User2_ID);
        }
        if (UserElement1_ID == 0) {
            whereClause.append(" AND UserElement1_ID IS NULL");
        } else {
            whereClause.append(" AND UserElement1_ID=?");
            params.add(UserElement1_ID);
        }
        if (UserElement2_ID == 0) {
            whereClause.append(" AND UserElement2_ID IS NULL");
        } else {
            whereClause.append(" AND UserElement2_ID=?");
            params.add(UserElement2_ID);
        }
        MAccount existingAccount = (MAccount)new Query(ctx, "C_ValidCombination", whereClause.toString(), null).setParameters(params).setOnlyActiveRecords(true).firstOnly();
        if (existingAccount != null) {
            return existingAccount;
        }
        MAccount newAccount = new MAccount(ctx, 0, null);
        newAccount.setClientOrg(AD_Client_ID, AD_Org_ID);
        newAccount.setC_AcctSchema_ID(C_AcctSchema_ID);
        newAccount.setAccount_ID(Account_ID);
        newAccount.setC_SubAcct_ID(C_SubAcct_ID);
        newAccount.setM_Product_ID(M_Product_ID);
        newAccount.setC_BPartner_ID(C_BPartner_ID);
        newAccount.setAD_OrgTrx_ID(AD_OrgTrx_ID);
        newAccount.setC_LocFrom_ID(C_LocFrom_ID);
        newAccount.setC_LocTo_ID(C_LocTo_ID);
        newAccount.setC_SalesRegion_ID(C_SalesRegion_ID);
        newAccount.setC_Project_ID(C_Project_ID);
        newAccount.setC_Campaign_ID(C_Campaign_ID);
        newAccount.setC_Activity_ID(C_Activity_ID);
        newAccount.setUser1_ID(User1_ID);
        newAccount.setUser2_ID(User2_ID);
        newAccount.setUserElement1_ID(UserElement1_ID);
        newAccount.setUserElement2_ID(UserElement2_ID);
        if (!newAccount.save()) {
            s_log.log(Level.SEVERE, "Could not create new account - " + info);
            return null;
        }
        s_log.fine("New: " + newAccount);
        return newAccount;
    }

    public static MAccount get(Properties ctx, int C_AcctSchema_ID, String alias) {
        String whereClause = "C_AcctSchema_ID=? AND Alias=?";
        MAccount retValue = (MAccount)new Query(ctx, "C_ValidCombination", "C_AcctSchema_ID=? AND Alias=?", null).setParameters(C_AcctSchema_ID, alias).firstOnly();
        return retValue;
    }

    public static MAccount get(X_Fact_Acct fa) {
        MAccount acct = MAccount.get(fa.getCtx(), fa.getAD_Client_ID(), fa.getAD_Org_ID(), fa.getC_AcctSchema_ID(), fa.getAccount_ID(), fa.getC_SubAcct_ID(), fa.getM_Product_ID(), fa.getC_BPartner_ID(), fa.getAD_OrgTrx_ID(), fa.getC_LocFrom_ID(), fa.getC_LocTo_ID(), fa.getC_SalesRegion_ID(), fa.getC_Project_ID(), fa.getC_Campaign_ID(), fa.getC_Activity_ID(), fa.getUser1_ID(), fa.getUser2_ID(), fa.getUserElement1_ID(), fa.getUserElement2_ID());
        return acct;
    }

    public static MAccount getDefault(Properties ctx, int C_AcctSchema_ID, boolean optionalNull, String trxName) {
        MAcctSchema acctSchema = new MAcctSchema(ctx, C_AcctSchema_ID, trxName);
        return MAccount.getDefault(acctSchema, optionalNull);
    }

    public static MAccount getDefault(MAcctSchema acctSchema, boolean optionalNull) {
        MAccount vc = new MAccount(acctSchema);
        MAcctSchemaElement[] elements = acctSchema.getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            boolean setValue;
            MAcctSchemaElement ase = elements[i2];
            String elementType = ase.getElementType();
            int defaultValue = ase.getDefaultValue();
            boolean bl = setValue = ase.isMandatory() || !ase.isMandatory() && !optionalNull;
            if (elementType.equals("OO")) {
                vc.setAD_Org_ID(defaultValue);
                continue;
            }
            if (elementType.equals("AC")) {
                vc.setAccount_ID(defaultValue);
                continue;
            }
            if (elementType.equals("SA") && setValue) {
                vc.setC_SubAcct_ID(defaultValue);
                continue;
            }
            if (elementType.equals("BP") && setValue) {
                vc.setC_BPartner_ID(defaultValue);
                continue;
            }
            if (elementType.equals("PR") && setValue) {
                vc.setM_Product_ID(defaultValue);
                continue;
            }
            if (elementType.equals("AY") && setValue) {
                vc.setC_Activity_ID(defaultValue);
                continue;
            }
            if (elementType.equals("LF") && setValue) {
                vc.setC_LocFrom_ID(defaultValue);
                continue;
            }
            if (elementType.equals("LT") && setValue) {
                vc.setC_LocTo_ID(defaultValue);
                continue;
            }
            if (elementType.equals("MC") && setValue) {
                vc.setC_Campaign_ID(defaultValue);
                continue;
            }
            if (elementType.equals("OT") && setValue) {
                vc.setAD_OrgTrx_ID(defaultValue);
                continue;
            }
            if (elementType.equals("PJ") && setValue) {
                vc.setC_Project_ID(defaultValue);
                continue;
            }
            if (elementType.equals("SR") && setValue) {
                vc.setC_SalesRegion_ID(defaultValue);
                continue;
            }
            if (elementType.equals("U1") && setValue) {
                vc.setUser1_ID(defaultValue);
                continue;
            }
            if (elementType.equals("U2") && setValue) {
                vc.setUser2_ID(defaultValue);
                continue;
            }
            if (elementType.equals("X1") && setValue) {
                vc.setUserElement1_ID(defaultValue);
                continue;
            }
            if (!elementType.equals("X2") || !setValue) continue;
            vc.setUserElement2_ID(defaultValue);
        }
        s_log.fine("Client_ID=" + vc.getAD_Client_ID() + ", Org_ID=" + vc.getAD_Org_ID() + " - AcctSchema_ID=" + vc.getC_AcctSchema_ID() + ", Account_ID=" + vc.getAccount_ID());
        return vc;
    }

    public static MAccount get(Properties ctx, int C_ValidCombination_ID) {
        return new MAccount(ctx, C_ValidCombination_ID, null);
    }

    public static void updateValueDescription(Properties ctx, String where, String trxName) {
        List accounts = new Query(ctx, "C_ValidCombination", where, trxName).setOrderBy("C_ValidCombination_ID").list();
        for (MAccount account : accounts) {
            account.setValueDescription();
            account.saveEx();
        }
    }

    public MAccount(Properties ctx, int C_ValidCombination_ID, String trxName) {
        super(ctx, C_ValidCombination_ID, trxName);
        if (C_ValidCombination_ID == 0) {
            this.setIsFullyQualified(false);
        }
    }

    public MAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAccount(MAcctSchema as) {
        this(as.getCtx(), 0, as.get_TrxName());
        this.setClientOrg(as);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAccount=[");
        sb.append(this.getC_ValidCombination_ID());
        if (this.getCombination() != null) {
            sb.append(",").append(this.getCombination());
        } else {
            sb.append(",Schema=").append(this.getC_AcctSchema_ID()).append(",Org=").append(this.getAD_Org_ID()).append(",Acct=").append(this.getAccount_ID()).append(" ");
            if (this.getC_SubAcct_ID() != 0) {
                sb.append(",C_SubAcct_ID=").append(this.getC_SubAcct_ID());
            }
            if (this.getM_Product_ID() != 0) {
                sb.append(",M_Product_ID=").append(this.getM_Product_ID());
            }
            if (this.getC_BPartner_ID() != 0) {
                sb.append(",C_BPartner_ID=").append(this.getC_BPartner_ID());
            }
            if (this.getAD_OrgTrx_ID() != 0) {
                sb.append(",AD_OrgTrx_ID=").append(this.getAD_OrgTrx_ID());
            }
            if (this.getC_LocFrom_ID() != 0) {
                sb.append(",C_LocFrom_ID=").append(this.getC_LocFrom_ID());
            }
            if (this.getC_LocTo_ID() != 0) {
                sb.append(",C_LocTo_ID=").append(this.getC_LocTo_ID());
            }
            if (this.getC_SalesRegion_ID() != 0) {
                sb.append(",C_SalesRegion_ID=").append(this.getC_SalesRegion_ID());
            }
            if (this.getC_Project_ID() != 0) {
                sb.append(",C_Project_ID=").append(this.getC_Project_ID());
            }
            if (this.getC_Campaign_ID() != 0) {
                sb.append(",C_Campaign_ID=").append(this.getC_Campaign_ID());
            }
            if (this.getC_Activity_ID() != 0) {
                sb.append(",C_Activity_ID=").append(this.getC_Activity_ID());
            }
            if (this.getUser1_ID() != 0) {
                sb.append(",User1_ID=").append(this.getUser1_ID());
            }
            if (this.getUser2_ID() != 0) {
                sb.append(",User2_ID=").append(this.getUser2_ID());
            }
            if (this.getUserElement1_ID() != 0) {
                sb.append(",UserElement1_ID=").append(this.getUserElement1_ID());
            }
            if (this.getUserElement2_ID() != 0) {
                sb.append(",UserElement2_ID=").append(this.getUserElement2_ID());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setAccount_ID(int Account_ID) {
        this.m_accountEV = null;
        super.setAccount_ID(Account_ID);
    }

    @Override
    public MElementValue getAccount() {
        if (this.m_accountEV == null && this.getAccount_ID() != 0) {
            this.m_accountEV = new MElementValue(this.getCtx(), this.getAccount_ID(), this.get_TrxName());
        }
        return this.m_accountEV;
    }

    public String getAccountType() {
        if (this.m_accountEV == null) {
            this.getAccount();
        }
        if (this.m_accountEV == null) {
            this.log.log(Level.SEVERE, "No ElementValue for Account_ID=" + this.getAccount_ID());
            return "";
        }
        return this.m_accountEV.getAccountType();
    }

    public boolean isBalanceSheet() {
        String accountType = this.getAccountType();
        return "A".equals(accountType) || "L".equals(accountType) || "O".equals(accountType);
    }

    public boolean isActiva() {
        return "A".equals(this.getAccountType());
    }

    public boolean isPassiva() {
        String accountType = this.getAccountType();
        return "L".equals(accountType) || "O".equals(accountType);
    }

    public void setValueDescription() {
        StringBuffer combi = new StringBuffer();
        StringBuffer descr = new StringBuffer();
        boolean fullyQualified = true;
        MAcctSchema as = new MAcctSchema(this.getCtx(), this.getC_AcctSchema_ID(), this.get_TrxName());
        MAcctSchemaElement[] elements = MAcctSchemaElement.getAcctSchemaElements(as);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            MElementValue ev;
            PO loc;
            MOrg org;
            if (i2 > 0) {
                combi.append(as.getSeparator());
                descr.append(as.getSeparator());
            }
            MAcctSchemaElement element = elements[i2];
            String combiStr = "_";
            String descrStr = "_";
            if ("OO".equals(element.getElementType())) {
                if (this.getAD_Org_ID() != 0) {
                    org = new MOrg(this.getCtx(), this.getAD_Org_ID(), this.get_TrxName());
                    combiStr = org.getValue();
                    descrStr = org.getName();
                } else {
                    combiStr = "*";
                    descrStr = "*";
                    fullyQualified = false;
                }
            } else if ("AC".equals(element.getElementType())) {
                if (this.getAccount_ID() != 0) {
                    if (this.m_accountEV == null) {
                        this.m_accountEV = new MElementValue(this.getCtx(), this.getAccount_ID(), this.get_TrxName());
                    }
                    combiStr = this.m_accountEV.getValue();
                    descrStr = this.m_accountEV.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Account");
                    fullyQualified = false;
                }
            } else if ("SA".equals(element.getElementType())) {
                if (this.getC_SubAcct_ID() != 0) {
                    X_C_SubAcct sa = new X_C_SubAcct(this.getCtx(), this.getC_SubAcct_ID(), this.get_TrxName());
                    combiStr = sa.getValue();
                    descrStr = sa.getName();
                }
            } else if ("PR".equals(element.getElementType())) {
                if (this.getM_Product_ID() != 0) {
                    X_M_Product product = new X_M_Product(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
                    combiStr = product.getValue();
                    descrStr = product.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Product");
                    fullyQualified = false;
                }
            } else if ("BP".equals(element.getElementType())) {
                if (this.getC_BPartner_ID() != 0) {
                    X_C_BPartner partner = new X_C_BPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
                    combiStr = partner.getValue();
                    descrStr = partner.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Business Partner");
                    fullyQualified = false;
                }
            } else if ("OT".equals(element.getElementType())) {
                if (this.getAD_OrgTrx_ID() != 0) {
                    org = new MOrg(this.getCtx(), this.getAD_OrgTrx_ID(), this.get_TrxName());
                    combiStr = org.getValue();
                    descrStr = org.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Trx Org");
                    fullyQualified = false;
                }
            } else if ("LF".equals(element.getElementType())) {
                if (this.getC_LocFrom_ID() != 0) {
                    loc = new MLocation(this.getCtx(), this.getC_LocFrom_ID(), this.get_TrxName());
                    combiStr = ((X_C_Location)loc).getPostal();
                    descrStr = ((X_C_Location)loc).getCity();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Location From");
                    fullyQualified = false;
                }
            } else if ("LT".equals(element.getElementType())) {
                if (this.getC_LocTo_ID() != 0) {
                    loc = new MLocation(this.getCtx(), this.getC_LocFrom_ID(), this.get_TrxName());
                    combiStr = ((X_C_Location)loc).getPostal();
                    descrStr = ((X_C_Location)loc).getCity();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Location To");
                    fullyQualified = false;
                }
            } else if ("SR".equals(element.getElementType())) {
                if (this.getC_SalesRegion_ID() != 0) {
                    loc = new MSalesRegion(this.getCtx(), this.getC_SalesRegion_ID(), this.get_TrxName());
                    combiStr = ((X_C_SalesRegion)loc).getValue();
                    descrStr = ((X_C_SalesRegion)loc).getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: SalesRegion");
                    fullyQualified = false;
                }
            } else if ("PJ".equals(element.getElementType())) {
                if (this.getC_Project_ID() != 0) {
                    X_C_Project project = new X_C_Project(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
                    combiStr = project.getValue();
                    descrStr = project.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Project");
                    fullyQualified = false;
                }
            } else if ("MC".equals(element.getElementType())) {
                if (this.getC_Campaign_ID() != 0) {
                    X_C_Campaign campaign = new X_C_Campaign(this.getCtx(), this.getC_Campaign_ID(), this.get_TrxName());
                    combiStr = campaign.getValue();
                    descrStr = campaign.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Campaign");
                    fullyQualified = false;
                }
            } else if ("AY".equals(element.getElementType())) {
                if (this.getC_Activity_ID() != 0) {
                    X_C_Activity act = new X_C_Activity(this.getCtx(), this.getC_Activity_ID(), this.get_TrxName());
                    combiStr = act.getValue();
                    descrStr = act.getName();
                } else if (element.isMandatory()) {
                    this.log.warning("Mandatory Element missing: Campaign");
                    fullyQualified = false;
                }
            } else if ("U1".equals(element.getElementType())) {
                if (this.getUser1_ID() != 0) {
                    ev = new MElementValue(this.getCtx(), this.getUser1_ID(), this.get_TrxName());
                    combiStr = ev.getValue();
                    descrStr = ev.getName();
                }
            } else if ("U2".equals(element.getElementType())) {
                if (this.getUser2_ID() != 0) {
                    ev = new MElementValue(this.getCtx(), this.getUser2_ID(), this.get_TrxName());
                    combiStr = ev.getValue();
                    descrStr = ev.getName();
                }
            } else if ("X1".equals(element.getElementType()) ? this.getUserElement1_ID() != 0 : !"X2".equals(element.getElementType()) || this.getUserElement2_ID() != 0) {
                // empty if block
            }
            combi.append(combiStr);
            descr.append(descrStr);
        }
        super.setCombination(combi.toString());
        super.setDescription(descr.toString());
        if (fullyQualified != this.isFullyQualified()) {
            this.setIsFullyQualified(fullyQualified);
        }
        this.log.fine("Combination=" + this.getCombination() + " - " + this.getDescription() + " - FullyQualified=" + fullyQualified);
    }

    public boolean validate() {
        X_C_SubAcct sa;
        boolean ok = true;
        if (this.getC_SubAcct_ID() != 0 && (sa = new X_C_SubAcct(this.getCtx(), this.getC_SubAcct_ID(), this.get_TrxName())).getC_ElementValue_ID() != this.getAccount_ID()) {
            this.log.saveError("Error", "C_SubAcct.C_ElementValue_ID=" + sa.getC_ElementValue_ID() + "<>Account_ID=" + this.getAccount_ID());
            ok = false;
        }
        return ok;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setValueDescription();
        return this.validate();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        MAccount acct = MAccount.get(Env.getCtx(), 11, 11, 101, 600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        MAccount acct2 = MAccount.get(Env.getCtx(), 11, 12, 101, 600, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
    }
}

