/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutProduct
extends CalloutEngine {
    public String calculGenCode(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        String currentCode = mTab.get_ValueAsString("UPC");
        if (currentCode == null) {
            return "";
        }
        if (currentCode.length() != 12) {
            return "";
        }
        currentCode = currentCode.substring(0, 12);
        ArrayList<String> even = new ArrayList<String>();
        ArrayList<String> odd = new ArrayList<String>();
        for (int i = 0; i < 12; ++i) {
            if (i % 2 == 1) {
                even.add("" + currentCode.charAt(i));
                continue;
            }
            if (i % 2 != 0) continue;
            odd.add("" + currentCode.charAt(i));
        }
        int totalPair = 0;
        int totalImpair = 0;
        for (String string : even) {
            totalPair += Integer.parseInt(string);
        }
        for (String string : odd) {
            totalImpair += Integer.parseInt(string);
        }
        int lastChiffre = 0;
        int tmpResult = totalImpair + (totalPair *= 3);
        lastChiffre = tmpResult - tmpResult / 10 * 10;
        if (10 - lastChiffre == 10) {
            mTab.setValue("UPC", (Object)(currentCode + "0"));
        } else {
            mTab.setValue("UPC", (Object)(currentCode + (10 - lastChiffre)));
        }
        return "";
    }

    public String genCode(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value != null && mTab.getValue("M_Product_ID") != null) {
            return "";
        }
        String lastUPCString = DB.getSQLValueString(null, "SELECT MAX(substring(upc,0,13)) FROM M_Product WHERE UPC LIKE '37478%'", new Object[0]);
        if (lastUPCString == null) {
            return "";
        }
        BigDecimal lastUPC = new BigDecimal(lastUPCString);
        lastUPC = lastUPC.subtract(new BigDecimal("374780000000"));
        mTab.setValue("UPC", (Object)("37478" + lastUPC.add(Env.ONE)));
        String currentCode = mTab.get_ValueAsString("UPC");
        if (currentCode == null) {
            return "";
        }
        if (currentCode.length() != 12) {
            return "";
        }
        currentCode = currentCode.substring(0, 12);
        ArrayList<String> even = new ArrayList<String>();
        ArrayList<String> odd = new ArrayList<String>();
        for (int i = 0; i < 12; ++i) {
            if (i % 2 == 1) {
                even.add("" + currentCode.charAt(i));
                continue;
            }
            if (i % 2 != 0) continue;
            odd.add("" + currentCode.charAt(i));
        }
        int totalPair = 0;
        int totalImpair = 0;
        for (String string : even) {
            totalPair += Integer.parseInt(string);
        }
        for (String string : odd) {
            totalImpair += Integer.parseInt(string);
        }
        int lastChiffre = 0;
        int tmpResult = totalImpair + (totalPair *= 3);
        lastChiffre = tmpResult - tmpResult / 10 * 10;
        if (10 - lastChiffre == 10) {
            mTab.setValue("UPC", (Object)(currentCode + "0"));
        } else {
            mTab.setValue("UPC", (Object)(currentCode + (10 - lastChiffre)));
        }
        return "";
    }

    public String synProduct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        String group1 = (String)value;
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        Integer M_Product_ID_Parent = DB.getSQLValue(null, "SELECT MIN(M_Product_ID) FROM M_Product WHERE created = (SELECT MIN(Created) FROM M_Product WHERE upper(Group1) = '" + group1.toUpperCase() + "') AND GROUP1 IS NOT NULL");
        if (M_Product_ID_Parent == null || M_Product_ID_Parent == 0 || M_Product_ID_Parent == -1) {
            return "";
        }
        if (M_Product_ID_Parent != M_Product_ID) {
            mTab.setValue("group1", (Object)group1.toUpperCase());
            mTab.setValue("M_Product_Category_ID", (Object)DB.getSQLValue(null, "SELECT M_Product_Category_ID FROM M_Product WHERE M_Product_ID = " + M_Product_ID_Parent));
            mTab.setValue("unitsPerPallet", (Object)DB.getSQLValueBD(null, "SELECT unitsPerPallet FROM M_Product WHERE M_Product_ID = " + M_Product_ID_Parent, new Object[0]));
            mTab.setValue("M_Locator_ID", (Object)DB.getSQLValue(null, "SELECT M_Locator_ID FROM M_Product WHERE M_Product_ID = " + M_Product_ID_Parent));
            mTab.setValue("Z_Picking_Priority", (Object)DB.getSQLValue(null, "SELECT Z_Picking_Priority FROM M_Product WHERE M_Product_ID =" + M_Product_ID_Parent));
            mTab.setValue("ProductType", (Object)DB.getSQLValueString(null, "SELECT ProductType FROM M_Product WHERE M_Product_ID = " + M_Product_ID_Parent, new Object[0]));
        }
        return "";
    }
}

