/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MPromoLine;
import org.compiere.model.MRemiseSpeciale;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.model.X_C_UOM_Conversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.SogexisUtils;

public class CalloutOrder
extends CalloutEngine {
    private boolean steps = false;
    private boolean somidRemiseSpecial = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block35: {
            boolean newDocNo;
            Integer C_DocType_ID = (Integer)value;
            if (C_DocType_ID == null || C_DocType_ID == 0) {
                return "";
            }
            String oldDocNo = (String)mTab.getValue("DocumentNo");
            boolean bl = newDocNo = oldDocNo == null;
            if (!newDocNo && oldDocNo.startsWith("<") && oldDocNo.endsWith(">")) {
                newDocNo = true;
            }
            Integer oldC_DocType_ID = (Integer)mTab.getValue("C_DocType_ID");
            String sql = "SELECT d.DocSubTypeSO,d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext,s.CurrentNextSys,s.AD_Sequence_ID,d.IsSOTrx, s.StartNewYear, s.DateColumn FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
            pstmt = null;
            rs = null;
            try {
                int AD_Sequence_ID = 0;
                if (!newDocNo && oldC_DocType_ID != 0) {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, oldC_DocType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Sequence_ID = rs.getInt(7);
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                String DocSubTypeSO = "";
                boolean IsSOTrx = true;
                if (rs.next()) {
                    DocSubTypeSO = rs.getString(1);
                    if (DocSubTypeSO == null) {
                        DocSubTypeSO = "--";
                    }
                    Env.setContext(ctx, WindowNo, "OrderType", DocSubTypeSO);
                    if (!DocSubTypeSO.equals("SO")) {
                        mTab.setValue("IsDropShip", (Object)"N");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("DeliveryRule", (Object)"F");
                    } else if (DocSubTypeSO.equals("PR")) {
                        mTab.setValue("DeliveryRule", (Object)"R");
                    } else {
                        mTab.setValue("DeliveryRule", (Object)"A");
                    }
                    if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR") || DocSubTypeSO.equals("WI")) {
                        mTab.setValue("InvoiceRule", (Object)"I");
                    } else {
                        mTab.setValue("InvoiceRule", (Object)"D");
                    }
                    if (DocSubTypeSO.equals("WR")) {
                        mTab.setValue("PaymentRule", (Object)"B");
                    } else {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                    if ("N".equals(rs.getString(8))) {
                        IsSOTrx = false;
                    }
                    Env.setContext(ctx, WindowNo, "HasCharges", rs.getString(2));
                    if (rs.getString(4).equals("Y")) {
                        if (!newDocNo && AD_Sequence_ID != rs.getInt(7)) {
                            newDocNo = true;
                        }
                        if (newDocNo) {
                            if (Ini.isPropertyBool("AdempiereSys") && Env.getAD_Client_ID(Env.getCtx()) < 1000000) {
                                mTab.setValue("DocumentNo", (Object)("<" + rs.getString(6) + ">"));
                            } else if ("Y".equals(rs.getString(9))) {
                                String dateColumn = rs.getString(10);
                                mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear(mTab, rs.getInt(7), dateColumn, null) + ">"));
                            } else {
                                mTab.setValue("DocumentNo", (Object)("<" + rs.getString(5) + ">"));
                            }
                        }
                    }
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                if (DocSubTypeSO.equals("WR") || DocSubTypeSO.equals("PR")) break block35;
                sql = "SELECT PaymentRule,C_PaymentTerm_ID,InvoiceRule,DeliveryRule,FreightCostRule,DeliveryViaRule, PaymentRulePO,PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?";
                pstmt = DB.prepareStatement(sql, null);
                int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block35;
                String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                if (s != null && s.length() != 0) {
                    if (IsSOTrx && (s.equals("B") || s.equals("S") || s.equals("U"))) {
                        s = "P";
                    }
                    if (!IsSOTrx && s.equals("B")) {
                        s = "P";
                    }
                    mTab.setValue("PaymentRule", (Object)s);
                }
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                }
                if ((s = rs.getString(3)) != null && s.length() != 0) {
                    mTab.setValue("InvoiceRule", (Object)s);
                }
                if ((s = rs.getString(4)) != null && s.length() != 0) {
                    mTab.setValue("DeliveryRule", (Object)s);
                }
                if ((s = rs.getString(5)) != null && s.length() != 0) {
                    mTab.setValue("FreightCostRule", (Object)s);
                }
                if ((s = rs.getString(6)) != null && s.length() != 0) {
                    mTab.setValue("DeliveryViaRule", (Object)s);
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block43: {
            Integer C_BPartner_ID = (Integer)value;
            if (C_BPartner_ID == null || C_BPartner_ID == 0) {
                return "";
            }
            String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,  ( SELECT MAX(AD_User_ID) FROM AD_User WHERE C_BPArtner_Id = p.C_BPartner_ID AND isActive='Y') AS AD_User_ID,  COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus,  p.SalesRep_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y')WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
            boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
            pstmt = null;
            rs = null;
            try {
                String s;
                String cont;
                String loc;
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block43;
                Integer salesRep = rs.getInt("SalesRep_ID");
                if (IsSOTrx && salesRep != 0) {
                    mTab.setValue("SalesRep_ID", (Object)salesRep);
                } else if (IsSOTrx && salesRep == 0) {
                    String loc2;
                    int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc2 = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                        shipTo_ID = Integer.parseInt(loc2);
                    }
                    if (shipTo_ID != 0 && SogexisUtils.columnExist("salesrep_ID", "C_BPartner_Location")) {
                        try {
                            salesRep = DB.getSQLValue(null, "SELECT MAX(salesrep_ID) FROM C_BPartner_Location WHERE C_BPartner_Location_ID = " + shipTo_ID);
                            if (salesRep != 0 && salesRep != -1) {
                                mTab.setValue("SalesRep_ID", (Object)salesRep);
                            }
                        }
                        catch (Exception e) {
                            System.out.println("La colonne salesrep_id n'existe pas sur C_BPartner_Location");
                        }
                    }
                }
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = Env.getContextAsInt(ctx, "#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                mTab.setValue("Bill_BPartner_ID", (Object)C_BPartner_ID);
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_Location_ID == 0) {
                    mTab.setValue("Bill_Location_ID", null);
                } else {
                    mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                }
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    shipTo_ID = Integer.parseInt(loc);
                }
                if (shipTo_ID == 0) {
                    mTab.setValue("C_BPartner_Location_ID", null);
                } else {
                    mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(shipTo_ID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                    mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx) {
                    double CreditLimit = rs.getDouble("SO_CreditLimit");
                    String SOCreditStatus = rs.getString("SOCreditStatus");
                    if (CreditLimit != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat(12).format(CreditAvailable), false);
                        }
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                }
                if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
                String OrderType = Env.getContext(ctx, WindowNo, "OrderType");
                mTab.setValue("InvoiceRule", (Object)"D");
                mTab.setValue("DeliveryRule", (Object)"A");
                mTab.setValue("PaymentRule", (Object)"P");
                if (OrderType.equals("PR")) {
                    mTab.setValue("InvoiceRule", (Object)"I");
                    mTab.setValue("DeliveryRule", (Object)"R");
                } else if (OrderType.equals("WR")) {
                    mTab.setValue("PaymentRule", (Object)"B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                    if ((s = rs.getString("DeliveryRule")) != null && s.length() != 0) {
                        mTab.setValue("DeliveryRule", (Object)s);
                    }
                    if ((s = rs.getString("FreightCostRule")) != null && s.length() != 0) {
                        mTab.setValue("FreightCostRule", (Object)s);
                    }
                    if ((s = rs.getString("DeliveryViaRule")) != null && s.length() != 0) {
                        mTab.setValue("DeliveryViaRule", (Object)s);
                    }
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, sql, e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String bPartnerBill(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block31: {
            if (this.isCalloutActive()) {
                return "";
            }
            Integer bill_BPartner_ID = (Integer)value;
            if (bill_BPartner_ID == null || bill_BPartner_ID == 0) {
                return "";
            }
            String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule,p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,c.AD_User_IDp.PO_PriceList_ID, p.PaymentRulePO, p.PO_PaymentTerm_ID,lbill.C_BPartner_Location_ID AS Bill_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
            boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
            pstmt = null;
            rs = null;
            try {
                String s;
                double CreditLimit;
                String cont;
                String loc;
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, bill_BPartner_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block31;
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    mTab.setValue("M_PriceList_ID", (Object)ii);
                } else {
                    int i = Env.getContextAsInt(ctx, "#M_PriceList_ID");
                    if (i != 0) {
                        mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                    }
                }
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    bill_Location_ID = Integer.parseInt(loc);
                }
                if (bill_Location_ID == 0) {
                    mTab.setValue("Bill_Location_ID", null);
                } else {
                    mTab.setValue("Bill_Location_ID", (Object)new Integer(bill_Location_ID));
                }
                int contID = rs.getInt("AD_User_ID");
                if (bill_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                if (contID == 0) {
                    mTab.setValue("Bill_User_ID", null);
                } else {
                    mTab.setValue("Bill_User_ID", (Object)new Integer(contID));
                }
                if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat(12).format(CreditAvailable), false);
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    mTab.setValue("POReference", (Object)s);
                } else {
                    mTab.setValue("POReference", null);
                }
                s = rs.getString("SO_Description");
                if (s != null && s.trim().length() != 0) {
                    mTab.setValue("Description", (Object)s);
                }
                if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                    mTab.setValue("IsDiscountPrinted", (Object)s);
                } else {
                    mTab.setValue("IsDiscountPrinted", (Object)"N");
                }
                String OrderType = Env.getContext(ctx, WindowNo, "OrderType");
                mTab.setValue("InvoiceRule", (Object)"D");
                mTab.setValue("PaymentRule", (Object)"P");
                if (OrderType.equals("PR")) {
                    mTab.setValue("InvoiceRule", (Object)"I");
                } else if (OrderType.equals("WR")) {
                    mTab.setValue("PaymentRule", (Object)"B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        mTab.setValue("InvoiceRule", (Object)s);
                    }
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, "bPartnerBill", e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String priceList(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_PriceList_ID = (Integer)mTab.getValue("M_PriceList_ID");
        if (M_PriceList_ID == null || M_PriceList_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            Timestamp date = new Timestamp(System.currentTimeMillis());
            if (mTab.getAD_Table_ID() == I_C_Order.Table_ID) {
                date = Env.getContextAsDate(ctx, WindowNo, "DateOrdered");
            } else if (mTab.getAD_Table_ID() == I_C_Invoice.Table_ID) {
                date = Env.getContextAsDate(ctx, WindowNo, "DateInvoiced");
            }
            pstmt.setTimestamp(2, date);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("IsTaxIncluded", (Object)new Boolean("Y".equals(rs.getString(1))));
                Env.setContext(ctx, WindowNo, "EnforcePriceLimit", rs.getString(2));
                Integer ii = new Integer(rs.getInt(3));
                mTab.setValue("C_Currency_ID", (Object)ii);
                Env.setContext(ctx, WindowNo, "M_PriceList_Version_ID", rs.getInt(5));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            String string = e.getLocalizedMessage();
            return string;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        mTab.setValue("C_Charge_ID", null);
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyOrdered");
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        Timestamp orderDate = (Timestamp)mTab.getValue("DateOrdered");
        int M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC", M_PriceList_ID, orderDate)) > 0) {
            Env.setContext(ctx, WindowNo, "M_PriceList_Version_ID", M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        pp.setPriceDate(orderDate);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("Discount", (Object)pp.getDiscount());
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        mTab.setValue("QtyOrdered", mTab.getValue("QtyEntered"));
        Env.setContext(ctx, WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        if (Env.isSOTrx(ctx, WindowNo)) {
            MProduct product = MProduct.get(ctx, M_Product_ID);
            String description = product.getDescription() == null ? "" : product.getDescription();
            String copyProductDescription = MSysConfig.getValue("SOGEXIS_COPY_DESCRIPTION", "Y", Env.getAD_Client_ID(ctx));
            if (copyProductDescription.equals("Y")) {
                mTab.setValue("description", (Object)description);
            }
            if (product.isStocked()) {
                BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
                int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
                int M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, "M_AttributeSetInstance_ID");
                BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, null);
                if (available == null) {
                    available = Env.ZERO;
                }
                if (available.signum() != 0 && available.compareTo(QtyOrdered) >= 0) {
                    BigDecimal total;
                    BigDecimal notReserved;
                    Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                    if (C_OrderLine_ID == null) {
                        C_OrderLine_ID = new Integer(0);
                    }
                    if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                        notReserved = Env.ZERO;
                    }
                    if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                        String info = Msg.parseTranslation(ctx, "@QtyAvailable@=" + available + " - @QtyNotReserved@=" + notReserved + " = " + total);
                    }
                }
            }
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        Env.setContext(ctx, WindowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_Charge_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                mTab.setValue("PriceLimit", (Object)Env.ZERO);
                mTab.setValue("PriceList", (Object)Env.ZERO);
                mTab.setValue("Discount", (Object)Env.ZERO);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                this.log.log(Level.SEVERE, sql, e);
                string = e.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = 0;
        shipC_BPartner_Location_ID = column.equals("C_BPartner_Location_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        Timestamp billDate = Env.getContextAsDate(ctx, WindowNo, "DateOrdered");
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = Env.getContextAsDate(ctx, WindowNo, "DatePromised");
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int billC_BPartner_Location_ID = Env.getContextAsInt(ctx, WindowNo, "Bill_Location_ID");
        if (billC_BPartner_Location_ID == 0) {
            billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        }
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        int C_Tax_ID = Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx")));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        if (this.steps) {
            this.log.warning("fini");
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        Timestamp date;
        int M_PriceList_Version_ID;
        MProductPricing pp;
        boolean IsSOTrx;
        int C_BPartner_ID;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (this.steps) {
            this.log.warning("init");
        }
        int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        int StdPrecision = MPriceList.getStandardPrecision(ctx, M_PriceList_ID);
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        this.log.fine("QtyEntered=" + QtyEntered + ", Ordered=" + QtyOrdered + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        if (M_Product_ID == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                PriceEntered = (BigDecimal)value;
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                PriceActual = (BigDecimal)value;
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("C_UOM_ID") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext(ctx, WindowNo, "DiscountSchema"))) {
            C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (QtyOrdered == null) {
                QtyOrdered = QtyEntered;
            }
            IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
            pp = new MProductPricing(M_Product_ID, C_BPartner_ID, QtyOrdered, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            date = (Timestamp)mTab.getValue("DateOrdered");
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            PriceActual = pp.getPriceStd();
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
            if (pp.isDiscountSchema() && mField.getColumnName().equals("M_Product_ID")) {
                mTab.setValue("Discount", (Object)pp.getDiscount());
            }
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = PriceEntered;
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        if (mField.getColumnName().equals("Discount")) {
            if (PriceList.doubleValue() != 0.0) {
                PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            }
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = PriceActual) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (this.somidRemiseSpecial) {
            if (PriceList.doubleValue() != 0.0) {
                PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            }
            if (PriceActual.scale() > StdPrecision) {
                PriceActual = PriceActual.setScale(StdPrecision, 4);
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else {
            Discount = PriceList.intValue() == 0 ? Env.ZERO : new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
            if (Discount.scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
            if (!"N".equals(Env.getContext(ctx, WindowNo, "DiscountSchema")) && mField.getColumnName().equals("M_Product_ID")) {
                C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
                IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
                pp = new MProductPricing(M_Product_ID, C_BPartner_ID, QtyOrdered, IsSOTrx);
                pp.setM_PriceList_ID(M_PriceList_ID);
                M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
                pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                date = (Timestamp)mTab.getValue("DateOrdered");
                pp.setPriceDate(date);
                pp.getPriceStd();
                Discount = pp.getDiscount();
            }
            if (!(mField.getColumnName().equals("QtyOrdered") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("C_UOM_ID") && !"N".equals(Env.getContext(ctx, WindowNo, "DiscountSchema")))) {
                mTab.setValue("Discount", (Object)Discount);
            }
        }
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
        String epl = Env.getContext(ctx, WindowNo, "EnforcePriceLimit");
        boolean bl = enforce = Env.isSOTrx(ctx, WindowNo) && epl != null && epl.equals("Y");
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.intValue() != 0) {
                Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                if (Discount.scale() > 2) {
                    Discount = Discount.setScale(2, 4);
                }
                mTab.setValue("Discount", (Object)Discount);
            }
        }
        if ((LineNetAmt = QtyOrdered.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MProduct product;
        int C_UOM_To_ID;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        if (this.steps) {
            this.log.warning("init - M_Product_ID=" + M_Product_ID + " - ");
        }
        BigDecimal QtyOrdered = Env.ZERO;
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered;
            QtyOrdered = QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyOrdered/PriceEntered=" + QtyOrdered + "/" + PriceEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyOrdered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyOrdered = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyOrdered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyOrdered=" + QtyOrdered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyOrdered", (Object)QtyOrdered);
        } else if (mField.getColumnName().equals("QtyOrdered")) {
            BigDecimal QtyEntered;
            C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            QtyOrdered = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyOrdered1 = QtyOrdered.setScale(precision, 4);
            if (QtyOrdered.compareTo(QtyOrdered1) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + QtyOrdered + "->" + QtyOrdered1);
                QtyOrdered = QtyOrdered1;
                mTab.setValue("QtyOrdered", (Object)QtyOrdered);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyOrdered)) == null) {
                QtyEntered = QtyOrdered;
            }
            boolean conversion = QtyOrdered.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyOrdered=" + QtyOrdered + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        } else {
            QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
        }
        if (M_Product_ID != 0 && Env.isSOTrx(ctx, WindowNo) && QtyOrdered.signum() > 0 && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            int M_AttributeSetInstance_ID;
            int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
            BigDecimal available = MStorage.getQtyAvailable(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, "M_AttributeSetInstance_ID"), null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() != 0 && available.compareTo(QtyOrdered) >= 0) {
                BigDecimal total;
                BigDecimal notReserved;
                Integer C_OrderLine_ID = (Integer)mTab.getValue("C_OrderLine_ID");
                if (C_OrderLine_ID == null) {
                    C_OrderLine_ID = new Integer(0);
                }
                if ((notReserved = MOrderLine.getNotReserved(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, C_OrderLine_ID)) == null) {
                    notReserved = Env.ZERO;
                }
                if ((total = available.subtract(notReserved)).compareTo(QtyOrdered) < 0) {
                    String info = Msg.parseTranslation(ctx, "@QtyAvailable@=" + available + "  -  @QtyNotReserved@=" + notReserved + "  =  " + total);
                }
            }
        }
        return "";
    }

    public String qtyCarton(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer C_UOM_ID = (Integer)mTab.getValue("C_UOM_ID");
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyEntered = null;
            Object tmpValue = mTab.getValue("QtyEntered");
            QtyEntered = tmpValue.getClass() == Integer.class ? new BigDecimal((Integer)mTab.getValue("QtyEntered")) : (BigDecimal)mTab.getValue("QtyEntered");
            if (M_Product_ID == null || C_UOM_ID == null) {
                return "";
            }
            MUOMConversion mUOMConversion = (MUOMConversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ? AND C_UOM_TO_ID = ? ", null).setClient_ID().setOnlyActiveRecords(true).setParameters(M_Product_ID, 1000003).first();
            if (C_UOM_ID == 1000003) {
                mTab.setValue("Z_QtyCarton", (Object)QtyEntered.intValue());
                if (mUOMConversion != null) {
                    QtyEntered = new BigDecimal(QtyEntered.intValue()).multiply(mUOMConversion.getDivideRate());
                    mTab.setValue("QtyOrdered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                } else {
                    mTab.setValue("QtyOrdered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                }
            } else {
                if (mUOMConversion == null) {
                    this.qty(ctx, WindowNo, mTab, mField, value);
                    return "";
                }
                BigDecimal tmp = QtyEntered.divide(mUOMConversion.getDivideRate(), 2, RoundingMode.HALF_UP);
                Integer QtyCarton = (int)Math.ceil(tmp.doubleValue());
                QtyEntered = new BigDecimal(QtyCarton).multiply(mUOMConversion.getDivideRate());
                mTab.setValue("Z_QtyCarton", (Object)QtyCarton);
                mTab.setValue("QtyEntered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                mTab.setValue("QtyOrdered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
            }
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            if (C_UOM_ID == 1000003) {
                MUOMConversion mUOMConversion = (MUOMConversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ? AND C_UOM_TO_ID = ? ", null).setClient_ID().setOnlyActiveRecords(true).setParameters(M_Product_ID, 1000003).first();
                if (mUOMConversion == null) {
                    return "";
                }
                BigDecimal QtyOrdered = new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")).multiply(mUOMConversion.getDivideRate());
                mTab.setValue("QtyEntered", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")));
                mTab.setValue("QtyOrdered", (Object)QtyOrdered.setScale(4, RoundingMode.HALF_UP));
                Env.setContext(ctx, WindowNo, "UOMConversion", "Y");
            } else {
                mTab.setValue("QtyEntered", (Object)((BigDecimal)mTab.getValue("QtyOrdered")));
                Env.setContext(ctx, WindowNo, "UOMConversion", "N");
            }
        }
        return "";
    }

    public String qtyPiece(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer C_UOM_ID = (Integer)mTab.getValue("C_UOM_ID");
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyEntered = null;
            Object tmpValue = mTab.getValue("QtyEntered");
            QtyEntered = tmpValue.getClass() == Integer.class ? new BigDecimal((Integer)mTab.getValue("QtyEntered")) : (BigDecimal)mTab.getValue("QtyEntered");
            if (M_Product_ID == null || C_UOM_ID == null) {
                return "";
            }
            MUOMConversion mUOMConversion = (MUOMConversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ? AND C_UOM_TO_ID = ? ", null).setClient_ID().setOnlyActiveRecords(true).setParameters(M_Product_ID, 100).first();
            if (C_UOM_ID == 100) {
                mTab.setValue("Z_QtyPiece", (Object)QtyEntered.intValue());
                if (mUOMConversion != null) {
                    QtyEntered = new BigDecimal(QtyEntered.intValue()).multiply(mUOMConversion.getDivideRate());
                    mTab.setValue("QtyOrdered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                } else {
                    mTab.setValue("QtyOrdered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                }
            } else {
                if (mUOMConversion == null) {
                    this.qty(ctx, WindowNo, mTab, mField, value);
                    return "";
                }
                BigDecimal tmp = QtyEntered.divide(mUOMConversion.getDivideRate(), 2, RoundingMode.HALF_UP);
                Integer QtyQtyPiece = (int)Math.ceil(tmp.doubleValue());
                QtyEntered = new BigDecimal(QtyQtyPiece).multiply(mUOMConversion.getDivideRate());
                mTab.setValue("Z_QtyPiece", (Object)QtyQtyPiece);
                mTab.setValue("QtyEntered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                mTab.setValue("QtyOrdered", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
            }
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            if (C_UOM_ID == 100) {
                MUOMConversion mUOMConversion = (MUOMConversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ? AND C_UOM_TO_ID = ? ", null).setClient_ID().setOnlyActiveRecords(true).setParameters(M_Product_ID, 100).first();
                if (mUOMConversion == null) {
                    return "";
                }
                BigDecimal QtyOrdered = new BigDecimal((Integer)mTab.getValue("Z_QtyPiece")).multiply(mUOMConversion.getDivideRate());
                mTab.setValue("QtyEntered", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyPiece")));
                mTab.setValue("QtyOrdered", (Object)QtyOrdered.setScale(4, RoundingMode.HALF_UP));
                Env.setContext(ctx, WindowNo, "UOMConversion", "Y");
            } else {
                mTab.setValue("QtyEntered", (Object)((BigDecimal)mTab.getValue("QtyOrdered")));
                Env.setContext(ctx, WindowNo, "UOMConversion", "N");
            }
        }
        return "";
    }

    public String setDefaultUnite(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean isSOTrx;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (mField.getGridTab().getField("Z_QtyPiece") != null) {
            mTab.setValue("Z_QtyPiece", (Object)0);
        } else if (mField.getGridTab().getField("Z_QtyCarton") != null) {
            mTab.setValue("Z_QtyCarton", (Object)0);
        }
        boolean bl = isSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        if (isSOTrx) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        X_C_UOM_Conversion C_UOM_ID = (X_C_UOM_Conversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ?", null).setOnlyActiveRecords(true).setParameters(M_Product_ID).first();
        if (C_UOM_ID == null) {
            return "";
        }
        if ((Integer)C_UOM_ID.get_Value("C_UOM_TO_ID") == -1 || (Integer)C_UOM_ID.get_Value("C_UOM_TO_ID") == 0) {
            return "";
        }
        mTab.setValue("C_UOM_ID", C_UOM_ID.get_Value("C_UOM_TO_ID"));
        mTab.setValue("QtyEntered", (Object)Env.ONE);
        mTab.setValue("QtyOrdered", (Object)Env.ONE.multiply(C_UOM_ID.getDivideRate()).setScale(4, RoundingMode.HALF_UP));
        if (mField.getGridTab().getField("Z_QtyPiece") != null) {
            mTab.setValue("Z_QtyPiece", (Object)1);
        } else if (mField.getGridTab().getField("Z_QtyCarton") != null) {
            mTab.setValue("Z_QtyCarton", (Object)1);
        }
        return "";
    }

    public String setDefaultUniteVente(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean isSOTrx;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        if (mField.getGridTab().getField("Z_QtyPiece") != null) {
            mTab.setValue("Z_QtyPiece", (Object)0);
        } else if (mField.getGridTab().getField("Z_QtyCarton") != null) {
            mTab.setValue("Z_QtyCarton", (Object)0);
        }
        boolean bl = isSOTrx = !Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        if (isSOTrx) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        X_C_UOM_Conversion C_UOM_ID = (X_C_UOM_Conversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ?", null).setOnlyActiveRecords(true).setParameters(M_Product_ID).first();
        if (C_UOM_ID == null) {
            return "";
        }
        if ((Integer)C_UOM_ID.get_Value("C_UOM_TO_ID") == -1 || (Integer)C_UOM_ID.get_Value("C_UOM_TO_ID") == 0) {
            return "";
        }
        mTab.setValue("C_UOM_ID", C_UOM_ID.get_Value("C_UOM_TO_ID"));
        mTab.setValue("QtyEntered", (Object)Env.ONE);
        mTab.setValue("QtyOrdered", (Object)Env.ONE.multiply(C_UOM_ID.getDivideRate()).setScale(4, RoundingMode.HALF_UP));
        if (mField.getGridTab().getField("Z_QtyPiece") != null) {
            mTab.setValue("Z_QtyPiece", (Object)1);
        } else if (mField.getGridTab().getField("Z_QtyCarton") != null) {
            mTab.setValue("Z_QtyCarton", (Object)1);
        }
        return "";
    }

    public String getDiscountPromo(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws SQLException {
        MBPartner mbPartner;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        MProduct mProduct = new MProduct(ctx, M_Product_ID, null);
        if (mProduct.get_Value("z_marque_id") == null || (Integer)mProduct.get_Value("z_marque_id") == 0) {
            return "";
        }
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        MOrder mOrder = new MOrder(ctx, C_Order_ID, null);
        MPromoLine mPromoLine = this.getPromoLine(mOrder, mbPartner = (MBPartner)mOrder.getC_BPartner(), mProduct, ctx);
        if (mPromoLine != null) {
            mTab.setValue("discount", (Object)mPromoLine.getZ_Remise());
            mTab.setValue("Z_PromoLine_ID", (Object)mPromoLine.get_ID());
            this.somidRemiseSpecial = true;
            this.amt(ctx, WindowNo, mTab, mField, value);
        }
        return "";
    }

    public String getDiscountRemiseSpecial(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        MProduct mProduct = new MProduct(ctx, M_Product_ID, null);
        if (mProduct.get_Value("z_marque_id") == null || (Integer)mProduct.get_Value("z_marque_id") == 0) {
            return "";
        }
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        MOrder mOrder = new MOrder(ctx, C_Order_ID, null);
        MBPartner mbPartner = new MBPartner(ctx, mOrder.getC_BPartner_ID(), null);
        if (mbPartner.get_Value("z_bp_sous_groupe_id") == null || (Integer)mbPartner.get_Value("z_bp_sous_groupe_id") == 0) {
            return "";
        }
        MPromoLine mPromoLine = this.getPromoLine(mOrder, mbPartner, mProduct, ctx);
        if (mPromoLine != null) {
            return "";
        }
        MRemiseSpeciale mRemiseSpeciale = (MRemiseSpeciale)new Query(ctx, "Z_Remise_Speciale", " Z_BP_Sous_Groupe_ID = ? AND Z_Marque_ID = ? ", null).setOnlyActiveRecords(true).setClient_ID().setParameters((Integer)mbPartner.get_Value("z_bp_sous_groupe_id"), (Integer)mProduct.get_Value("z_marque_id")).firstOnly();
        if (mRemiseSpeciale != null) {
            mTab.setValue("discount", (Object)mRemiseSpeciale.getDiscount());
            this.somidRemiseSpecial = true;
            this.amt(ctx, WindowNo, mTab, mField, value);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MPromoLine getPromoLine(MOrder mOrder, MBPartner mbPartner, MProduct mProduct, Properties ctx) {
        MPromoLine mPromoLine = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String SQL = "SELECT DISTINCT zpl.Z_Promo_ID,zp.z_debut, zp.z_prolongation  FROM Z_PromoLine zpl INNER JOIN Z_Promo zp ON zp.Z_Promo_ID = zpl.Z_Promo_ID INNER JOIN Z_Promo_BPartner zpbp ON (zpbp.Z_Promo_ID = zp.Z_Promo_ID AND zpbp.C_BPartner_ID = " + mbPartner.get_ID() + ")" + " WHERE zpl.Z_PromoLine_ID IN (SELECT Z_PromoLine_ID FROM C_OrderLine WHERE C_Order_ID = " + mOrder.get_ID() + ")" + " ORDER BY zp.z_debut";
        String listPromos = "(";
        try {
            pstmt = DB.prepareStatement(SQL, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (mOrder.getDateOrdered().before(rs.getTimestamp(2)) || mOrder.getDateOrdered().after(rs.getTimestamp(3))) continue;
                listPromos = listPromos + rs.getInt(1) + ",";
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, "Erreur : " + SQL, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        listPromos = listPromos.substring(0, listPromos.length() - 1);
        listPromos = listPromos + ")";
        if (listPromos.length() <= 5) {
            return null;
        }
        mPromoLine = (MPromoLine)new Query(ctx, "Z_PromoLine", " Z_Promo_ID IN " + listPromos + " AND M_Product_ID = ? ", null).setOnlyActiveRecords(true).setClient_ID().setParameters(mProduct.get_ID()).setOrderBy("Z_Promo_ID").first();
        return mPromoLine;
    }

    public String getHelpFromProduct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == 0) {
            return "";
        }
        MProduct mProduct = new MProduct(ctx, M_Product_ID, null);
        if (mProduct.getHelp() != null && !mProduct.getHelp().isEmpty()) {
            mTab.setValue("help", (Object)mProduct.getHelp());
        }
        return "";
    }

    public String quantityCollected(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        return "";
    }

    public String getElephantAlert(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        String isSotrx = DB.getSQLValueString(null, "SELECT isSotrx FROM C_Order WHERE C_Order_ID = ? ", C_Order_ID);
        if (isSotrx.equalsIgnoreCase("N")) {
            return "";
        }
        BigDecimal qtyEntered = (BigDecimal)mTab.getValue("qtyentered");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        MProduct mProduct = new MProduct(ctx, M_Product_ID, null);
        if (mProduct.get_Value("z_qtyextraordinary") != null && ((BigDecimal)mProduct.get_Value("z_qtyextraordinary")).compareTo(Env.ZERO) != 0 && ((BigDecimal)mProduct.get_Value("z_qtyextraordinary")).compareTo(qtyEntered) < 0) {
            mTab.fireDataStatusEEvent("<span style=\"color:red;font-weight:bold;\">Vous venez d'indiquer une quantit\u00e9 sup\u00e9rieure \u00e0 la quantit\u00e9 \u00e9l\u00e9phant de cet article. <br/>( Qt\u00e9 \u00e9l\u00e9phant : " + mProduct.get_Value("z_qtyextraordinary") + " )</span>", "", false);
        } else if (mProduct.get_Value("z_qtyextraordinary") != null && ((BigDecimal)mProduct.get_Value("z_qtyextraordinary")).compareTo(Env.ZERO) != 0 && ((BigDecimal)mProduct.get_Value("z_qtyextraordinary")).compareTo(qtyEntered) == 0) {
            mTab.fireDataStatusEEvent("<span style=\"color:orange;font-weight:bold;\">Vous venez d'indiquer une quantit\u00e9 \u00e9gale \u00e0 la quantit\u00e9 \u00e9l\u00e9phant de cet article. <br/>( Qt\u00e9 \u00e9l\u00e9phant : " + mProduct.get_Value("z_qtyextraordinary") + " )</span>", "", false);
        }
        return "";
    }

    public String setSalesRepID(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        if (!IsSOTrx) {
            return "";
        }
        if ((Integer)mTab.getValue("C_BPartner_ID") == 0) {
            return "";
        }
        int salesrep_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(salesrep_ID), 0) FROM C_BPartner WHERE C_BPartner_ID = " + mTab.getValue("C_BPartner_ID"));
        if (salesrep_ID != 0) {
            return "";
        }
        int C_BPartner_Location = (Integer)mTab.getValue("C_BPartner_Location_ID");
        if (C_BPartner_Location == 0) {
            return "";
        }
        salesrep_ID = DB.getSQLValue(null, "SELECT COALESCE(MAX(salesrep_ID), 0) FROM C_BPartner_Location WHERE C_BPartner_Location_ID = " + C_BPartner_Location);
        if (salesrep_ID != 0 && salesrep_ID != 1) {
            mTab.setValue("salesrep_id", (Object)salesrep_ID);
        }
        return "";
    }

    public String getPriceListFromProject(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        if (mTab.getValue("DocStatus").equals("CL") || mTab.getValue("DocStatus").equals("CO") || mTab.getValue("DocStatus").equals("VO")) {
            return "";
        }
        if (value == null) {
            mTab.setValue("M_PriceList_ID", null);
            return "";
        }
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        if (!IsSOTrx) {
            return "";
        }
        String sql = "SELECT M_PriceList_ID  FROM A_Asset WHERE C_Project_ID = " + value;
        int M_Pricelist_ID = DB.getSQLValue(null, sql);
        if (M_Pricelist_ID <= 0) {
            return "";
        }
        mTab.setValue("M_Pricelist_ID", (Object)M_Pricelist_ID);
        return "";
    }

    public String getBPLocationFromProject(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        if (mTab.getValue("DocStatus").equals("CL") || mTab.getValue("DocStatus").equals("CO") || mTab.getValue("DocStatus").equals("VO")) {
            return "";
        }
        if (value == null) {
            mTab.setValue("C_BPartner_Location_ID", null);
            return "";
        }
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        if (!IsSOTrx) {
            return "";
        }
        String sql = "SELECT C_BPartner_Location_ID  FROM A_Asset WHERE C_Project_ID = " + value;
        int C_BPartner_Location_ID = DB.getSQLValue(null, sql);
        if (C_BPartner_Location_ID <= 0) {
            return "";
        }
        mTab.setValue("C_BPartner_Location_ID", (Object)C_BPartner_Location_ID);
        return "";
    }

    public String checkLastInvoicedPrice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        if (IsSOTrx) {
            return "";
        }
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        MOrder mOrder = new MOrder(ctx, C_Order_ID, null);
        if (mOrder.get_Value("DocStatus").equals("CL") || mOrder.get_Value("DocStatus").equals("CO") || mOrder.get_Value("DocStatus").equals("VO")) {
            return "";
        }
        BigDecimal priceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID <= 0) {
            return "";
        }
        String sql = "SELECT COALESCE(priceLastPO, 0)  FROM M_Product_PO  WHERE M_Product_ID = " + M_Product_ID + " AND C_BPartner_ID = (SELECT C_BPartner_ID FROM C_Order WHERE C_Order_ID = " + C_Order_ID + ")";
        BigDecimal priceLastPO = DB.getSQLValueBD(null, sql, new Object[0]);
        if (priceLastPO == null) {
            return "";
        }
        if (priceLastPO.compareTo(Env.ZERO) != 0 && priceEntered.compareTo(priceLastPO) > 0) {
            mTab.fireDataStatusEEvent("Attention le prix d'achat entr\u00e9 est sup\u00e9rieur au dernier prix d'achat ( " + priceLastPO + " )", "", false);
        }
        return "";
    }
}

