/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.model.X_C_UOM_Conversion;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutMovement
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        this.setLocatorProduct(ctx, mTab, WindowNo, M_Product_ID, null);
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, null);
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, (BigDecimal)value);
        return "";
    }

    public String locator(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, null);
        return "";
    }

    private void checkQtyAvailable(Properties ctx, GridTab mTab, int WindowNo, int M_Product_ID, BigDecimal MovementQty) {
        MProduct product;
        if (M_Product_ID != 0 && (product = MProduct.get(ctx, M_Product_ID)).isStocked()) {
            int M_Locator_ID;
            if (MovementQty == null) {
                MovementQty = (BigDecimal)mTab.getValue("MovementQty");
            }
            if ((M_Locator_ID = Env.getContextAsInt(ctx, WindowNo, "M_Locator_ID")) <= 0) {
                return;
            }
            int M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, "M_AttributeSetInstance_ID");
            BigDecimal available = MStorage.getQtyAvailable(0, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, null);
            if (available == null) {
                available = Env.ZERO;
            }
            if (available.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (available.compareTo(MovementQty) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", available.toString(), false);
            }
        }
    }

    public String setQtyConvert(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        X_C_UOM_Conversion C_UOM_ID = (X_C_UOM_Conversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ?", null).setOnlyActiveRecords(true).setParameters(M_Product_ID).first();
        if (mField.getColumnName().equals("MovementQty")) {
            if (C_UOM_ID == null) {
                mTab.setValue("Z_QtyCarton", (Object)((BigDecimal)mTab.getValue("MovementQty")).intValue());
            } else {
                BigDecimal tmp = ((BigDecimal)mTab.getValue("MovementQty")).divide(C_UOM_ID.getDivideRate(), 2, RoundingMode.HALF_UP);
                Integer QtyConvert = (int)Math.ceil(tmp.doubleValue());
                BigDecimal QtyEntered = new BigDecimal(QtyConvert).multiply(C_UOM_ID.getDivideRate());
                mTab.setValue("Z_QtyCarton", (Object)QtyConvert);
                mTab.setValue("MovementQty", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
            }
        } else if (mField.getColumnName().equals("Z_QtyCarton")) {
            if (C_UOM_ID == null) {
                mTab.setValue("MovementQty", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")));
            } else {
                mTab.setValue("MovementQty", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")).multiply(C_UOM_ID.getDivideRate()).setScale(4, RoundingMode.HALF_UP));
            }
            this.checkQtyAvailable(ctx, mTab, WindowNo, M_Product_ID, new BigDecimal((Integer)value));
        }
        return "";
    }

    public String initConvert(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        X_C_UOM_Conversion C_UOM_ID = (X_C_UOM_Conversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ?", null).setOnlyActiveRecords(true).setParameters(M_Product_ID).first();
        if (C_UOM_ID == null) {
            mTab.setValue("Z_QtyCarton", (Object)((BigDecimal)mTab.getValue("MovementQty")).intValue());
        } else {
            BigDecimal tmp = ((BigDecimal)mTab.getValue("MovementQty")).divide(C_UOM_ID.getDivideRate(), 2, RoundingMode.HALF_UP);
            Integer QtyConvert = (int)Math.ceil(tmp.doubleValue());
            BigDecimal QtyEntered = new BigDecimal(QtyConvert).multiply(C_UOM_ID.getDivideRate());
            mTab.setValue("Z_QtyCarton", (Object)QtyConvert);
            mTab.setValue("MovementQty", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
        }
        return "";
    }

    public void setLocatorProduct(Properties ctx, GridTab mTab, int WindowNo, int M_Product_ID, BigDecimal MovementQty) {
        int M_Locator_ID;
        if (M_Product_ID != 0 && (M_Locator_ID = DB.getSQLValue(null, "SELECT COALESCE(M_Locator_ID,0) FROM M_Product WHERE M_Product_ID =" + M_Product_ID)) != 0 && M_Locator_ID != -1) {
            mTab.setValue("M_Locator_ID", (Object)M_Locator_ID);
        }
    }
}

