/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInventoryLine;
import org.compiere.model.Query;
import org.compiere.model.X_C_UOM_Conversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutInventory
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer InventoryLine = (Integer)mTab.getValue("M_InventoryLine_ID");
        BigDecimal bd = null;
        if (InventoryLine != null && InventoryLine != 0) {
            MInventoryLine _ILine = new MInventoryLine(ctx, InventoryLine, null);
            Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
            Integer M_Locator_ID = (Integer)mTab.getValue("M_Locator_ID");
            Integer M_AttributeSetInstance_ID = 0;
            if (M_Product_ID != null && M_Product_ID.intValue() != _ILine.getM_Product_ID() || M_Locator_ID != null && M_Locator_ID.intValue() != _ILine.getM_Locator_ID()) {
                if (M_Product_ID.intValue() == _ILine.getM_Product_ID()) {
                    M_AttributeSetInstance_ID = (Integer)mTab.getValue("M_AttributeSetInstance_ID");
                    if (M_AttributeSetInstance_ID == null) {
                        M_AttributeSetInstance_ID = 0;
                    }
                } else {
                    mTab.setValue("M_AttributeSetInstance_ID", null);
                }
                try {
                    bd = this.setQtyBook(M_AttributeSetInstance_ID, M_Product_ID, M_Locator_ID);
                    mTab.setValue("QtyBook", (Object)bd);
                }
                catch (Exception e) {
                    return mTab.setValue("QtyBook", (Object)bd);
                }
            }
            return "";
        }
        int M_Product_ID = 0;
        Integer Product = (Integer)mTab.getValue("M_Product_ID");
        if (Product != null) {
            M_Product_ID = Product;
        }
        if (M_Product_ID == 0) {
            return "";
        }
        int M_Locator_ID = 0;
        Integer Locator2 = (Integer)mTab.getValue("M_Locator_ID");
        if (Locator2 != null) {
            M_Locator_ID = Locator2;
        }
        if (M_Locator_ID == 0) {
            return "";
        }
        int M_AttributeSetInstance_ID = 0;
        Integer ASI = (Integer)mTab.getValue("M_AttributeSetInstance_ID");
        if (ASI != null) {
            M_AttributeSetInstance_ID = ASI;
        }
        if ("M_Product_ID".equals(mField.getColumnName())) {
            M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID ? Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") : 0;
            if (M_AttributeSetInstance_ID != 0) {
                mTab.setValue("M_AttributeSetInstance_ID", (Object)M_AttributeSetInstance_ID);
            } else {
                mTab.setValue("M_AttributeSetInstance_ID", null);
            }
        }
        try {
            bd = this.setQtyBook(M_AttributeSetInstance_ID, M_Product_ID, M_Locator_ID);
            mTab.setValue("QtyBook", (Object)bd);
        }
        catch (Exception e) {
            return mTab.setValue("QtyBook", (Object)bd);
        }
        this.log.info("M_Product_ID=" + M_Product_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + " - QtyBook=" + bd);
        return "";
    }

    private BigDecimal setQtyBook(int M_AttributeSetInstance_ID, int M_Product_ID, int M_Locator_ID) throws Exception {
        BigDecimal bd = null;
        String sql = "SELECT QtyOnHand FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=?";
        if (M_AttributeSetInstance_ID == 0) {
            sql = "SELECT SUM(QtyOnHand) FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=?";
        }
        try {
            ResultSet rs;
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                bd = rs.getBigDecimal(1);
                if (bd != null) {
                    return bd;
                }
            } else {
                return new BigDecimal(0);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            throw new Exception(e.getLocalizedMessage());
        }
        return new BigDecimal(0);
    }

    public String setQtyConvert(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        X_C_UOM_Conversion C_UOM_ID = (X_C_UOM_Conversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ?", null).setOnlyActiveRecords(true).setParameters(M_Product_ID).first();
        if (mTab.getAD_Tab_ID() == 256) {
            if (mField.getColumnName().equals("QtyCount")) {
                if (C_UOM_ID == null) {
                    mTab.setValue("Z_QtyCarton", (Object)((BigDecimal)mTab.getValue("QtyCount")).intValue());
                } else {
                    BigDecimal tmp = ((BigDecimal)mTab.getValue("QtyCount")).divide(C_UOM_ID.getDivideRate(), 2, RoundingMode.HALF_UP);
                    Integer QtyConvert = (int)Math.ceil(tmp.doubleValue());
                    BigDecimal QtyEntered = new BigDecimal(QtyConvert).multiply(C_UOM_ID.getDivideRate());
                    mTab.setValue("Z_QtyCarton", (Object)QtyConvert);
                    mTab.setValue("QtyCount", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                }
            } else if (mField.getColumnName().equals("Z_QtyCarton")) {
                if (C_UOM_ID == null) {
                    mTab.setValue("QtyCount", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")));
                } else {
                    mTab.setValue("QtyCount", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")).multiply(C_UOM_ID.getDivideRate()).setScale(4, RoundingMode.HALF_UP));
                }
            }
        } else if (mTab.getAD_Tab_ID() == 683) {
            if (mField.getColumnName().equals("QtyInternalUse")) {
                if (C_UOM_ID == null) {
                    mTab.setValue("Z_QtyCarton", (Object)((BigDecimal)mTab.getValue("QtyInternalUse")).intValue());
                } else {
                    BigDecimal tmp = ((BigDecimal)mTab.getValue("QtyInternalUse")).divide(C_UOM_ID.getDivideRate(), 2, RoundingMode.HALF_UP);
                    Integer QtyConvert = (int)Math.ceil(tmp.doubleValue());
                    BigDecimal QtyEntered = new BigDecimal(QtyConvert).multiply(C_UOM_ID.getDivideRate());
                    mTab.setValue("Z_QtyCarton", (Object)QtyConvert);
                    mTab.setValue("QtyInternalUse", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
                }
            } else if (mField.getColumnName().equals("Z_QtyCarton")) {
                if (C_UOM_ID == null) {
                    mTab.setValue("QtyInternalUse", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")));
                } else {
                    mTab.setValue("QtyInternalUse", (Object)new BigDecimal((Integer)mTab.getValue("Z_QtyCarton")).multiply(C_UOM_ID.getDivideRate()).setScale(4, RoundingMode.HALF_UP));
                }
            }
            this.noZero(ctx, WindowNo, mTab, mField, value);
        }
        return "";
    }

    public String initConvert(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        X_C_UOM_Conversion C_UOM_ID = (X_C_UOM_Conversion)new Query(ctx, "C_UOM_Conversion", " M_Product_ID = ?", null).setOnlyActiveRecords(true).setParameters(M_Product_ID).first();
        if (C_UOM_ID == null) {
            mTab.setValue("Z_QtyCarton", (Object)((BigDecimal)mTab.getValue("QtyCount")).intValue());
        } else {
            BigDecimal tmp = ((BigDecimal)mTab.getValue("QtyCount")).divide(C_UOM_ID.getDivideRate(), 2, RoundingMode.HALF_UP);
            Integer QtyConvert = (int)Math.ceil(tmp.doubleValue());
            BigDecimal QtyEntered = new BigDecimal(QtyConvert).multiply(C_UOM_ID.getDivideRate());
            mTab.setValue("Z_QtyCarton", (Object)QtyConvert);
            mTab.setValue("QtyCount", (Object)QtyEntered.setScale(4, RoundingMode.HALF_UP));
        }
        return "";
    }

    public String noZero(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null) {
            return "";
        }
        BigDecimal qty = null;
        if (mField.getColumnName().equals("M_Product_ID")) {
            Integer C_DocType_ID = DB.getSQLValue(null, "SELECT C_Doctype_ID FROM M_Inventory WHERE M_Inventory_ID = " + mTab.getValue("M_Inventory_ID"));
            qty = C_DocType_ID == 1000050 ? (BigDecimal)mTab.getValue("QtyInternalUse") : (BigDecimal)mTab.getValue("QtyCount");
        } else if (mField.getColumnName().equals("QtyInternalUse")) {
            qty = (BigDecimal)mTab.getValue("QtyInternalUse");
        } else if (mField.getColumnName().equals("QtyCount")) {
            qty = (BigDecimal)mTab.getValue("QtyCount");
        }
        if (qty == null) {
            return "";
        }
        if (qty.compareTo(Env.ZERO) == 0) {
            mTab.fireDataStatusEEvent("Erreur : Il est impossible d'utiliser une quantit\u00e9 \u00e9gale \u00e0 0 d'un article.", null, true);
        }
        return "";
    }
}

