/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.GridTab;
import org.compiere.model.MAsset;
import org.compiere.model.MBPartner;
import org.compiere.model.MCampaign;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MQuery;
import org.compiere.model.MRMA;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ARequest
implements ActionListener {
    private int m_AD_Table_ID;
    private int m_Record_ID;
    private int m_C_BPartner_ID;
    private JPopupMenu m_popup = new JPopupMenu("RequestMenu");
    private CMenuItem m_new = null;
    private CMenuItem m_active = null;
    private CMenuItem m_all = null;
    private GraphicsConfiguration m_graphicsconfig = null;
    StringBuffer m_where = null;
    private static CLogger log = CLogger.getCLogger(ARequest.class);

    public ARequest(JComponent invoker, int AD_Table_ID, int Record_ID, int C_BPartner_ID) {
        log.config("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.getRequests(invoker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRequests(JComponent invoker) {
        this.m_new = new CMenuItem(Msg.getMsg(Env.getCtx(), "RequestNew"));
        this.m_new.setIcon(Env.getImageIcon("New16.gif"));
        this.m_popup.add(this.m_new).addActionListener(this);
        this.m_graphicsconfig = invoker.getGraphicsConfiguration();
        int activeCount = 0;
        int inactiveCount = 0;
        this.m_where = new StringBuffer();
        this.m_where.append("(AD_Table_ID=").append(this.m_AD_Table_ID).append(" AND Record_ID=").append(this.m_Record_ID).append(")");
        if (this.m_AD_Table_ID == MUser.Table_ID) {
            this.m_where.append(" OR AD_User_ID=").append(this.m_Record_ID).append(" OR SalesRep_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MBPartner.Table_ID) {
            this.m_where.append(" OR C_BPartner_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MOrder.Table_ID) {
            this.m_where.append(" OR C_Order_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MInvoice.Table_ID) {
            this.m_where.append(" OR C_Invoice_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MPayment.Table_ID) {
            this.m_where.append(" OR C_Payment_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MProduct.Table_ID) {
            this.m_where.append(" OR M_Product_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MProject.Table_ID) {
            this.m_where.append(" OR C_Project_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MCampaign.Table_ID) {
            this.m_where.append(" OR C_Campaign_ID=").append(this.m_Record_ID);
        } else if (this.m_AD_Table_ID == MAsset.Table_ID) {
            this.m_where.append(" OR A_Asset_ID=").append(this.m_Record_ID);
        }
        String sql = "SELECT Processed, COUNT(*) FROM R_Request WHERE " + this.m_where + " GROUP BY Processed " + "ORDER BY Processed DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if ("Y".equals(rs.getString(1))) {
                    inactiveCount = rs.getInt(2);
                    continue;
                }
                activeCount += rs.getInt(2);
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (activeCount > 0) {
            this.m_active = new CMenuItem(Msg.getMsg(Env.getCtx(), "RequestActive") + " (" + activeCount + ")");
            this.m_popup.add(this.m_active).addActionListener(this);
        }
        if (inactiveCount > 0) {
            this.m_all = new CMenuItem(Msg.getMsg(Env.getCtx(), "RequestAll") + " (" + (activeCount + inactiveCount) + ")");
            this.m_popup.add(this.m_all).addActionListener(this);
        }
        if (invoker.isShowing()) {
            this.m_popup.show(invoker, 0, invoker.getHeight());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MQuery query = null;
        if (e.getSource() == this.m_active) {
            query = new MQuery("");
            String where = "(" + this.m_where + ") AND Processed='N'";
            query.addRestriction(where);
            query.setRecordCount(0);
        } else if (e.getSource() == this.m_all) {
            query = new MQuery("");
            query.addRestriction(this.m_where.toString());
            query.setRecordCount(0);
        } else if (e.getSource() == this.m_new) {
            query = new MQuery("");
            query.addRestriction("1=2");
            query.setRecordCount(0);
        }
        int AD_Window_ID = 232;
        AWindow frame = new AWindow(this.m_graphicsconfig);
        if (!frame.initWindow(AD_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (e.getSource() == this.m_new) {
            MOrderLine oLine;
            GridTab tab = frame.getAPanel().getCurrentTab();
            tab.dataNew(false);
            tab.setValue("AD_Table_ID", (Object)new Integer(this.m_AD_Table_ID));
            tab.setValue("Record_ID", (Object)new Integer(this.m_Record_ID));
            if (this.m_C_BPartner_ID != 0) {
                tab.setValue("C_BPartner_ID", (Object)new Integer(this.m_C_BPartner_ID));
            }
            if (this.m_AD_Table_ID == MBPartner.Table_ID) {
                tab.setValue("C_BPartner_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MUser.Table_ID) {
                tab.setValue("AD_User_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MProject.Table_ID) {
                tab.setValue("C_Project_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MAsset.Table_ID) {
                tab.setValue("A_Asset_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MOrder.Table_ID) {
                tab.setValue("C_Order_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MInvoice.Table_ID) {
                tab.setValue("C_Invoice_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MProduct.Table_ID) {
                tab.setValue("M_Product_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MPayment.Table_ID) {
                tab.setValue("C_Payment_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MInOut.Table_ID) {
                tab.setValue("M_InOut_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MRMA.Table_ID) {
                tab.setValue("M_RMA_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MCampaign.Table_ID) {
                tab.setValue("C_Campaign_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MRequest.Table_ID) {
                tab.setValue("R_RequestRelated_ID", (Object)new Integer(this.m_Record_ID));
            } else if (this.m_AD_Table_ID == MOrderLine.Table_ID && (oLine = new MOrderLine(Env.getCtx(), this.m_Record_ID, null)) != null) {
                tab.setValue("C_Order_ID", (Object)new Integer(oLine.getC_Order_ID()));
            }
        }
        AEnv.showCenterScreen(frame);
        frame = null;
    }
}

