/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.compiere.Adempiere;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.EMailDialog;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trace;
import org.compiere.util.Util;

public final class ADialog {
    public static boolean showDialog = true;
    private static CLogger log = CLogger.getCLogger(ADialog.class);

    public static void info(int WindowNo, Container c, String clearHeading, String clearMessage, String clearText) {
        Window parent;
        log.info(clearHeading + ": " + clearMessage + " " + clearText);
        String out = clearMessage;
        if (clearText != null && !clearText.equals("")) {
            out = out + "\n" + clearText;
        }
        if ((parent = Env.getParent(c)) == null) {
            parent = Env.getWindow(WindowNo);
        }
        if (showDialog && parent != null) {
            if (parent instanceof JFrame) {
                new ADialogDialog((Frame)((JFrame)parent), clearHeading, out, 1);
            } else {
                new ADialogDialog((Dialog)((JDialog)parent), clearHeading, out, 1);
            }
        } else {
            JOptionPane.showMessageDialog(parent, out + "\n", clearHeading, 1);
        }
    }

    public static void info(int WindowNo, Container c, String AD_Message, String msg) {
        Window parent;
        log.info(AD_Message + " - " + msg);
        Properties ctx = Env.getCtx();
        StringBuffer out = new StringBuffer();
        if (AD_Message != null && !AD_Message.equals("")) {
            out.append(Msg.getMsg(ctx, AD_Message));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        if ((parent = Env.getParent(c)) == null) {
            parent = Env.getWindow(WindowNo);
        }
        if (showDialog && parent != null) {
            if (parent instanceof JFrame) {
                new ADialogDialog((Frame)((JFrame)parent), Env.getHeader(ctx, WindowNo), out.toString(), 1);
            } else {
                new ADialogDialog((Dialog)((JDialog)parent), Env.getHeader(ctx, WindowNo), out.toString(), 1);
            }
        } else {
            JOptionPane.showMessageDialog(parent, out.toString() + "\n", Env.getHeader(ctx, WindowNo), 1);
        }
    }

    public static void info(int WindowNo, Container c, String AD_Message) {
        ADialog.info(WindowNo, c, AD_Message, null);
    }

    public static void warn(int WindowNo, Container c, String AD_Message, String msg) {
        Window parent;
        log.info(AD_Message + " - " + msg);
        Properties ctx = Env.getCtx();
        StringBuffer out = new StringBuffer();
        if (AD_Message != null && !AD_Message.equals("")) {
            out.append(Msg.getMsg(ctx, AD_Message));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        if ((parent = Env.getParent(c)) == null) {
            parent = Env.getWindow(WindowNo);
        }
        if (showDialog && parent != null) {
            if (parent instanceof JFrame) {
                new ADialogDialog((Frame)((JFrame)parent), Env.getHeader(ctx, WindowNo), out.toString(), 2);
            } else {
                new ADialogDialog((Dialog)((JDialog)parent), Env.getHeader(ctx, WindowNo), out.toString(), 2);
            }
        } else {
            JOptionPane.showMessageDialog(parent, out.toString() + "\n", Env.getHeader(ctx, WindowNo), 2);
        }
    }

    public static void warn(int WindowNo, Container c, String AD_Message) {
        ADialog.warn(WindowNo, c, AD_Message, null);
    }

    public static void error(int WindowNo, Container c, String AD_Message, String msg) {
        Window parent;
        log.info(AD_Message + " - " + msg);
        if (CLogMgt.isLevelFinest()) {
            Trace.printStack();
        }
        Properties ctx = Env.getCtx();
        StringBuffer out = new StringBuffer();
        if (AD_Message != null && !AD_Message.equals("")) {
            out.append(Msg.getMsg(ctx, AD_Message));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        if ((parent = Env.getParent(c)) == null) {
            parent = Env.getWindow(WindowNo);
        }
        if (showDialog && parent != null) {
            if (parent instanceof JFrame) {
                new ADialogDialog((Frame)((JFrame)parent), Env.getHeader(ctx, WindowNo), out.toString(), 0);
            } else if (parent instanceof JDialog) {
                new ADialogDialog((Dialog)((JDialog)parent), Env.getHeader(ctx, WindowNo), out.toString(), 0);
            }
        } else {
            JOptionPane.showMessageDialog(Env.getWindow(WindowNo), out.toString() + "\n", Env.getHeader(ctx, WindowNo), 0);
        }
    }

    public static void error(int WindowNo, Container c, String AD_Message) {
        ADialog.error(WindowNo, c, AD_Message, null);
    }

    public static boolean ask(int WindowNo, Container c, String AD_Message, String msg) {
        Window parent;
        log.info(AD_Message + " - " + msg);
        Properties ctx = Env.getCtx();
        StringBuffer out = new StringBuffer();
        if (AD_Message != null && !AD_Message.equals("")) {
            out.append(Msg.getMsg(ctx, AD_Message));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        if ((parent = Env.getParent(c)) == null) {
            parent = Env.getWindow(WindowNo);
        }
        boolean retValue = false;
        if (showDialog && parent != null) {
            ADialogDialog d;
            retValue = parent instanceof JFrame ? (d = new ADialogDialog((Frame)((JFrame)parent), Env.getHeader(ctx, WindowNo), out.toString(), 3)).getReturnCode() == ADialogDialog.A_OK : (d = new ADialogDialog((Dialog)((JDialog)parent), Env.getHeader(ctx, WindowNo), out.toString(), 3)).getReturnCode() == ADialogDialog.A_OK;
        } else {
            Object[] optionsOC = new Object[]{Util.cleanAmp(Msg.getMsg(ctx, "OK")), Util.cleanAmp(Msg.getMsg(ctx, "Cancel"))};
            int i = JOptionPane.showOptionDialog(parent, out.toString() + "\n", Env.getHeader(ctx, WindowNo), -1, 3, null, optionsOC, optionsOC[0]);
            retValue = i == 0;
        }
        return retValue;
    }

    public static boolean ask(int WindowNo, Container c, String AD_Message) {
        return ADialog.ask(WindowNo, c, AD_Message, null);
    }

    public static void clear(int WindowNo, Container c, String ParseString) {
        Window parent;
        log.info("Dialog.clear: " + ParseString);
        Properties ctx = Env.getCtx();
        String parse = Env.parseContext(ctx, WindowNo, ParseString, false);
        if (parse.length() == 0) {
            parse = "ERROR parsing: " + ParseString;
        }
        if ((parent = Env.getParent(c)) == null) {
            parent = Env.getWindow(WindowNo);
        }
        if (showDialog && parent != null) {
            if (parent instanceof JFrame) {
                new ADialogDialog((Frame)((JFrame)parent), Env.getHeader(ctx, WindowNo), "=> " + parse, 1);
            } else {
                new ADialogDialog((Dialog)((JDialog)parent), Env.getHeader(ctx, WindowNo), "=> " + parse, 1);
            }
        } else {
            JOptionPane.showMessageDialog(parent, "=> " + parse + "\n", Env.getHeader(ctx, WindowNo), 1);
        }
    }

    public static void clear(int WindowNo, Container c, String ParseString, boolean condition) {
        if (!condition) {
            return;
        }
        ADialog.clear(WindowNo, c, ParseString);
        if (WindowNo == 0) {
            log.log(Level.SEVERE, "WIndowNo == 0");
        }
    }

    public static void clear(String ParseString) {
        ADialog.clear(0, null, ParseString);
    }

    public static void createSupportEMail(Dialog owner, String subject, String message) {
        log.config("ADialog.createSupportEMail");
        String to = Adempiere.getSupportEMail();
        MUser from = MUser.get(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()));
        StringBuffer myMessage = new StringBuffer(message);
        myMessage.append("\n");
        CLogMgt.getInfo(myMessage);
        CLogMgt.getInfoDetail(myMessage, Env.getCtx());
        ModelValidationEngine.get().getInfoDetail(myMessage, Env.getCtx());
        EMailDialog emd = new EMailDialog(owner, Msg.getMsg(Env.getCtx(), "EMailSupport"), from, to, "Support: " + subject, myMessage.toString(), null);
    }

    public static void createSupportEMail(Frame owner, String subject, String message) {
        log.config("ADialog.createSupportEMail");
        String to = Adempiere.getSupportEMail();
        MUser from = MUser.get(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()));
        StringBuffer myMessage = new StringBuffer(message);
        myMessage.append("\n");
        CLogMgt.getInfo(myMessage);
        CLogMgt.getInfoDetail(myMessage, Env.getCtx());
        ModelValidationEngine.get().getInfoDetail(myMessage, Env.getCtx());
        EMailDialog emd = new EMailDialog(owner, Msg.getMsg(Env.getCtx(), "EMailSupport"), from, to, "Support: " + subject, myMessage.toString(), null);
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }
}

