/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.X_ASP_Field;
import org.compiere.model.X_ASP_Process;
import org.compiere.model.X_ASP_Process_Para;
import org.compiere.model.X_ASP_Tab;
import org.compiere.model.X_ASP_Workflow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.wf.MWorkflow;

public class ASPGenerateFields
extends SvrProcess {
    private String p_ASP_Status;
    private int p_ASP_Level_ID;
    private int noFields = 0;
    private int noProcesses = 0;
    private int noParameters = 0;
    private int noWorkflows = 0;
    private int p_ASP_Tab_ID;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("ASP_Status")) {
                this.p_ASP_Status = (String)para.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_ASP_Tab_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("ASP_Status=" + this.p_ASP_Status + ", ASP_Tab_ID=" + this.p_ASP_Tab_ID);
        X_ASP_Tab asptab = new X_ASP_Tab(this.getCtx(), this.p_ASP_Tab_ID, this.get_TrxName());
        this.p_ASP_Level_ID = asptab.getASP_Window().getASP_Level_ID();
        MTab tab = new MTab(this.getCtx(), asptab.getAD_Tab_ID(), this.get_TrxName());
        for (MField field : tab.getFields(true, this.get_TrxName())) {
            MColumn column;
            if (DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Field WHERE ASP_Tab_ID = ? AND AD_Field_ID = ?", this.p_ASP_Tab_ID, field.getAD_Field_ID()) < 1) {
                X_ASP_Field aspField = new X_ASP_Field(this.getCtx(), 0, this.get_TrxName());
                aspField.setASP_Tab_ID(this.p_ASP_Tab_ID);
                aspField.setAD_Field_ID(field.getAD_Field_ID());
                aspField.setASP_Status(this.p_ASP_Status);
                if (aspField.save()) {
                    ++this.noFields;
                }
            }
            if ((column = MColumn.get(this.getCtx(), field.getAD_Column_ID())).getAD_Reference_ID() != 28 || column.getAD_Process_ID() <= 0) continue;
            this.generateProcess(column.getAD_Process_ID());
        }
        if (this.noFields > 0) {
            this.addLog("Field " + this.noFields);
        }
        if (this.noProcesses > 0) {
            this.addLog("Process " + this.noProcesses);
        }
        if (this.noParameters > 0) {
            this.addLog("Process Parameter " + this.noParameters);
        }
        if (this.noWorkflows > 0) {
            this.addLog("Workflow " + this.noWorkflows);
        }
        return "@OK@";
    }

    private void generateProcess(int p_AD_Process_ID) {
        MProcess process = new MProcess(this.getCtx(), p_AD_Process_ID, this.get_TrxName());
        int asp_process_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Process WHERE ASP_Level_ID = ? AND AD_Process_ID = ?", this.p_ASP_Level_ID, process.getAD_Process_ID());
        X_ASP_Process aspProcess = null;
        if (asp_process_id < 1) {
            aspProcess = new X_ASP_Process(this.getCtx(), 0, this.get_TrxName());
            aspProcess.setASP_Level_ID(this.p_ASP_Level_ID);
            aspProcess.setAD_Process_ID(process.getAD_Process_ID());
            aspProcess.setASP_Status(this.p_ASP_Status);
            if (aspProcess.save()) {
                ++this.noProcesses;
                asp_process_id = aspProcess.getASP_Process_ID();
            }
        } else {
            aspProcess = new X_ASP_Process(this.getCtx(), asp_process_id, this.get_TrxName());
        }
        for (MProcessPara processpara : process.getParameters()) {
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Process_Para WHERE ASP_Process_ID = ? AND AD_Process_Para_ID = ?", asp_process_id, processpara.getAD_Process_Para_ID()) >= 1) continue;
            X_ASP_Process_Para aspProcess_Para = new X_ASP_Process_Para(this.getCtx(), 0, this.get_TrxName());
            aspProcess_Para.setASP_Process_ID(asp_process_id);
            aspProcess_Para.setAD_Process_Para_ID(processpara.getAD_Process_Para_ID());
            aspProcess_Para.setASP_Status(this.p_ASP_Status);
            if (!aspProcess_Para.save()) continue;
            ++this.noParameters;
        }
        if (process.getAD_Workflow_ID() > 0) {
            this.generateWorkflow(process.getAD_Workflow_ID());
        }
    }

    private void generateWorkflow(int p_AD_Workflow_ID) {
        MWorkflow workflow = new MWorkflow(this.getCtx(), p_AD_Workflow_ID, this.get_TrxName());
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Workflow WHERE ASP_Level_ID = ? AND AD_Workflow_ID = ?", this.p_ASP_Level_ID, workflow.getAD_Workflow_ID()) < 1) {
            X_ASP_Workflow aspWorkflow = new X_ASP_Workflow(this.getCtx(), 0, this.get_TrxName());
            aspWorkflow.setASP_Level_ID(this.p_ASP_Level_ID);
            aspWorkflow.setAD_Workflow_ID(workflow.getAD_Workflow_ID());
            aspWorkflow.setASP_Status(this.p_ASP_Status);
            if (aspWorkflow.save()) {
                ++this.noWorkflows;
            }
        }
    }
}

