/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plaf;

import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.basic.BasicButtonListener;

public class AdempiereButtonListener
extends BasicButtonListener {
    public AdempiereButtonListener(AbstractButton b) {
        super(b);
    }

    @Override
    public void installKeyboardActions(JComponent c) {
        super.installKeyboardActions(c);
        this.updateMnemonicBindingX((AbstractButton)c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("mnemonic")) {
            this.updateMnemonicBindingX((AbstractButton)e.getSource());
        } else {
            super.propertyChange(e);
        }
    }

    void updateMnemonicBindingX(AbstractButton b) {
        int m = b.getMnemonic();
        if (m != 0) {
            InputMap map = SwingUtilities.getUIInputMap(b, 2);
            if (map == null) {
                map = new ComponentInputMapUIResource(b);
                SwingUtilities.replaceUIInputMap(b, 2, map);
            }
            map.clear();
            String className = b.getClass().getName();
            int mask = 8;
            if (b instanceof JCheckBox || className.indexOf("VButton") != -1) {
                mask = 3;
            }
            map.put(KeyStroke.getKeyStroke(m, mask, false), "pressed");
            map.put(KeyStroke.getKeyStroke(m, mask, true), "released");
            map.put(KeyStroke.getKeyStroke(m, 0, true), "released");
        } else {
            InputMap map = SwingUtilities.getUIInputMap(b, 2);
            if (map != null) {
                map.clear();
            }
        }
    }
}

