/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.DatabaseAccessException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.PreferenceElementHandler;
import org.adempiere.pipo.handler.TabElementHandler;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_Window;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WindowElementHandler
extends AbstractElementHandler {
    private TabElementHandler tabHandler = new TabElementHandler();
    private PreferenceElementHandler preferenceHandler = new PreferenceElementHandler();
    private List<Integer> windows = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("Name");
        int id = this.get_ID(ctx, "AD_Window", name);
        if (id > 0 && this.windows.contains(id)) {
            return;
        }
        MWindow m_Window = new MWindow(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Window_ID") != null && Integer.parseInt(atts.getValue("AD_Window_ID")) <= 999999) {
            m_Window.setAD_Window_ID(Integer.parseInt(atts.getValue("AD_Window_ID")));
        }
        String Object_Status = null;
        int AD_Backup_ID = -1;
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Window", m_Window);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Window.setName(name);
        name = atts.getValue("ADImageNameID");
        if (name != null && name.trim().length() > 0 && (id = this.get_IDWithColumn(ctx, "AD_Image", "Name", name)) > 0) {
            m_Window.setAD_Image_ID(id);
        }
        if ((name = atts.getValue("ADColorNameID")) != null && name.trim().length() > 0 && (id = this.get_IDWithColumn(ctx, "AD_Color", "Name", name)) > 0) {
            m_Window.setAD_Color_ID(id);
        }
        m_Window.setDescription(this.getStringValue(atts, "Description"));
        m_Window.setEntityType(atts.getValue("EntityType"));
        m_Window.setHelp(this.getStringValue(atts, "Help"));
        m_Window.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_Window.setIsBetaFunctionality(Boolean.valueOf(atts.getValue("isBetaFunctionality")));
        m_Window.setIsDefault(Boolean.valueOf(atts.getValue("isDefault")));
        m_Window.setIsSOTrx(Boolean.valueOf(atts.getValue("isSOTrx")));
        m_Window.setName(atts.getValue("Name"));
        m_Window.setProcessing(false);
        if (!Util.isEmpty(atts.getValue("WinHeight"), true)) {
            m_Window.setWinWidth(this.getValueInt(atts, "WinWidth", 0));
        }
        if (!Util.isEmpty(atts.getValue("WinHeight"), true)) {
            m_Window.setWinHeight(this.getValueInt(atts, "WinHeight", 0));
        }
        m_Window.setWindowType(atts.getValue("WindowType"));
        if (m_Window.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Window.getName(), "Window", m_Window.get_ID(), AD_Backup_ID, Object_Status, "AD_Window", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Window"));
            element.recordId = m_Window.getAD_Window_ID();
            this.windows.add(m_Window.getAD_Window_ID());
            return;
        }
        this.record_log(ctx, 0, m_Window.getName(), "Window", m_Window.get_ID(), AD_Backup_ID, Object_Status, "AD_Window", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Window"));
        throw new POSaveFailedException("Window");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        ResultSet rs;
        int AD_Window_ID = Env.getContextAsInt(ctx, "AD_Window_ID");
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        X_AD_Window m_Window = new X_AD_Window(ctx, AD_Window_ID, null);
        AttributesImpl atts = new AttributesImpl();
        this.createWindowBinding(atts, m_Window);
        document.startElement("", "", "window", atts);
        String sql = "SELECT * FROM AD_TAB WHERE AD_WINDOW_ID = " + AD_Window_ID + " ORDER BY " + "SeqNo" + "," + "AD_Tab_ID";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                packOut.createTable(rs.getInt("AD_Table_ID"), document);
                this.createTab(ctx, document, rs.getInt("AD_Tab_ID"));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof SQLException) {
                throw new DatabaseAccessException("Failed to export window.", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to export window.", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        document.endElement("", "", "window");
        sql = "SELECT * FROM AD_PREFERENCE WHERE AD_WINDOW_ID = " + AD_Window_ID + " ORDER BY " + "AD_Preference_ID";
        pstmt = null;
        pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createPreference(ctx, document, rs.getInt("AD_Preference_ID"));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof SQLException) {
                throw new DatabaseAccessException("Failed to export window preference.", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to export window preference.", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
    }

    private void createPreference(Properties ctx, TransformerHandler document, int AD_Preference_ID) throws SAXException {
        Env.setContext(ctx, "AD_Preference_ID", AD_Preference_ID);
        this.preferenceHandler.create(ctx, document);
        ctx.remove("AD_Preference_ID");
    }

    private void createTab(Properties ctx, TransformerHandler document, int AD_Tab_ID) throws SAXException {
        Env.setContext(ctx, "AD_Tab_ID", AD_Tab_ID);
        this.tabHandler.create(ctx, document);
        ctx.remove("AD_Tab_ID");
    }

    private AttributesImpl createWindowBinding(AttributesImpl atts, X_AD_Window m_Window) {
        atts.clear();
        if (m_Window.getAD_Window_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Window_ID", "CDATA", Integer.toString(m_Window.getAD_Window_ID()));
        }
        String sql = "SELECT Name FROM AD_Window WHERE AD_Window_ID=?";
        String name = DB.getSQLValueString(null, sql, m_Window.getAD_Window_ID());
        atts.addAttribute("", "", "ADWindowNameID", "CDATA", name);
        if (m_Window.getAD_Image_ID() > 0) {
            sql = "SELECT Name FROM AD_Image WHERE AD_Image_ID=?";
            name = DB.getSQLValueString(null, sql, m_Window.getAD_Image_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADImageNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADImageNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADImageNameID", "CDATA", "");
        }
        if (m_Window.getAD_Color_ID() > 0) {
            sql = "SELECT Name FROM AD_Color WHERE AD_Color_ID=?";
            name = DB.getSQLValueString(null, sql, m_Window.getAD_Color_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADColorNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADColorNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADColorNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "Description", "CDATA", m_Window.getDescription() != null ? m_Window.getDescription() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Window.getEntityType() != null ? m_Window.getEntityType() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_Window.getHelp() != null ? m_Window.getHelp() : "");
        atts.addAttribute("", "", "isBetaFunctionality", "CDATA", m_Window.isBetaFunctionality() ? "true" : "false");
        atts.addAttribute("", "", "isDefault", "CDATA", m_Window.isDefault() ? "true" : "false");
        atts.addAttribute("", "", "isSOTrx", "CDATA", m_Window.isSOTrx() ? "true" : "false");
        atts.addAttribute("", "", "isActive", "CDATA", m_Window.isActive() ? "true" : "false");
        atts.addAttribute("", "", "Name", "CDATA", m_Window.getName() != null ? m_Window.getName() : "");
        atts.addAttribute("", "", "isProcessing", "CDATA", m_Window.isProcessing() ? "true" : "false");
        atts.addAttribute("", "", "WinHeight", "CDATA", m_Window.getWinHeight() > 0 ? "" + m_Window.getWinHeight() : "");
        atts.addAttribute("", "", "WinWidth", "CDATA", m_Window.getWinWidth() > 0 ? "" + m_Window.getWinWidth() : "");
        atts.addAttribute("", "", "WindowType", "CDATA", m_Window.getWindowType() != null ? m_Window.getWindowType() : "");
        return atts;
    }

    protected int getValueInt(Attributes atts, String name, int defaultValue) {
        String value = atts.getValue(name);
        if (Util.isEmpty(value, true)) {
            return defaultValue;
        }
        int i = Integer.parseInt(value.trim());
        return i;
    }
}

