/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SQLStatementElementHandler
extends AbstractElementHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        Object Object_Status = null;
        this.log.info(elementValue);
        Attributes atts = element.attributes;
        String DBType = atts.getValue("DBType");
        String sql = atts.getValue("statement").trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        CPreparedStatement pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            if (DBType.equals("ALL")) {
                int n = pstmt.executeUpdate();
                this.log.info("Executed SQL Statement: " + atts.getValue("statement"));
            } else if (DB.isOracle() && DBType.equals("Oracle")) {
                pstmt.executeUpdate();
                this.log.info("Executed SQL Statement for Oracle: " + atts.getValue("statement"));
            } else if (DB.isPostgreSQL() && (DBType.equals("Postgres") || DBType.equals("PostgreSQL"))) {
                Connection m_con = DB.getConnectionRW(true);
                try {
                    Statement stmt = m_con.createStatement();
                    int n = stmt.executeUpdate(atts.getValue("statement"));
                    this.log.info("Executed SQL Statement for PostgreSQL: " + atts.getValue("statement"));
                    if (m_con != null && !m_con.getAutoCommit()) {
                        m_con.commit();
                    }
                    stmt.close();
                }
                finally {
                    m_con.close();
                }
            }
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "SQLSatement", e);
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        String SQLStatement = Env.getContext(ctx, "SQLStatement");
        String DBType = Env.getContext(ctx, "DBType");
        AttributesImpl atts = new AttributesImpl();
        this.createSQLStatmentBinding(atts, SQLStatement, DBType);
        document.startElement("", "", "SQLStatement", atts);
        document.endElement("", "", "SQLStatement");
    }

    private AttributesImpl createSQLStatmentBinding(AttributesImpl atts, String SqlStatement, String DBType) {
        atts.clear();
        atts.addAttribute("", "", "DBType", "CDATA", DBType);
        atts.addAttribute("", "", "statement", "CDATA", SqlStatement);
        return atts;
    }
}

