/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.LineBoxWrapper;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "legendBackgroundColor";
    public static final String PROPERTY_LEGEND_COLOR = "legendColor";
    public static final String PROPERTY_LEGEND_POSITION = "legendPosition";
    public static final String PROPERTY_SHOW_LEGEND = "showLegend";
    public static final String PROPERTY_SUBTITLE_COLOR = "subtitleColor";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_TITLE_POSITION = "titlePosition";
    public static final String PROPERTY_RENDER_TYPE = "renderType";
    public static final String PROPERTY_THEME = "theme";
    protected byte chartType = 0;
    protected Boolean showLegend = null;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected Color titleColor = null;
    protected Color subtitleColor = null;
    protected Color legendColor = null;
    protected Color legendBackgroundColor = null;
    protected EdgeEnum legendPositionValue = null;
    protected EdgeEnum titlePositionValue = null;
    protected String renderType;
    protected String theme;
    protected JRLineBox lineBox = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private Byte border = null;
    private Byte topBorder = null;
    private Byte leftBorder = null;
    private Byte bottomBorder = null;
    private Byte rightBorder = null;
    private Color borderColor = null;
    private Color topBorderColor = null;
    private Color leftBorderColor = null;
    private Color bottomBorderColor = null;
    private Color rightBorderColor = null;
    private Integer padding = null;
    private Integer topPadding = null;
    private Integer leftPadding = null;
    private Integer bottomPadding = null;
    private Integer rightPadding = null;
    private boolean isShowLegend = false;
    private byte legendPosition;
    private byte titlePosition;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte evaluationTime;
    private Byte legendPositionByte = null;
    private Byte titlePositionByte = null;

    protected JRBaseChart(JRChart chart, JRBaseObjectFactory factory) {
        super(chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = factory.getXyzDataset((JRXyzDataset)chart.getDataset());
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 17: {
                this.dataset = factory.getValueDataset((JRValueDataset)chart.getDataset());
                this.plot = factory.getMeterPlot((JRMeterPlot)chart.getPlot());
                break;
            }
            case 19: {
                this.dataset = null;
                this.plot = factory.getMultiAxisPlot((JRMultiAxisPlot)chart.getPlot());
                break;
            }
            case 9: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 18: {
                this.dataset = factory.getValueDataset((JRValueDataset)chart.getDataset());
                this.plot = factory.getThermometerPlot((JRThermometerPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 20: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 21: {
                this.dataset = factory.getGanttDataset((JRGanttDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.showLegend = chart.getShowLegend();
        this.evaluationTimeValue = chart.getEvaluationTimeValue();
        this.linkType = chart.getLinkType();
        this.linkTarget = chart.getLinkTarget();
        this.titlePositionValue = chart.getTitlePositionValue();
        this.titleColor = chart.getOwnTitleColor();
        this.subtitleColor = chart.getOwnSubtitleColor();
        this.legendColor = chart.getOwnLegendColor();
        this.legendBackgroundColor = chart.getOwnLegendBackgroundColor();
        this.legendPositionValue = chart.getLegendPositionValue();
        this.renderType = chart.getRenderType();
        this.theme = chart.getTheme();
        this.titleFont = new JRBaseFont(this, chart.getTitleFont());
        this.subtitleFont = new JRBaseFont(this, chart.getSubtitleFont());
        this.legendFont = new JRBaseFont(this, chart.getLegendFont());
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.titleExpression = factory.getExpression(chart.getTitleExpression());
        this.subtitleExpression = factory.getExpression(chart.getSubtitleExpression());
        this.anchorNameExpression = factory.getExpression(chart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(chart.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(chart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(chart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(chart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = chart.getBookmarkLevel();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(chart, factory);
        this.customizerClass = chart.getCustomizerClass();
        this.lineBox = chart.getLineBox().clone(this);
    }

    public boolean isShowLegend() {
        return this.showLegend == null ? false : this.showLegend;
    }

    public void setShowLegend(boolean isShowLegend) {
        this.setShowLegend((Boolean)isShowLegend);
    }

    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LEGEND, old, this.showLegend);
    }

    public byte getEvaluationTime() {
        return this.getEvaluationTimeValue().getValue();
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public JRBox getBox() {
        return new LineBoxWrapper(this.getLineBox());
    }

    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public byte getTitlePosition() {
        return this.getTitlePositionValue() == null ? EdgeEnum.TOP.getValue() : this.getTitlePositionValue().getValue();
    }

    public void setTitlePosition(byte titlePosition) {
        this.setTitlePosition(EdgeEnum.getByValue(titlePosition));
    }

    public Byte getTitlePositionByte() {
        return this.getTitlePositionValue() == null ? null : this.getTitlePositionValue().getValueByte();
    }

    public void setTitlePosition(Byte titlePosition) {
        this.setTitlePosition(EdgeEnum.getByValue(titlePosition));
    }

    public EdgeEnum getTitlePositionValue() {
        return this.titlePositionValue;
    }

    public void setTitlePosition(EdgeEnum titlePositionValue) {
        EdgeEnum old = this.titlePositionValue;
        this.titlePositionValue = titlePositionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_POSITION, old, this.titlePositionValue);
    }

    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_COLOR, old, this.titleColor);
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_COLOR, old, this.subtitleColor);
    }

    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, old, this.legendBackgroundColor);
    }

    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_COLOR, old, this.legendColor);
    }

    public byte getLegendPosition() {
        return this.getLegendPositionValue() == null ? EdgeEnum.BOTTOM.getValue() : this.getLegendPositionValue().getValue();
    }

    public void setLegendPosition(byte legendPosition) {
        this.setLegendPosition(EdgeEnum.getByValue(legendPosition));
    }

    public Byte getLegendPositionByte() {
        return this.getLegendPositionValue() == null ? null : this.getLegendPositionValue().getValueByte();
    }

    public void setLegendPosition(Byte legendPosition) {
        this.setLegendPosition(EdgeEnum.getByValue(legendPosition));
    }

    public EdgeEnum getLegendPositionValue() {
        return this.legendPositionValue;
    }

    public void setLegendPosition(EdgeEnum legendPositionValue) {
        EdgeEnum old = this.legendPositionValue;
        this.legendPositionValue = legendPositionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_POSITION, old, this.legendPositionValue);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public String getRenderType() {
        return this.renderType;
    }

    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange(PROPERTY_RENDER_TYPE, old, this.renderType);
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        String old = this.theme;
        this.theme = theme;
        this.getEventSupport().firePropertyChange(PROPERTY_THEME, old, this.theme);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitChart(this);
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode((JRCommonElement)this, ModeEnum.TRANSPARENT);
    }

    public byte getBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getPen());
    }

    public Byte getOwnBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getPen());
    }

    public void setBorder(byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public void setBorder(Byte border) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)this.lineBox.getPen());
    }

    public Color getBorderColor() {
        return this.lineBox.getPen().getLineColor();
    }

    public Color getOwnBorderColor() {
        return this.lineBox.getPen().getOwnLineColor();
    }

    public void setBorderColor(Color borderColor) {
        this.lineBox.getPen().setLineColor(borderColor);
    }

    public int getPadding() {
        return this.lineBox.getPadding();
    }

    public Integer getOwnPadding() {
        return this.lineBox.getOwnPadding();
    }

    public void setPadding(int padding) {
        this.lineBox.setPadding(padding);
    }

    public void setPadding(Integer padding) {
        this.lineBox.setPadding(padding);
    }

    public byte getTopBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getTopPen());
    }

    public Byte getOwnTopBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getTopPen());
    }

    public void setTopBorder(byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public void setTopBorder(Byte topBorder) {
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)this.lineBox.getTopPen());
    }

    public Color getTopBorderColor() {
        return this.lineBox.getTopPen().getLineColor();
    }

    public Color getOwnTopBorderColor() {
        return this.lineBox.getTopPen().getOwnLineColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.lineBox.getTopPen().setLineColor(topBorderColor);
    }

    public int getTopPadding() {
        return this.lineBox.getTopPadding();
    }

    public Integer getOwnTopPadding() {
        return this.lineBox.getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public void setTopPadding(Integer topPadding) {
        this.lineBox.setTopPadding(topPadding);
    }

    public byte getLeftBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getLeftPen());
    }

    public Byte getOwnLeftBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getLeftPen());
    }

    public void setLeftBorder(byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public void setLeftBorder(Byte leftBorder) {
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)this.lineBox.getLeftPen());
    }

    public Color getLeftBorderColor() {
        return this.lineBox.getLeftPen().getLineColor();
    }

    public Color getOwnLeftBorderColor() {
        return this.lineBox.getLeftPen().getOwnLineColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.lineBox.getLeftPen().setLineColor(leftBorderColor);
    }

    public int getLeftPadding() {
        return this.lineBox.getLeftPadding();
    }

    public Integer getOwnLeftPadding() {
        return this.lineBox.getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public void setLeftPadding(Integer leftPadding) {
        this.lineBox.setLeftPadding(leftPadding);
    }

    public byte getBottomBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getBottomPen());
    }

    public Byte getOwnBottomBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getBottomPen());
    }

    public void setBottomBorder(byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public void setBottomBorder(Byte bottomBorder) {
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)this.lineBox.getBottomPen());
    }

    public Color getBottomBorderColor() {
        return this.lineBox.getBottomPen().getLineColor();
    }

    public Color getOwnBottomBorderColor() {
        return this.lineBox.getBottomPen().getOwnLineColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.lineBox.getBottomPen().setLineColor(bottomBorderColor);
    }

    public int getBottomPadding() {
        return this.lineBox.getBottomPadding();
    }

    public Integer getOwnBottomPadding() {
        return this.lineBox.getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.lineBox.setBottomPadding(bottomPadding);
    }

    public byte getRightBorder() {
        return JRPenUtil.getPenFromLinePen(this.lineBox.getRightPen());
    }

    public Byte getOwnRightBorder() {
        return JRPenUtil.getOwnPenFromLinePen(this.lineBox.getRightPen());
    }

    public void setRightBorder(byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public void setRightBorder(Byte rightBorder) {
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)this.lineBox.getRightPen());
    }

    public Color getRightBorderColor() {
        return this.lineBox.getRightPen().getLineColor();
    }

    public Color getOwnRightBorderColor() {
        return this.lineBox.getRightPen().getOwnLineColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.lineBox.getRightPen().setLineColor(rightBorderColor);
    }

    public int getRightPadding() {
        return this.lineBox.getRightPadding();
    }

    public Integer getOwnRightPadding() {
        return this.lineBox.getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public void setRightPadding(Integer rightPadding) {
        this.lineBox.setRightPadding(rightPadding);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    public Object clone() {
        JRBaseChart clone = (JRBaseChart)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        if (this.hyperlinkParameters != null) {
            clone.hyperlinkParameters = new JRHyperlinkParameter[this.hyperlinkParameters.length];
            for (int i = 0; i < this.hyperlinkParameters.length; ++i) {
                clone.hyperlinkParameters[i] = (JRHyperlinkParameter)this.hyperlinkParameters[i].clone();
            }
        }
        if (this.titleExpression != null) {
            clone.titleExpression = (JRExpression)this.titleExpression.clone();
        }
        if (this.subtitleExpression != null) {
            clone.subtitleExpression = (JRExpression)this.subtitleExpression.clone();
        }
        if (this.anchorNameExpression != null) {
            clone.anchorNameExpression = (JRExpression)this.anchorNameExpression.clone();
        }
        if (this.hyperlinkReferenceExpression != null) {
            clone.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            clone.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            clone.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            clone.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        if (this.dataset != null) {
            clone.dataset = (JRChartDataset)this.dataset.clone();
        }
        if (this.plot != null) {
            clone.plot = (JRChartPlot)this.plot.clone(clone);
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
            if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
                this.legendPositionValue = EdgeEnum.getByValue(this.legendPosition);
                this.titlePositionValue = EdgeEnum.getByValue(this.titlePosition);
                this.showLegend = this.isShowLegend;
            } else {
                this.legendPositionValue = EdgeEnum.getByValue(this.legendPositionByte);
                this.titlePositionValue = EdgeEnum.getByValue(this.titlePositionByte);
                this.legendPositionByte = null;
                this.titlePositionByte = null;
            }
        }
    }
}

