/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table;

import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.XmlLoaderReportContext;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class TableReportContextXmlRule
extends Rule {
    private static final Log log = LogFactory.getLog(TableReportContextXmlRule.class);

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String datasetName;
        JRXmlLoader xmlLoader = this.getXmlLoader();
        TableComponent table = this.getTableComponent();
        JRDatasetRun datasetRun = table.getDatasetRun();
        String string = datasetName = datasetRun == null ? null : datasetRun.getDatasetName();
        if (log.isDebugEnabled()) {
            log.debug("Pushing report context for dataset name " + datasetName);
        }
        XmlLoaderReportContext reportContext = new XmlLoaderReportContext(datasetName);
        xmlLoader.pushReportContext(reportContext);
    }

    public void end(String namespace, String name) throws Exception {
        JRXmlLoader xmlLoader = this.getXmlLoader();
        if (log.isDebugEnabled()) {
            log.debug("Popping report context");
        }
        xmlLoader.popReportContext();
    }

    protected JRXmlLoader getXmlLoader() {
        return (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
    }

    protected TableComponent getTableComponent() {
        TableComponent table = null;
        int stackCount = this.digester.getCount();
        for (int idx = 0; idx < stackCount; ++idx) {
            Object stackObject = this.digester.peek(idx);
            if (!(stackObject instanceof TableComponent)) continue;
            table = (TableComponent)stackObject;
            break;
        }
        if (table == null) {
            throw new JRRuntimeException("Could not locate TableComponent object on the digester stack");
        }
        return table;
    }
}

